<?php
// Deposit Planner (CAD) - tiny PHP wrapper app.
// No database. No framework. No drama.
?><!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Deposit Planner (CAD)</title>
  <link rel="stylesheet" href="assets/css/style.css?v=1" />
</head>
<body>
<div class="wrap">
  <h1>Deposit Planner</h1>
  <p>Pick a <b>start date</b> and the app will tell you exactly <i>when</i> to deposit next, instead of letting you vibe your way into financial planning. 🗓️</p>

  <div class="tabs">
    <button id="tabGoalBtn" class="tabbtn active" type="button">Goal-based</button>
    <button id="tabFVBtn" class="tabbtn" type="button">Future value</button>
    <span id="globalPill" class="pill">Currency: CAD • Deposits at end of period</span>
  </div>

  <!-- GOAL TAB -->
  <div id="tabGoal" class="tab active">
    <div class="grid">
      <div class="card">
        <div class="row">
          <div><label for="startDate">Start date</label><input id="startDate" type="date" /></div>
          <div><label for="years">Years</label><input id="years" type="number" min="0" step="0.25" value="10" /></div>
          <div><label for="goal">Desired final amount</label><input id="goal" type="number" min="0" step="0.01" value="100000" /></div>
          <div><label for="rate">Annual interest (%)</label><input id="rate" type="number" step="0.01" value="5" /></div>
          <div><label for="freq">Deposit frequency</label>
            <select id="freq">
              <option value="weekly">Weekly</option>
              <option value="biweekly">Bi-weekly</option>
              <option value="semimonthly">Semi-monthly</option>
              <option value="monthly" selected>Monthly</option>
              <option value="quarterly">Quarterly</option>
              <option value="yearly">Yearly</option>
            </select>
          </div>
        </div>
        <div class="actions">
          <button id="calcBtn" type="button">Calculate</button>
          <button id="exportBtn" type="button" class="ghost" disabled>Export CSV</button>
          <span id="goalPill" class="pill"></span>
        </div>
        <div id="warn" class="warn"></div>
      </div>

      <div class="card">
        <div class="kpi">
          <div class="box"><div class="small">Required deposit</div><div id="deposit" class="num">$0.00</div></div>
          <div class="box"><div class="small">Total deposited</div><div id="totalDeposits" class="num">$0.00</div></div>
          <div class="box"><div class="small">Interest gained</div><div id="interest" class="num">$0.00</div></div>
          <div class="box"><div class="small">Ending balance</div><div id="ending" class="num">$0.00</div></div>
        </div>
        <div style="margin-top:12px">
          <span class="pill">Next deposit date: <b id="nextDepositGoal">—</b></span>
        </div>
        <div class="small" style="margin-top:10px">Dates use real calendar math for monthly/quarterly/yearly (no fake “30 days = a month” shortcuts).</div>
      </div>
    </div>

    <div class="card" style="margin-top:16px">
      <div class="topline">
        <div class="small" id="tableMeta">0 periods</div>
        <div class="small">Table fields use your exact terms.</div>
      </div>
      <div style="max-height:520px;overflow:auto">
        <table id="tbl">
          <thead>
            <tr>
              <th>sn</th>
              <th>deposit date</th>
              <th>this deposit</th>
              <th>total until now</th>
              <th>total deposited</th>
              <th>interest gained</th>
              <th>total until now with added interest</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
      <div class="small" style="margin-top:10px">
        <b>Interpretation:</b> “total until now” = balance at start of period (before interest & deposit). “total until now with added interest” = end-of-period balance after interest <i>and</i> deposit.
      </div>
    </div>
  </div>

  <!-- FV TAB -->
  <div id="tabFV" class="tab">
    <div class="grid">
      <div class="card">
        <div class="row">
          <div><label for="fvStartDate">Start date</label><input id="fvStartDate" type="date" /></div>
          <div><label for="fvYears">Years</label><input id="fvYears" type="number" min="0" step="0.25" value="10" /></div>
          <div><label for="fvDeposit">Deposit amount</label><input id="fvDeposit" type="number" min="0" step="0.01" value="300" /></div>
          <div><label for="fvRate">Annual interest (%)</label><input id="fvRate" type="number" step="0.01" value="5" /></div>
          <div><label for="fvFreq">Deposit frequency</label>
            <select id="fvFreq">
              <option value="weekly">Weekly</option>
              <option value="biweekly">Bi-weekly</option>
              <option value="semimonthly">Semi-monthly</option>
              <option value="monthly" selected>Monthly</option>
              <option value="quarterly">Quarterly</option>
              <option value="yearly">Yearly</option>
            </select>
          </div>
        </div>
        <div class="actions">
          <button id="fvCalcBtn" type="button">Calculate</button>
          <button id="fvExportBtn" type="button" class="ghost" disabled>Export CSV</button>
          <span id="fvPill" class="pill"></span>
        </div>
        <div id="fvWarn" class="warn"></div>
      </div>

      <div class="card">
        <div class="kpi">
          <div class="box"><div class="small">Total deposited</div><div id="fvTotalDeposits" class="num">$0.00</div></div>
          <div class="box"><div class="small">Interest gained</div><div id="fvInterest" class="num">$0.00</div></div>
          <div class="box"><div class="small">Ending balance</div><div id="fvEnding" class="num">$0.00</div></div>
          <div class="box"><div class="small">Periods</div><div id="fvPeriods" class="num">0</div></div>
        </div>
        <div style="margin-top:12px">
          <span class="pill">Next deposit date: <b id="nextDepositFV">—</b></span>
        </div>
      </div>
    </div>

    <div class="card" style="margin-top:16px">
      <div class="topline">
        <div class="small" id="fvTableMeta">0 periods</div>
        <div class="small">Same exact table terms.</div>
      </div>
      <div style="max-height:520px;overflow:auto">
        <table id="fvTbl">
          <thead>
            <tr>
              <th>sn</th>
              <th>deposit date</th>
              <th>this deposit</th>
              <th>total until now</th>
              <th>total deposited</th>
              <th>interest gained</th>
              <th>total until now with added interest</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
      </div>
    </div>
  </div>

</div>

<script src="assets/js/app.js?v=1"></script>
</body>
</html>
