<?php
include_once 'db.php';
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::MYSQL_ATTR_MULTI_STATEMENTS => true, // allow multi-query execution
];

// 2) Turn off foreign-key checks (if your files insert into related tables)
$pdo->exec('SET FOREIGN_KEY_CHECKS = 0;');

// 3) Point to the directory containing your .sql files
$dir = __DIR__.'/sql'; // current folder
// or e.g. '/path/to/sql-files'
foreach (glob($dir . '/*.sql') as $file) {
    echo "Importing “" . basename($file) . "”… ";
    $sql = file_get_contents($file);
    try {
// use exec() if your file is a single statement, or multi_query for multiple
        $pdo->exec($sql);
        echo "✅ OK\n";
    } catch (PDOException $e) {
        echo "❌ Failed: " . $e->getMessage() . "\n";
    }
}

// 4) Re-enable foreign-key checks
$pdo->exec('SET FOREIGN_KEY_CHECKS = 1;');

echo "All done.\n";