<?php
session_start();
if (empty($_SESSION['loggedin'])) {
    header('Location: login.php');
    exit;
}
require 'db.php'; // $pdo is PDO instance
require 'header.php';

// Fetch lookup ranges for client-side checks
$stmt = $pdo->prepare("SELECT category, min_temp, max_temp FROM jaw_temp_lookup");
$stmt->execute();
$lookup = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['reading_date'];
    $time = $_POST['reading_time'];
    $temperature = $_POST['temperature'];
    $username = $_SESSION['username'];

    // Convert HHMM to HH:MM for TIME column
    $formattedTime = substr($time, 0, 2) . ':' . substr($time, 2, 2);

    $insert = $pdo->prepare(
        "INSERT INTO jaw_temp_data (`time`, temperature, username) VALUES (:time, :temperature, :username)"
    );
    $insert->execute([
        ':time' => $formattedTime,
        ':temperature' => $temperature,
        ':username' => $username
    ]);

    header('Location: jaw_temp_form.php?success=1');
    exit;
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-4">Jaw Temperature Entry</h2>

        <?php if (!empty($_GET['success'])): ?>
            <div class="notification is-success">
                Temperature recorded successfully.
            </div>
        <?php endif; ?>

        <form id="tempForm" method="POST" class="box">
            <div class="field">
                <label class="label" for="reading_date">Date</label>
                <div class="control">
                    <input class="input" type="date" id="reading_date" name="reading_date" required>
                </div>
            </div>

            <div class="field">
                <label class="label" for="reading_time">Time (HHMM)</label>
                <div class="control">
                    <input class="input"
                           type="text"
                           id="reading_time"
                           name="reading_time"
                           required
                           pattern="^([01]\d|2[0-3])[0-5]\d$"
                           maxlength="4"
                           inputmode="numeric"
                           placeholder="HHMM"
                           title="Enter time as HHMM (0000–2359)">
                </div>
            </div>

            <div class="field">
                <label class="label" for="temperature">Temperature (&deg;C)</label>
                <div class="control has-icons-left">
                    <input class="input" type="number" step="0.01" id="temperature" name="temperature" required>
                    <span class="icon is-small is-left">
            <i class="fas fa-thermometer-half"></i>
          </span>
                </div>
            </div>

            <div class="field is-grouped is-grouped-right">
                <div class="control">
                    <button class="button is-primary" type="submit">Submit</button>
                </div>
                <div class="control">
                    <button class="button is-light" type="reset">Reset</button>
                </div>
            </div>
        </form>
    </div>
</section>

<script>
    const lookup = <?php echo json_encode($lookup); ?>;
    document.getElementById('tempForm').addEventListener('submit', function(e) {
        const temp = parseFloat(document.getElementById('temperature').value);
        const tooMuch = lookup.find(item => item.category === 'high');
        if (tooMuch && temp >= parseFloat(tooMuch.min_temp) && temp <= parseFloat(tooMuch.max_temp)) {
            if (!confirm('Temperature is too high, do you still want to enter it?')) {
                e.preventDefault();
            }
        }
    });
</script>

<?php include 'footer.php'; ?>
