<?php
session_start();
if (empty($_SESSION['loggedin'])) {
    header('Location: index.php');
    exit;
}
require 'db.php'; // $pdo is PDO instance
require 'header.php';

// Fetch records with category by joining lookup ranges
$stmt = $pdo->prepare(
    "SELECT d.time, d.temperature, d.username, d.entry_timestamp, l.category
     FROM jaw_temp_data d
     JOIN jaw_temp_lookup l
       ON d.temperature BETWEEN l.min_temp AND l.max_temp
     ORDER BY d.entry_timestamp DESC"
);
$stmt->execute();
$records = $stmt->fetchAll(PDO::FETCH_ASSOC);
// if no rows, show a friendly message and stop
if (empty($records)) {
    echo '<section class="section">
            <div class="container">
              <div class="notification is-info has-text-centered">
                No data yet
              </div>
            </div>
          </section>';
    include 'footer.php';
    exit;
}
?>
<section class="section">
    <div class="container">
        <h2 class="title is-4">Jaw Temperature Records</h2>
        <table class="table is-fullwidth">
            <thead>
            <tr>
                <th>SN</th>
                <th>Time</th>
                <th>Temperature</th>
                <th>User</th>
                <th>Category</th>
                <th>Recorded At</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($records as $index => $row):
                // choose Bulma background color based on category
                switch ($row['category']) {
                    case 'good':      $rowClass = 'has-background-success';    break;
                    case 'caution':      $rowClass = 'has-background-warning'; break;
                    case 'high': $rowClass = 'has-background-danger';  break;
                    default:         $rowClass = '';                             break;
                }
                ?>
                <tr class="<?php echo $rowClass; ?>">
                    <td><?php echo $index + 1; ?></td>
                    <td><?php echo htmlspecialchars($row['time']); ?></td>
                    <td><?php echo htmlspecialchars($row['temperature']); ?></td>
                    <td><?php echo htmlspecialchars($row['username']); ?></td>
                    <td><?php echo htmlspecialchars($row['category']); ?></td>
                    <td><?php echo htmlspecialchars($row['entry_timestamp']); ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</section>

<?php include 'footer.php'; ?>
