<?php
// index.php – End User Documentation
// session_start(); // session already started in header.php
include 'header.php';
?>

<style>
    /* Styles for the user status display */
    .user-status {
        text-align: right;
        margin-bottom: 1rem;
    }

    /* Documentation page styles */
    .doc-content {
        background-color: #f9f9f9;
        padding: 2rem;
        border-radius: 6px;
    }

    .doc-content h1 {
        margin-bottom: 1rem;
    }

    .doc-content h2 {
        margin-top: 1.5rem;
    }

    .doc-content ul {
        list-style-type: disc;
        margin-left: 1.5rem;
    }

    .doc-content li {
        margin-bottom: 0.5rem;
    }

    .doc-content .nav-links a {
        margin-right: 1.5rem;
        font-weight: bold;
        color: #be3127;
    }

    p strong {
        color: #be3127;
    }
</style>

<section class="section">
    <div class="container doc-content">
        <!-- User Status Display -->
<!--        <pre>-->
<!--            --><?php //print_r($_SESSION); ?>
<!--        </pre>-->

        <div class="user-status">
            <?php if (isset($_SESSION['user_fullname'])): ?>
                <p>Welcome, <strong><?= htmlspecialchars(
                            $_SESSION['user_fullname']) ?></strong></p>
            <?php elseif (isset($_SESSION['user'])): ?>
                <p>Welcome, <strong><?= htmlspecialchars(
                            $_SESSION['user']) ?></strong></p>
            <?php else: ?>
                <p>Not logged in. <a href="login.php">Log In</a></p>
            <?php endif; ?>
        </div>

        <h1 class="title">206 Downtime Logger – User Guide</h1>

        <!-- Navigation Links -->
        <div class="nav-links">
            <?php if (isset($_SESSION['loggedin'])):
            else: ?>
                <!-- Show this link if the user is not logged in -->
                <a href="login.php">Log In</a>
            <?php endif; ?>
        </div>

        <h2 class="subtitle is-4">Overview</h2>
        <p>This application allows you to log and review downtime events for equipment feeds. Use the bottom navigation
            to switch between data entry, log viewing, and reference tables.</p>

        <h2 class="subtitle is-4">1. Enter Downtime</h2>
        <ul>
            <li><strong>Select Date:</strong> Choose the calendar date for the event.</li>
            <li><strong>Start / Stop Times:</strong> Enter times in <em>HHMM</em> format; total downtime calculates
                automatically.
            </li>
            <li><strong>Feed &amp; Type:</strong> Pick the feed and downtime category.</li>
            <li><strong>Equipment:</strong> Drill down from Type → Subtype → Unit; options filter dynamically.</li>
            <li><strong>Cause &amp; Solution:</strong> Select from predefined lists.</li>
            <li><strong>Remarks:</strong> Add any optional notes.</li>
            <li><strong>Submit:</strong> Click to save; the form resets for additional entries.</li>
        </ul>

        <h2 class="subtitle is-4">2. View Logs</h2>
        <p>Displays all entries grouped by date in a table:</p>
        <ul>
            <li><strong>Date:</strong> Shown once per group.</li>
            <li><strong>SN:</strong> Serial number within the date group.</li>
            <li><strong>Columns:</strong> Start, Stop, Total, Equipment, Unit, Component, Trigger, Cause, Feed,
                Solution, Remarks.
            </li>
            <li><strong>Styling:</strong> Hover highlights, sticky header, and separators between date groups.</li>
        </ul>

        <h2 class="subtitle is-4">3. Reference Data</h2>
        <p>Read-only tables showing:</p>
        <ul>
            <li>Feeds</li>
            <li>Downtime Types</li>
            <li>Equipment Types, Subtypes, Units</li>
            <li>Causes and Solutions</li>
        </ul>

        <h2 class="subtitle is-4">Tips &amp; Support</h2>
        <ul>
            <li>Navigation is always visible: sticky header &amp; footer.</li>
            <li>The form validates required fields before submission.</li>
            <li>Contact your administrator for missing options or questions.</li>
        </ul>
    </div>
</section>

<?php include 'footer.php'; ?>
