<?php
// Turn on output buffering so we can still send headers later
ob_start();

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en-GB">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>206 Downtime</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma@0.9.4/css/bulma.min.css">

    <style>
        /* allow container to span most of the viewport */
        .container.is-fluid {
            max-width: 98vw !important;
        }
        /* ensure the table can scroll horizontally if needed */
        .table-container {
            overflow-x: auto;
        }
        /* wrap long remarks onto multiple lines */
        .table td:last-child {
            white-space: normal !important;
            word-wrap: break-word;
        }
        body {
            margin: 0;
            padding: 0;
            overflow-x: hidden;
            background-color: white;
        }

        .bottom-nav {
            background-color: #ffdd00;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            width: 100vw;
            border-top: 1px solid #ccc;
            z-index: 1000;
            text-align: center;
            padding: 0.5rem;
            box-sizing: border-box;
            overflow: hidden;
        }

        /*.bottom-nav button#navToggle {*/
        /*    margin-bottom: 0.5rem;*/
        /*}*/
        .bottom-nav * {
            box-sizing: border-box;
        }
        #navToggle {
            margin: 0 auto 0.5rem auto;
            border-radius: 0;
            box-shadow: none;
            outline: none;
            border: none;
            background-color: #231f20;
            color: white;
            padding: 0.4rem 1rem;
        }
        button#navToggle {
            margin: 0 auto 0.5rem auto;
            display: block;
            border: none;
            outline: none;
            box-shadow: none;
        }
        .nav-links {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 0.5rem;
        }

        .nav-links a {
            text-decoration: none;
            color: #333;
            font-weight: bold;
            padding: 0.4rem 0.8rem;
            border-radius: 5px;
            white-space: nowrap;
            flex: 1 0 auto;
        }

        /* Hide links on mobile initially */
        @media (max-width: 480px) {
            .nav-links {
                display: none;
                flex-direction: column;
                align-items: center;
            }

            .nav-links.is-active {
                display: flex;
            }
        }


        /* Make header sticky and reduce its height */
        .hero.is-info {
            background-color: #be3127;
            position: sticky;
            top: 0;
            z-index: 1100;
            padding: 0;
        }

        .hero.is-info .hero-body {
            padding: 0.75rem 1.5rem;
        }

        .hero.is-info .title.is-3 {
            font-size: 1.75rem;
        }

        .hero.is-info .subtitle.is-6 {
            font-size: 0.875rem;
        }

        /* Prevent dropdown_data columns from stretching */
        .columns.is-multiline {
            align-items: flex-start;
        }

        /* Interactive table styles */
        .table.interactive {
            border: 1px solid #ddd;
            border-radius: 4px;
            overflow: hidden;
            border-collapse: collapse !important;
            border-spacing: 0 !important;
        }

        /* Zebra-striping */
        .table.interactive tbody tr:nth-child(odd) {
            background-color: #fafafa;
        }

        /* Sticky header */
        .table.interactive thead th {
            background-color: #f5f5f5;
            position: sticky;
            top: 0;
            z-index: 2;
            padding: 0.75rem 1rem;
            border-bottom: 2px solid #ccc;
        }

        /* Row hover effect */
        .table.interactive tbody tr {
            transition: background-color 0.2s ease, transform 0.1s ease;
            cursor: pointer;
        }

        /* Cell borders */
        .table.interactive td,
        .table.interactive th {
            border-bottom: 1px solid #eee;
            padding: 0.75rem 1rem;
        }

        /* Thick top border on each group’s first row (SN=1) */
        .table.interactive tbody tr.date-group > td {
            border-top: 2px solid #be3127 !important;
            padding-top: 0.5rem;
        }

        .button.is-fowler {
            background-color: #231f20;
            color: white;
            margin: 20px 0;
        }

        /* For planned/ unplanned maintenance toggle*/
        /* iPhone-style toggle */
        .switch {
            position: relative;
            display: inline-block;
            width: 50px;
            height: 28px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: 0.4s;
            border-radius: 34px;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 22px;
            width: 22px;
            left: 3px;
            bottom: 3px;
            background-color: white;
            transition: 0.4s;
            border-radius: 50%;
        }

        input:checked + .slider {
            background-color: #4CAF50;
        }

        input:checked + .slider:before {
            transform: translateX(22px);
        }

        /* Remove spinner arrows from number inputs */
        input[type=number]::-webkit-inner-spin-button,
        input[type=number]::-webkit-outer-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        input[type=number] {
            -moz-appearance: textfield;
        }
        .login-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: calc(100vh - 40rem);
        }
    </style>
</head>
<body>
<section class="hero is-info">
    <div class="hero-body" style="display:flex; align-items:center;">
        <figure class="image is-64x64" style="margin-right: 1rem;">
            <img src="logo_two_colors.svg" alt="Project Logo">
        </figure>
        <div class="has-text-centered" style="flex-grow:1;">
            <p class="title is-4">Crushmore Downtime</p>
            <p class="subtitle is-5">We Crush Better</p>
        </div>
    </div>
</section>
<section class="section">
    <div class="container">
