<?php
require 'db.php';
header('Content-Type: application/json');
$timestamp = date("Y-m-d_H-i-s");
$filename = "downtime_export_{$timestamp}.json"; // or .json
//$timestamp = date("Y-m-d_H-i-s");
header("Content-Disposition: attachment; filename=\"downtime_export_{$timestamp}.json\"");

$year  = isset($_GET['year'])  ? (int)$_GET['year']  : null;
$month = isset($_GET['month']) ? (int)$_GET['month'] : null;
$day   = isset($_GET['day'])   ? (int)$_GET['day']   : null;

if (!$year) {
    http_response_code(400);
    echo json_encode(["error" => "Year is required."]);
    exit;
}

$where = "WHERE YEAR(d.date) = :year";
$params = ['year' => $year];

if ($month) {
    $where .= " AND MONTH(d.date) = :month";
    $params['month'] = $month;
}
if ($day) {
    $where .= " AND DAY(d.date) = :day";
    $params['day'] = $day;
}

$sql = <<<SQL
SELECT
  d.date,
  d.downtime_start,
  d.downtime_stop,
  d.total_downtime,
  et.name        AS equipment_type,
  eu.unit_number AS equipment_unit,
  es.name        AS component,
  dt.name        AS downtime_trigger,
  c.name         AS cause,
  f.name         AS feed,
  d.category,
  d.production_stopped,
  d.user,
  s.name         AS solution,
  d.remarks
FROM downtime_data d
JOIN equipment_type    et ON d.equipment_type_id    = et.id
JOIN equipment_unit    eu ON d.equipment_unit_id    = eu.id
JOIN equipment_subtype es ON d.equipment_subtype_id = es.id
JOIN downtime_type     dt ON d.downtime_type_id     = dt.id
JOIN cause             c  ON d.cause_id             = c.id
JOIN feeds             f  ON d.feed_id              = f.id
JOIN type_of_solution  s  ON d.solution_id          = s.id
$where
ORDER BY d.date ASC, d.downtime_start ASC
SQL;

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Group by date
$grouped = [];
foreach ($rows as $row) {
    $grouped[$row['date']][] = $row;
}

echo json_encode($grouped, JSON_PRETTY_PRINT);
