<?php
ini_set('display_errors', 0);
error_reporting(E_ALL & ~E_DEPRECATED & ~E_WARNING);

require 'db.php';
header('Content-Type: text/csv');
$timestamp = date("Y-m-d_H-i-s");
header("Content-Disposition: attachment; filename=\"downtime_export_{$timestamp}.csv\"");
if (ob_get_length()) ob_clean();
flush();
$year  = isset($_GET['year'])  ? (int)$_GET['year']  : null;
$month = isset($_GET['month']) ? (int)$_GET['month'] : null;
$day   = isset($_GET['day'])   ? (int)$_GET['day']   : null;
//$timestamp = date("Y-m-d_H-i-s");
$filename = "downtime_export_{$timestamp}.csv"; // or .json
if (!$year) {
    http_response_code(400);
    echo "Year is required.";
    exit;
}

$where = "WHERE YEAR(d.date) = :year";
$params = ['year' => $year];

if ($month) {
    $where .= " AND MONTH(d.date) = :month";
    $params['month'] = $month;
}
if ($day) {
    $where .= " AND DAY(d.date) = :day";
    $params['day'] = $day;
}

$sql = <<<SQL
SELECT
  d.date,
  d.downtime_start,
  d.downtime_stop,
  d.total_downtime,
  et.name        AS equipment_type,
  eu.unit_number AS equipment_unit,
  es.name        AS component,
  dt.name        AS downtime_trigger,
  c.name         AS cause,
  f.name         AS feed,
  d.category,
  d.production_stopped,
  d.user,
  s.name         AS solution,
  d.remarks
FROM downtime_data d
JOIN equipment_type    et ON d.equipment_type_id    = et.id
JOIN equipment_unit    eu ON d.equipment_unit_id    = eu.id
JOIN equipment_subtype es ON d.equipment_subtype_id = es.id
JOIN downtime_type     dt ON d.downtime_type_id     = dt.id
JOIN cause             c  ON d.cause_id             = c.id
JOIN feeds             f  ON d.feed_id              = f.id
JOIN type_of_solution  s  ON d.solution_id          = s.id
$where
ORDER BY d.date ASC, d.downtime_start ASC
SQL;

$stmt = $pdo->prepare($sql);
$stmt->execute($params);

$output = fopen('php://output', 'w');
fputcsv($output, ['Date', 'SN', 'Start', 'Stop', 'Total', 'Equipment', 'Unit', 'Component', 'Trigger', 'Cause', 'Feed', 'Solution', 'Planned?/Producing?', 'User', 'Remarks']);

$grouped = [];
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $row) {
    $grouped[$row['date']][] = $row;
}

foreach ($grouped as $date => $entries) {
    foreach ($entries as $i => $e) {
        $plannedText = ($e['category'] === 'planned') ? 'yes' : 'no';
        $prodText    = ($e['production_stopped'] === 'yes') ? 'stopped' : 'running';

        fputcsv($output, [
            $e['date'],
            $i + 1,
            $e['downtime_start'],
            $e['downtime_stop'],
            $e['total_downtime'],
            $e['equipment_type'],
            $e['equipment_unit'],
            $e['component'],
            $e['downtime_trigger'],
            $e['cause'],
            $e['feed'],
            $e['solution'],
            "$plannedText / $prodText",
            $e['user'],
            str_replace(["\r", "\n"], [' ', ' '], $e['remarks'])
        ], ',', '"', '\\');
    }

    // Add a divider row after each date group
//    fputcsv($output, array_fill(0, 15, ''));
}

fclose($output);
