<?php
// manage_lookups_full_page.php
session_start();
include "header.php";
include 'db.php';
/** @var PDO $pdo */

// ============================================
// 1) Lookup‐tables management configuration
// ============================================
$entities = [
    'equipment_type'    => ['label'=>'Equipment Types',      'cols'=>['name'],        'fks'=>[]],
    'feeds'             => ['label'=>'Feeds',                'cols'=>['name'],        'fks'=>[]],
    'type_of_solution'  => ['label'=>'Types of Solution',    'cols'=>['name'],        'fks'=>[]],
    'downtime_type'     => ['label'=>'Downtime Types',       'cols'=>['name'],        'fks'=>[]],
    'equipment_unit'    => ['label'=>'Equipment Units',      'cols'=>['unit_number'], 'fks'=>[
        ['field'=>'equipment_type_id','ref_table'=>'equipment_type','ref_label'=>'name','input_label'=>'Equipment Type']
    ]],
    'equipment_subtype' => ['label'=>'Equipment Subtypes',   'cols'=>['name'],        'fks'=>[
        ['field'=>'equipment_type_id','ref_table'=>'equipment_type','ref_label'=>'name','input_label'=>'Equipment Type']
    ]],
    'cause'             => ['label'=>'Causes',               'cols'=>['name'],        'fks'=>[
        ['field'=>'downtime_type_id','ref_table'=>'downtime_type','ref_label'=>'name','input_label'=>'Downtime Type']
    ]]
];

// ============================================
// 2) Determine active lookup table
// ============================================
$tables = array_keys($entities);
$table  = $_REQUEST['table'] ?? $tables[0];
if (!isset($entities[$table])) $table = $tables[0];
$config = $entities[$table];

// ============================================
// 3) Handle Add (via modal form POST)
// ============================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['form_table'] ?? '') === $table) {
    $fields = [];
    $params = [];
    $placeH = [];
    // collect FKs
    foreach ($config['fks'] as $fk) {
        $fields[] = $fk['field'];
        $params[] = (int) $_POST[$fk['field']];
        $placeH[] = '?';
    }
    // collect columns
    foreach ($config['cols'] as $col) {
        $fields[] = $col;
        $params[] = trim($_POST[$col]);
        $placeH[] = '?';
    }
    $colList = implode('`,`', $fields);
    $sql     = "INSERT INTO `$table` (`$colList`) VALUES (" . implode(',', $placeH) . ")";
    $stmt    = $pdo->prepare($sql);
    $stmt->execute($params);
    // redirect back
    header("Location: " . $_SERVER['PHP_SELF'] . "?table=$table");
    exit;
}

// ============================================
// 4) Load FK dropdown options
// ============================================
$fkOptions = [];
foreach ($config['fks'] as $fk) {
    $fkOptions[$fk['field']] = $pdo
        ->query(
            "SELECT id, `{$fk['ref_label']}` AS label
         FROM `{$fk['ref_table']}`
         ORDER BY `{$fk['ref_label']}`"
        )
        ->fetchAll(PDO::FETCH_ASSOC);
}

?>

<section class="section">
    <div class="container">
        <!-- Table selector -->
        <div class="columns">
            <div class="column"></div>
            <div class="column">
                <h2 class="subtitle">Add data to table: </h2>
            </div>

            <div class="column">
                <form method="get" class="field is-grouped">
                    <div class="control">
                        <div class="select">
                            <select name="table" onchange="this.form.submit()">
                                <?php foreach ($entities as $key => $ent): ?>
                                    <option value="<?= $key ?>" <?= $key === $table ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($ent['label']) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="column">

                <!-- ADD button to open modal -->
                <div class="field">
                    <div class="control">
                        <button class="button is-primary" id="openModal">ADD <?= htmlspecialchars($config['label']) ?></button>
                    </div>
                </div>
            </div>
            <div class="column"></div>
            <div class="column"></div>
        </div>



        <!-- Modal Form -->
        <div class="modal" id="lookupModal">
            <div class="modal-background"></div>
            <div class="modal-card">
                <header class="modal-card-head">
                    <p class="modal-card-title">Add <?= htmlspecialchars($config['label']) ?></p>
                    <button class="delete" aria-label="close" id="closeModal"></button>
                </header>
                <section class="modal-card-body">
                    <form id="lookupForm" method="post">
                        <input type="hidden" name="form_table" value="<?= $table ?>">
                        <?php foreach ($config['fks'] as $fk): ?>
                            <div class="field">
                                <label class="label"><?= htmlspecialchars($fk['input_label']) ?></label>
                                <div class="control">
                                    <div class="select">
                                        <select name="<?= $fk['field'] ?>" required>
                                            <option value="">– choose –</option>
                                            <?php foreach ($fkOptions[$fk['field']] as $opt): ?>
                                                <option value="<?= $opt['id'] ?>"><?= htmlspecialchars($opt['label']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>

                        <?php foreach ($config['cols'] as $col): ?>
                            <div class="field">
                                <label class="label"><?= ucfirst(str_replace('_', ' ', $col)) ?></label>
                                <div class="control">
                                    <input class="input" type="text" name="<?= $col ?>" required>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </form>
                </section>
                <footer class="modal-card-foot">
                    <button class="button is-success" type="submit" form="lookupForm">Save</button>
                    <button class="button" id="cancelModal">Cancel</button>
                </footer>
            </div>
        </div>
    </div>
</section>

<script>
    // Modal toggle logic
    const modal = document.getElementById('lookupModal');
    const openBtn = document.getElementById('openModal');
    const closeBtn = document.getElementById('closeModal');
    const cancelBtn = document.getElementById('cancelModal');
    [openBtn, closeBtn, cancelBtn].forEach(el => {
        el.addEventListener('click', e => {
            e.preventDefault();
            modal.classList.toggle('is-active');
        });
    });
</script>

<?php
// ============================================
// 5) Pre-existing page content
// ============================================
// Fetch data
$equipmentUnits = $pdo->query(
    "SELECT eu.unit_number, et.name as equipment_type
     FROM equipment_unit eu
     JOIN equipment_type et ON eu.equipment_type_id = et.id
     ORDER BY eu.equipment_type_id"
)->fetchAll();
$equipmentSubtypes = $pdo->query(
    "SELECT es.name as subtype, et.name as equipment_type
     FROM equipment_subtype es
     JOIN equipment_type et ON es.equipment_type_id = et.id
     ORDER BY es.equipment_type_id"
)->fetchAll();
$downtime = $pdo->query(
    "SELECT c.name as cause, dt.name as downtime_type
     FROM cause c
     JOIN downtime_type dt ON c.downtime_type_id = dt.id
     ORDER BY c.downtime_type_id"
)->fetchAll();
$feeds = $pdo->query("SELECT name FROM feeds ORDER BY id")->fetchAll();
$solutions = $pdo->query("SELECT name FROM type_of_solution ORDER BY id")->fetchAll();

// Group data
$subtypesByType = [];
foreach ($equipmentSubtypes as $row) {
    $subtypesByType[$row['equipment_type']][] = $row['subtype'];
}
$unitsByType = [];
foreach ($equipmentUnits as $row) {
    $unitsByType[$row['equipment_type']][] = $row['unit_number'];
}
// Include all causes
$downtimeByType = [];
foreach ($downtime as $row) {
    $downtimeByType[$row['downtime_type']][] = $row['cause'];
}
?>

<!-- Downtime Types & Causes -->
<h2 class="title is-4">Downtime Types & Causes</h2>
<table class="interactive table is-fullwidth is-striped is-hoverable">
    <thead>
    <tr>
        <th>Type Of Downtime</th>
        <th>Causes</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($downtimeByType as $type => $causes): ?>
        <tr>
            <td><?= htmlspecialchars($type) ?></td>
            <td><?= htmlspecialchars(implode(', ', $causes)) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<!-- Feeds & Solutions Grid -->
<h2 class="title is-4">Feeds &amp; Type of Solution</h2>
<div class="columns">
    <div class="column is-3">
        <h3 class="subtitle is-6 has-text-weight-semibold">Feeds</h3>
        <table class="interactive table is-narrow is-fullwidth">
            <tbody>
            <?php foreach ($feeds as $f): ?>
                <tr>
                    <td><?= htmlspecialchars($f['name']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="column is-3">
        <h3 class="subtitle is-6 has-text-weight-semibold">Type of Solution</h3>
        <table class="interactive table is-narrow is-fullwidth">
            <tbody>
            <?php foreach ($solutions as $s): ?>
                <tr>
                    <td><?= htmlspecialchars($s['name']) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Equipment Units by Type (Full Table) -->
<h2 class="title is-4">Equipment Type by Unit Numbers</h2>
<table class="interactive table is-fullwidth is-striped is-hoverable">
    <thead>
    <tr>
        <th>Equipment Type</th>
        <th>Unit Numbers</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($unitsByType as $type => $units): ?>
        <tr>
            <td><?= htmlspecialchars($type) ?></td>
            <td><?= htmlspecialchars(implode(', ', $units)) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<!-- Equipment Subtypes Grid -->
<h2 class="title is-4">Equipment Subtypes</h2>
<div class="columns is-multiline">
    <?php foreach ($subtypesByType as $type => $subtypes): ?>
        <div class="column is-2">
            <h3 class="subtitle is-6 has-text-weight-semibold"><?= htmlspecialchars($type) ?></h3>
            <table class="interactive table is-narrow is-fullwidth">
                <tbody>
                <?php foreach ($subtypes as $s): ?>
                    <tr>
                        <td><?= htmlspecialchars($s) ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endforeach; ?>
</div>

<?php include "footer.php"; ?>
