<?php
// File: downtime_submit.php
require 'db.php';
include 'header.php';  // handles session/user checks and nav
if (session_status() === PHP_SESSION_NONE) session_start();

do {
    // Helper: fetch ID for 'N/A' in a lookup table
    function getNAId(PDO $pdo, string $table, string $col) {
        $stmt = $pdo->prepare("SELECT id FROM `$table` WHERE `$col` = 'N/A' LIMIT 1");
        $stmt->execute();
        return (int) $stmt->fetchColumn();
    }

    // 1) Gather & sanitize inputs
    $category          = ($_POST['category'] ?? 'unplanned') === 'planned' ? 'planned' : 'unplanned';
    $productionStopped = (isset($_POST['production_stopped']) && $_POST['production_stopped'] === 'yes') ? 'yes' : 'no';
    $date              = $_POST['date'] ?? date('Y-m-d');
    $startRaw          = preg_replace('/\D/', '', $_POST['downtime_start'] ?? '0000');
    $stopRaw           = preg_replace('/\D/', '', $_POST['downtime_stop']  ?? '0000');
    $startRaw          = str_pad($startRaw, 4, '0', STR_PAD_LEFT);
    $stopRaw           = str_pad($stopRaw,  4, '0', STR_PAD_LEFT);
    $user = $_SESSION['username'];

    // 2) Compute total downtime
    $sh = (int) substr($startRaw, 0, 2);
    $sm = (int) substr($startRaw, 2, 2);
    $eh = (int) substr($stopRaw,  0, 2);
    $em = (int) substr($stopRaw,  2, 2);
    $diff = ($eh * 60 + $em) - ($sh * 60 + $sm);
    if ($diff < 0) $diff += 24 * 60;
    $totalDowntime = sprintf('%02d:%02d', floor($diff / 60), $diff % 60);

    // 3) Determine lookup IDs (use N/A defaults where appropriate)
    if ($category === 'planned') {
        $equipmentTypeId    = !empty($_POST['equipment_type_id'])    ? (int)$_POST['equipment_type_id']    : getNAId($pdo, 'equipment_type', 'name');
        $equipmentUnitId    = !empty($_POST['equipment_unit_id'])    ? (int)$_POST['equipment_unit_id']    : getNAId($pdo, 'equipment_unit', 'unit_number');
        $equipmentSubtypeId = getNAId($pdo, 'equipment_subtype', 'name');
        $downtimeTypeId     = 1; // ← Force 'downtime_type_id' to 1 for planned downtime
        $causeId            = getNAId($pdo, 'cause', 'name');
        $feedId             = getNAId($pdo, 'feeds', 'name');
        $solutionId         = getNAId($pdo, 'type_of_solution', 'name');
    } else {
        $equipmentTypeId    = !empty($_POST['equipment_type_id'])    ? (int)$_POST['equipment_type_id']    : getNAId($pdo, 'equipment_type', 'name');
        $equipmentUnitId    = !empty($_POST['equipment_unit_id'])    ? (int)$_POST['equipment_unit_id']    : getNAId($pdo, 'equipment_unit', 'unit_number');
        $equipmentSubtypeId = !empty($_POST['equipment_subtype_id']) ? (int)$_POST['equipment_subtype_id'] : getNAId($pdo, 'equipment_subtype', 'name');
        $downtimeTypeId     = !empty($_POST['downtime_type_id'])     ? (int)$_POST['downtime_type_id']     : getNAId($pdo, 'downtime_type', 'name');
        $causeId            = !empty($_POST['cause_id'])             ? (int)$_POST['cause_id']             : getNAId($pdo, 'cause', 'name');
        $feedId             = !empty($_POST['feed_id'])              ? (int)$_POST['feed_id']              : getNAId($pdo, 'feeds', 'name');
        $solutionId         = !empty($_POST['solution_id'])          ? (int)$_POST['solution_id']          : getNAId($pdo, 'type_of_solution', 'name');
    }

    // 4) Remarks default
    $remarks = trim($_POST['remarks'] ?? '');
    if ($remarks === '') {
        $remarks = 'N/A';
    }

    // 5) Insert or Update record
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    if ($id > 0) {
        // Update path: admin only
        if (empty($_SESSION['user']) || $_SESSION['user'] !== 'admin') {
            http_response_code(403);
            echo '<section class="section"><div class="container"><div class="notification is-danger">Unauthorized: admin only.</div></div></section>';
            include 'footer.php';
            exit;
        }
        $sql = "UPDATE downtime_data SET `date` = ?, downtime_start = ?, downtime_stop = ?, total_downtime = ?,
                equipment_type_id = ?, equipment_unit_id = ?, equipment_subtype_id = ?,
                downtime_type_id = ?, cause_id = ?, feed_id = ?, solution_id = ?,
                remarks = ?, category = ?, production_stopped = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $date,
            substr($startRaw, 0, 2) . ':' . substr($startRaw, 2, 2),
            substr($stopRaw,  0, 2) . ':' . substr($stopRaw,  2, 2),
            $totalDowntime,
            $equipmentTypeId,
            $equipmentUnitId,
            $equipmentSubtypeId,
            $downtimeTypeId,
            $causeId,
            $feedId,
            $solutionId,
            $remarks,
            $category,
            $productionStopped,
            $id
        ]);
    } else {
        $sql = "INSERT INTO downtime_data
            (`date`, downtime_start, downtime_stop, total_downtime,
             equipment_type_id, equipment_unit_id, equipment_subtype_id,
             downtime_type_id, cause_id, feed_id, solution_id,
             remarks, category, production_stopped, user)
         VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $date,
            substr($startRaw, 0, 2) . ':' . substr($startRaw, 2, 2),
            substr($stopRaw,  0, 2) . ':' . substr($stopRaw,  2, 2),
            $totalDowntime,
            $equipmentTypeId,
            $equipmentUnitId,
            $equipmentSubtypeId,
            $downtimeTypeId,
            $causeId,
            $feedId,
            $solutionId,
            $remarks,
            $category,
            $productionStopped,
            $user
        ]);
    }

    // 6) Redirect based on role
    if (!empty($_SESSION['user']) && $_SESSION['user'] === 'admin') {
        header('Location: 206_downtime_table.php');
    } else {
        header('Location: 206_downtime_form.php');
    }
    exit;

} while (false);

// In case of fall-through
header('Location: 206_downtime_form.php');
exit;
?>
