<?php
global $pdo;
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// CORS / JSON
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json; charset=UTF-8');

$root = realpath(__DIR__ . '/..');
require_once $root . '/db.php';

// ── grab & default the API key ────────────────────────────────────────────────
// 1) try URL: /api/downtime.php?api_key=YOUR_KEY
$apiKey = isset($_GET['api_key']) ? trim($_GET['api_key']) : '';

// 2) if none in URL, try header (usual)
if (!$apiKey) {
    if (function_exists('getallheaders')) {
        $h = getallheaders();
        $apiKey = $h['X-API-KEY'] ?? '';
    }
    if (!$apiKey && !empty($_SERVER['HTTP_X_API_KEY'])) {
        $apiKey = $_SERVER['HTTP_X_API_KEY'];
    }
}

// 3) if still no key, use your built-in default for testing
if (!$apiKey) {
    $apiKey = '9559386bfcf870dfd496307136f06dc6dc7d406d';
}

// ── now validate that $apiKey … rest of your existing logic … ─────────────────
$keyStmt = $pdo->prepare("
    SELECT revoked, expires_at
      FROM api_keys
     WHERE `key` = :key
     LIMIT 1
");
$keyStmt->execute([':key' => $apiKey]);
$keyRow = $keyStmt->fetch(PDO::FETCH_ASSOC);

if (
    !$keyRow ||
    (int)$keyRow['revoked'] === 1 ||
    new DateTime($keyRow['expires_at']) < new DateTime()
) {
    http_response_code(403);
    exit(json_encode([
        'error'   => 'Forbidden',
        'message' => 'Invalid, revoked, or expired API key'
    ]));
}
// ── fetch & return downtime rows ───────────────────────────────────────────────
try {
    $sql = "
      SELECT
          d.id,
        d.date,
        d.downtime_start AS raw_start,
        d.downtime_stop  AS raw_stop,
        d.total_downtime,

        et.name AS equipment_type,
        eu.unit_number AS equipment_unit,
        es.name AS equipment_subtype,
        dt.name AS downtime_type,
        c.name  AS cause,
        f.name  AS feed,
        s.name  AS solution,

        d.category,
        d.production_stopped,
        d.user,
        d.remarks,
        d.created_at,
        d.updated_at

      FROM downtime_data d
      LEFT JOIN equipment_type    et ON d.equipment_type_id    = et.id
      LEFT JOIN equipment_unit    eu ON d.equipment_unit_id    = eu.id
      LEFT JOIN equipment_subtype es ON d.equipment_subtype_id = es.id
      LEFT JOIN downtime_type     dt ON d.downtime_type_id     = dt.id
      LEFT JOIN cause             c  ON d.cause_id             = c.id
      LEFT JOIN feeds             f  ON d.feed_id              = f.id
      LEFT JOIN type_of_solution  s  ON d.solution_id          = s.id

      ORDER BY d.date DESC, d.downtime_start DESC
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as &$r) {
        $r['downtime_start'] = date('Y-m-d H:i:s', strtotime("{$r['date']} {$r['raw_start']}"));
        $r['downtime_stop']  = date('Y-m-d H:i:s', strtotime("{$r['date']} {$r['raw_stop']}"));
        $r['created_at']     = date('Y-m-d H:i:s', strtotime($r['created_at']));
        $r['updated_at']     = date('Y-m-d H:i:s', strtotime($r['updated_at']));
        unset($r['raw_start'], $r['raw_stop']);
    }
    unset($r);

    echo json_encode($rows);

} catch (\PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error'   => 'DB error',
        'message' => $e->getMessage()
    ]);
}
