<?php
// scripts/seed_downtime.php

// start session to grab username
session_start();

// 1) Boot your app’s DB connection
global $pdo;
$root = realpath(__DIR__ . '/..');
require_once $root . '/db.php';   // should give you a $pdo = new PDO(...)

// 2) Helper: pick a random element
function pick(array $arr) {
    return $arr[random_int(0, count($arr) - 1)];
}

// 3) Load all lookup IDs

// Equipment types
$stmt = $pdo->query("SELECT id FROM equipment_type");
$equipment_types = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Equipment units grouped by type
$stmt = $pdo->query("SELECT id, equipment_type_id FROM equipment_unit");
$units_by_type = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $units_by_type[$row['equipment_type_id']][] = $row['id'];
}

// Equipment subtypes grouped by type
$stmt = $pdo->query("SELECT id, equipment_type_id FROM equipment_subtype");
$subtypes_by_type = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $subtypes_by_type[$row['equipment_type_id']][] = $row['id'];
}

// Downtime types
$stmt = $pdo->query("SELECT id FROM downtime_type");
$downtime_types = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Causes
$stmt = $pdo->query("SELECT id FROM cause");
$causes = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Feeds
$stmt = $pdo->query("SELECT id FROM feeds");
$feeds = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Solutions
$stmt = $pdo->query("SELECT id FROM type_of_solution");
$solutions = $stmt->fetchAll(PDO::FETCH_COLUMN);

// 4) Prepare our INSERT
$insert = $pdo->prepare("INSERT INTO downtime_data
    (date, downtime_start, downtime_stop, total_downtime,
     equipment_type_id, equipment_unit_id, equipment_subtype_id,
     downtime_type_id, cause_id, feed_id, solution_id,
     remarks, created_at, updated_at, user, category, production_stopped)
  VALUES
    (:date, :start, :stop, :total,
     :etype, :eunit, :esub,
     :dtype, :cause, :feed, :sol,
     :remarks, NOW(), NOW(), :user, :category, :production_stopped)");

// 5) Seed 50 random rows
global $_SESSION;
$username = $_SESSION['username'] ?? 'system';
for ($i = 0; $i < 500; $i++) {
    // — pick a random date within the past 30 days
    $ts = time() - random_int(0, 30 * 86400);
    $date = date('Y-m-d', $ts);

    // — pick a random start time between 06:00 and 20:00
    $h = random_int(6, 20);
    $m = random_int(0, 59);
    $start = sprintf('%02d:%02d:00', $h, $m);

    // — random duration between 5 min and 5 hours
    $durMinutes = random_int(5, 300);
    $endTs = strtotime("{$date} {$start}") + ($durMinutes * 60);
    $stop  = date('H:i:00', $endTs);

    // — compute total_downtime as HH:MM
    $hours   = floor($durMinutes / 60);
    $minutes = $durMinutes % 60;
    $total   = sprintf('%02d:%02d', $hours, $minutes);

    // — pick equipment_type, then a matching unit & subtype
    $etype = pick($equipment_types);
    $eunit = pick($units_by_type[$etype]    ?? [$etype]);
    $esub  = pick($subtypes_by_type[$etype] ?? [$etype]);

    // — other lookups
    $dtype = pick($downtime_types);
    $cause = pick($causes);
    $feed  = pick($feeds);
    $sol   = pick($solutions);

    // — random remarks (empty or lorem)
    $remarks = (random_int(0, 4) === 0)
        ? 'Lorem ipsum dolor sit amet'
        : '';

    // — random category and production_stopped
    $category           = pick(['planned', 'unplanned']);
    $productionStopped  = pick(['yes', 'no']);

    // — execute insert
    $insert->execute([
        ':date'                => $date,
        ':start'               => $start,
        ':stop'                => $stop,
        ':total'               => $total,
        ':etype'               => $etype,
        ':eunit'               => $eunit,
        ':esub'                => $esub,
        ':dtype'               => $dtype,
        ':cause'               => $cause,
        ':feed'                => $feed,
        ':sol'                 => $sol,
        ':remarks'             => $remarks,
        ':user'                => $username,
        ':category'            => $category,
        ':production_stopped'  => $productionStopped,
    ]);

    echo "Inserted downtime #{$pdo->lastInsertId()} on {$date} {$start} – {$stop}\n";
}

echo "Done! 50 rows added.\n";
