<?php
require_once '../db.php';

header('Content-Type: application/json');

try {
    $stmt = $pdo->query("SELECT DISTINCT DATE(date) AS d FROM downtime_data ORDER BY d ASC");
    $rows = $stmt->fetchAll(PDO::FETCH_COLUMN);

    $data = [];

    foreach ($rows as $date) {
        [$y, $m, $d] = explode('-', $date);
        if (!isset($data[$y])) $data[$y] = [];
        if (!isset($data[$y][$m])) $data[$y][$m] = [];
        $data[$y][$m][] = $d;
    }

    echo json_encode($data);
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
}
