<?php
// File: 206_downtime_form.php
require 'db.php';
require 'header.php';

// Edit mode detection
global $pdo;
$editId = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$isEdit = $editId > 0;
$editRecord = null;
$prefill = null;
if ($isEdit) {
    if (empty($_SESSION['user']) || $_SESSION['user'] !== 'admin') {
        http_response_code(403);
        echo '<section class="section"><div class="container"><div class="notification is-danger">Unauthorized: admin only.</div></div></section>';
        require 'footer.php';
        exit;
    }
    $stmt = $pdo->prepare('SELECT * FROM downtime_data WHERE id = ?');
    $stmt->execute([$editId]);
    $editRecord = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$editRecord) {
        echo '<section class="section"><div class="container"><div class="notification is-warning">Record not found.</div></div></section>';
        require 'footer.php';
        exit;
    }
    $startHHMM = str_replace(':','', $editRecord['downtime_start'] ?? '');
    $stopHHMM  = str_replace(':','', $editRecord['downtime_stop'] ?? '');
    $prefill = [
        'id' => $editId,
        'date' => $editRecord['date'] ?? '',
        'start' => $startHHMM,
        'stop' => $stopHHMM,
        'category' => $editRecord['category'] ?? 'unplanned',
        'production_stopped' => $editRecord['production_stopped'] ?? 'no',
        'equipment_type_id' => (int)($editRecord['equipment_type_id'] ?? 0),
        'equipment_unit_id' => (int)($editRecord['equipment_unit_id'] ?? 0),
        'equipment_subtype_id' => (int)($editRecord['equipment_subtype_id'] ?? 0),
        'downtime_type_id' => (int)($editRecord['downtime_type_id'] ?? 0),
        'cause_id' => (int)($editRecord['cause_id'] ?? 0),
        'feed_id' => (int)($editRecord['feed_id'] ?? 0),
        'solution_id' => (int)($editRecord['solution_id'] ?? 0),
        'remarks' => $editRecord['remarks'] ?? ''
    ];
}

// Include Bulma Switch Control CSS
echo '<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bulma-switch@2.0.0/dist/css/bulma-switch.min.css">';

// Fetch lookup tables
global $pdo;
$feeds          = $pdo->query("SELECT id, name FROM feeds ORDER BY id")->fetchAll();
$downtimeTypes  = $pdo->query("SELECT id, name FROM downtime_type ORDER BY id")->fetchAll();
$equipmentTypes = $pdo->query("SELECT id, name FROM equipment_type ORDER BY id")->fetchAll();
$units          = $pdo->query("SELECT id, equipment_type_id, unit_number FROM equipment_unit ORDER BY equipment_type_id, unit_number")->fetchAll();
$subtypes       = $pdo->query("SELECT id, equipment_type_id, name FROM equipment_subtype ORDER BY equipment_type_id, name")->fetchAll();
$causes         = $pdo->query("SELECT id, downtime_type_id, name FROM cause ORDER BY downtime_type_id, name")->fetchAll();
$solutions      = $pdo->query("SELECT id, name FROM type_of_solution ORDER BY id")->fetchAll();

// Build JS mappings
$unitsByType    = [];
foreach ($units as $u) {
    $unitsByType[$u['equipment_type_id']][] = ['id' => $u['id'], 'name' => $u['unit_number']];
}
$subtypesByType = [];
foreach ($subtypes as $s) {
    $subtypesByType[$s['equipment_type_id']][] = ['id' => $s['id'], 'name' => $s['name']];
}
$causesByType   = [];
foreach ($causes as $c) {
    $causesByType[$c['downtime_type_id']][] = ['id' => $c['id'], 'name' => $c['name']];
}
?>

<h1 class="title">Downtime Entry <span id="totalDowntime" class="has-text-weight-semibold">00:00</span></h1>
<form action="downtime_submit.php" method="post">
    <?php if ($isEdit): ?>
        <input type="hidden" name="id" value="<?= htmlspecialchars((string)$editId) ?>">
    <?php endif; ?>
    <!-- Category toggle -->
    <input type="hidden" name="category" value="unplanned">
    <div class="field is-align-items-center">
        <label class="label mr-3">Entry Type</label>
        <input type="checkbox" id="plannedToggle" name="category" value="planned" class="switch is-rounded is-medium is-danger">
        <label for="plannedToggle" id="toggleLabel" class="ml-3">Unplanned</label>
    </div>

    <!-- Always visible: date, start, stop -->
    <div class="columns">
        <div class="column">
            <div class="field">
                <label class="label" for="enterDate">Date</label>
                <div class="control">
                    <input class="input" id="enterDate" type="date" name="date" required>
                </div>
            </div>
        </div>
        <div class="column">
            <div class="field">
                <label class="label" for="downtimeStart">Start (HHMM)</label>
                <div class="control">
                    <input class="input" id="downtimeStart" type="text" name="downtime_start" required
                           pattern="^([01]\d|2[0-3])[0-5]\d$" maxlength="4" inputmode="numeric"
                           placeholder="HHMM" title="0000–2359">
                </div>
            </div>
        </div>
        <div class="column">
            <div class="field">
                <label class="label" for="downtimeStop">Stop (HHMM)</label>
                <div class="control">
                    <input class="input" id="downtimeStop" type="text" name="downtime_stop" required
                           pattern="^([01]\d|2[0-3])[0-5]\d$" maxlength="4" inputmode="numeric"
                           placeholder="HHMM" title="0000–2359">
                </div>
            </div>
        </div>
    </div>

    <!-- Production Stopped -->
    <div class="field">
        <div class="control">
            <label class="checkbox">
                <input type="hidden" name="production_stopped" value="no">
                <input type="checkbox" name="production_stopped" value="yes"> Production Stopped?
            </label>
        </div>
    </div>

    <!-- Unplanned fields -->
    <div id="unplannedFields">
        <div class="columns">
            <div class="column">
                <label class="label" for="equipmentType">Equipment Type</label>
                <div class="select is-fullwidth">
                    <select id="equipmentType" name="equipment_type_id">
                        <option value="">Select equipment</option>
                        <?php foreach ($equipmentTypes as $et): ?>
                            <option value="<?= $et['id'] ?>"><?= htmlspecialchars($et['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="column">
                <label class="label" for="unitSelect">Unit</label>
                <div class="select is-fullwidth">
                    <select id="unitSelect" name="equipment_unit_id">
                        <option value="">Select unit</option>
                    </select>
                </div>
            </div>
            <div class="column">
                <label class="label" for="subtypeSelect">Component</label>
                <div class="select is-fullwidth">
                    <select id="subtypeSelect" name="equipment_subtype_id">
                        <option value="">Select component</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="columns">
            <div class="column">
                <label class="label" for="downtimeTrigger">Downtime Type</label>
                <div class="select is-fullwidth">
                    <select id="downtimeTrigger" name="downtime_type_id">
                        <option value="">Select type</option>
                        <?php foreach ($downtimeTypes as $dt): ?>
                            <option value="<?= $dt['id'] ?>"><?= htmlspecialchars($dt['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="column">
                <label class="label" for="causeSelect">Cause</label>
                <div class="select is-fullwidth">
                    <select id="causeSelect" name="cause_id">
                        <option value="">Select cause</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="columns">
            <div class="column">
                <label class="label" for="feedSelect">Feeds Stopped</label>
                <div class="select is-fullwidth">
                    <select id="feedSelect" name="feed_id">
                        <option value="">Select feed</option>
                        <?php foreach ($feeds as $f): ?>
                            <option value="<?= $f['id'] ?>"><?= htmlspecialchars($f['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            <div class="column">
                <label class="label" for="solutionSelect">Solution</label>
                <div class="select is-fullwidth">
                    <select id="solutionSelect" name="solution_id">
                        <option value="">Select solution</option>
                        <?php foreach ($solutions as $sol): ?>
                            <option value="<?= $sol['id'] ?>"><?= htmlspecialchars($sol['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Planned fields -->
    <div id="plannedFields" style="display:none;">
        <div class="field">
            <label class="label" for="equipmentTypePlanned">Equipment Type</label>
            <div class="select is-fullwidth">
                <select id="equipmentTypePlanned" name="equipment_type_id">
                    <option value="">Select equipment</option>
                    <?php foreach ($equipmentTypes as $et): ?>
                        <option value="<?= $et['id'] ?>"><?= htmlspecialchars($et['name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <div class="field">
            <label class="label" for="unitSelectPlanned">Unit</label>
            <div class="select is-fullwidth">
                <select id="unitSelectPlanned" name="equipment_unit_id">
                    <option value="">Select unit</option>
                </select>
            </div>
        </div>
    </div>

    <!-- Remarks -->
    <div class="field">
        <label class="label" for="enterRemarks">Remarks</label>
        <div class="control">
            <textarea id="enterRemarks" class="textarea" name="remarks" placeholder="Enter notes..."></textarea>
        </div>
    </div>

    <!-- Submit -->
    <div class="field">
        <div class="control">
            <button type="submit" class="button is-large is-fullwidth is-fowler"><?= $isEdit ? 'Update' : 'Submit' ?></button>
        </div>
    </div>
</form>

<script>
    const isEdit = <?= $isEdit ? 'true' : 'false' ?>;
    const editData = <?= $isEdit ? json_encode($prefill) : 'null' ?>;
</script>

<script>
    // JavaScript for 206_downtime_form.php
    const toggle       = document.getElementById('plannedToggle');
    const unplanned    = document.getElementById('unplannedFields');
    const planned      = document.getElementById('plannedFields');
    const totalEl      = document.getElementById('totalDowntime');
    const unitsByType    = <?= json_encode($unitsByType) ?>;
    const subtypesByType = <?= json_encode($subtypesByType) ?>;
    const causesByType   = <?= json_encode($causesByType) ?>;

    function updateForm() {
        const isPl = toggle.checked;
        document.getElementById('toggleLabel').textContent = isPl ? 'Planned' : 'Unplanned';
        unplanned.style.display = isPl ? 'none' : '';
        planned.style.display   = isPl ? '' : 'none';
        toggle.classList.replace(
            isPl ? 'is-danger' : 'is-success',
            isPl ? 'is-success' : 'is-danger'
        );
        // disable selects in inactive section
        unplanned.querySelectorAll('select').forEach(el => el.disabled = isPl);
        planned.querySelectorAll('select').forEach(el => el.disabled   = !isPl);
    }
    toggle.addEventListener('change', updateForm);
    updateForm();

    // Unplanned dynamic selects
    const equipSelect   = document.getElementById('equipmentType');
    const unitSelect    = document.getElementById('unitSelect');
    const subtypeSelect = document.getElementById('subtypeSelect');
    equipSelect.addEventListener('change', e => {
        const id = e.target.value;
        unitSelect.innerHTML    = '<option value="">Select unit</option>';
        subtypeSelect.innerHTML = '<option value="">Select component</option>';
        (unitsByType[id] || []).forEach(u => unitSelect.add(new Option(u.name, u.id)));
        (subtypesByType[id] || []).forEach(s => subtypeSelect.add(new Option(s.name, s.id)));
    });

    // Planned dynamic units
    const equipPlanned = document.getElementById('equipmentTypePlanned');
    const unitPlanned  = document.getElementById('unitSelectPlanned');
    equipPlanned.addEventListener('change', e => {
        const id = e.target.value;
        unitPlanned.innerHTML = '<option value="">Select unit</option>';
        (unitsByType[id] || []).forEach(u => unitPlanned.add(new Option(u.name, u.id)));
    });

    // Cause dynamic select
    document.getElementById('downtimeTrigger').addEventListener('change', e => {
        const id = e.target.value;
        const causeSel = document.getElementById('causeSelect');
        causeSel.innerHTML = '<option value="">Select cause</option>';
        (causesByType[id] || []).forEach(c => causeSel.add(new Option(c.name, c.id)));
    });

    // HHMM calculation
    document.getElementById('downtimeStart').addEventListener('input', updateTotal);
    document.getElementById('downtimeStop').addEventListener('input', updateTotal);
    function updateTotal() {
        let s = document.getElementById('downtimeStart').value.trim().padStart(4, '0');
        let t = document.getElementById('downtimeStop').value.trim().padStart(4, '0');
        const re = /^([01]\d|2[0-3])[0-5]\d$/;
        if (!re.test(s) || !re.test(t)) {
            totalEl.textContent = '00:00';
            return;
        }
        const sh = parseInt(s.slice(0,2)), sm = parseInt(s.slice(2));
        const eh = parseInt(t.slice(0,2)), em = parseInt(t.slice(2));
        let diff = (eh*60+em) - (sh*60+sm);
        if (diff < 0) diff += 1440;
        totalEl.textContent = `${Math.floor(diff/60)}:${(diff%60).toString().padStart(2,'0')}`;
    }
    // Prefill when editing
    if (isEdit && editData) {
        // Toggle planned/unplanned first
        toggle.checked = (editData.category === 'planned');
        updateForm();

        // Date and time
        document.getElementById('enterDate').value = editData.date || '';
        document.getElementById('downtimeStart').value = editData.start || '';
        document.getElementById('downtimeStop').value = editData.stop || '';

        // Production stopped
        const prodCheckboxes = document.querySelectorAll('input[name="production_stopped"][value="yes"]');
        if (prodCheckboxes.length) prodCheckboxes[0].checked = (editData.production_stopped === 'yes');

        // Remarks
        document.getElementById('enterRemarks').value = editData.remarks || '';

        // Unplanned dynamic selects
        if (editData.equipment_type_id) {
            equipSelect.value = String(editData.equipment_type_id);
            equipSelect.dispatchEvent(new Event('change'));
            setTimeout(() => {
                if (editData.equipment_unit_id) unitSelect.value = String(editData.equipment_unit_id);
                if (editData.equipment_subtype_id) subtypeSelect.value = String(editData.equipment_subtype_id);
            }, 0);
        }

        // Planned dynamic selects
        if (editData.equipment_type_id) {
            equipPlanned.value = String(editData.equipment_type_id);
            equipPlanned.dispatchEvent(new Event('change'));
            setTimeout(() => {
                if (editData.equipment_unit_id) unitPlanned.value = String(editData.equipment_unit_id);
            }, 0);
        }

        // Downtime type and cause
        const dtSel = document.getElementById('downtimeTrigger');
        if (editData.downtime_type_id) {
            dtSel.value = String(editData.downtime_type_id);
            dtSel.dispatchEvent(new Event('change'));
            setTimeout(() => {
                if (editData.cause_id) document.getElementById('causeSelect').value = String(editData.cause_id);
            }, 0);
        }

        // Feed and solution
        if (editData.feed_id) document.getElementById('feedSelect').value = String(editData.feed_id);
        if (editData.solution_id) document.getElementById('solutionSelect').value = String(editData.solution_id);
    }

    updateTotal();
</script>

<?php require 'footer.php'; ?>
