import { ref } from 'vue'

const toast = ref({
  show: false,
  title: '',
  message: '',
  type: 'success'
})

let timeoutId = null

export function useToast() {
  const showToast = (title, message, type = 'success') => {
    if (timeoutId) {
      clearTimeout(timeoutId)
    }
    
    toast.value = {
      show: true,
      title,
      message,
      type
    }
    
    timeoutId = setTimeout(() => {
      toast.value.show = false
    }, 3000)
  }
  
  const hideToast = () => {
    toast.value.show = false
  }
  
  return {
    toast,
    showToast,
    hideToast
  }
}
