<?php
header('Location:?page=home');
?>
<div class="bg-white rounded-lg shadow-md p-6">
    <div class="bg-red-100 border-l-4 border-red-400 text-red-700 px-4 py-3 relative" role="alert">
        <p class="font-bold">DANGER ZONE</p>
        <p>Changing these settings will change the workflow. Do not change anything</p>
    </div>
    <br />
    <h1 class="text-2xl font-bold text-gray-800 mb-6">
        <i class="fas fa-cog mr-2 text-primary"></i>
        System Settings
    </h1>

<div class="bg-white rounded-lg shadow-md p-6">
    <div class="bg-red-100 border-l-4 border-red-400 text-red-700 px-4 py-3 relative" role="alert">
        <p class="font-bold">DANGER ZONE</p>
        <p>Changing these settings will change the workflow. Do not change anything</p>
    </div>
    <br />
    <h1 class="text-2xl font-bold text-gray-800 mb-6">
        <i class="fas fa-cog mr-2 text-primary"></i>
        System Settings
    </h1>

    <!-- Branding (Logo & Favicon) -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="text-xl font-semibold text-gray-800 mb-4">
            <i class="fas fa-image mr-2 text-primary"></i> Branding
        </h2>
        <p class="text-gray-600 mb-4">Provide a URL or upload a file for your Logo and Favicon. If both are provided, the upload takes precedence. Max file size 2&nbsp;MB.</p>
        <form method="POST" action="<?= BASE_URL ?>?page=settings&action=update" enctype="multipart/form-data" class="space-y-6">
            <input type="hidden" name="form" value="branding">
            <!-- Logo -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-start">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Logo URL</label>
                    <input type="text" name="branding_logo_url" value="<?= htmlspecialchars($dbSettings['branding_logo']['value'] ?? '') ?>" placeholder="https://... or /assets/..." class="w-full border rounded px-3 py-2" />
                    <p class="text-xs text-gray-500 mt-1">Upload types: PNG, JPG, SVG (max 2 MB)</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Upload Logo</label>
                    <input type="file" name="branding_logo_file" accept=".png,.jpg,.jpeg,.svg" class="w-full border rounded px-3 py-2 bg-white">
                </div>
                <div class="flex flex-col items-center">
                    <?php
                        $logoVal = $dbSettings['branding_logo']['value'] ?? '';
                        $logoUrl = $logoVal;
                        if ($logoUrl && !preg_match('~^(https?://|/|data:)~i', $logoUrl)) { $logoUrl = BASE_URL . ltrim($logoUrl, '/'); }
                    ?>
                    <span class="text-sm text-gray-700 mb-2">Preview</span>
                    <?php if ($logoVal): ?>
                        <img alt="Logo preview" src="<?= htmlspecialchars($logoUrl) ?>" class="max-h-16 object-contain">
                    <?php else: ?>
                        <div class="text-gray-400 text-sm">No logo set</div>
                    <?php endif; ?>
                </div>
            </div>
            <!-- Favicon -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-start">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Favicon URL</label>
                    <input type="text" name="branding_favicon_url" value="<?= htmlspecialchars($dbSettings['branding_favicon']['value'] ?? '') ?>" placeholder="https://... or /assets/..." class="w-full border rounded px-3 py-2" />
                    <p class="text-xs text-gray-500 mt-1">Upload types: ICO, PNG (max 2 MB)</p>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Upload Favicon</label>
                    <input type="file" name="branding_favicon_file" accept=".ico,.png" class="w-full border rounded px-3 py-2 bg-white">
                </div>
                <div class="flex flex-col items-center">
                    <?php
                        $favVal = $dbSettings['branding_favicon']['value'] ?? '';
                        $favUrl = $favVal;
                        if ($favUrl && !preg_match('~^(https?://|/|data:)~i', $favUrl)) { $favUrl = BASE_URL . ltrim($favUrl, '/'); }
                    ?>
                    <span class="text-sm text-gray-700 mb-2">Preview</span>
                    <?php if ($favVal): ?>
                        <img alt="Favicon preview" src="<?= htmlspecialchars($favUrl) ?>" class="h-10 w-10 object-contain">
                    <?php else: ?>
                        <div class="text-gray-400 text-sm">No favicon set</div>
                    <?php endif; ?>
                </div>
            </div>
            <div>
                <button type="submit" class="bg-primary hover:bg-blue-600 text-white px-4 py-2 rounded">
                    <i class="fas fa-save mr-1"></i> Save Branding
                </button>
            </div>
        </form>
    </div>

    <form method="POST" action="<?= BASE_URL ?>?page=settings&action=update" class="space-y-8">
        <!-- Application Mode -->
        <!--        <div class="border-b border-gray-200 pb-6">-->
        <!--            <h2 class="text-lg font-semibold text-gray-800 mb-4">-->
        <!--                <i class="fas fa-server mr-2 text-primary"></i>-->
        <!--                Application Mode-->
        <!--            </h2>-->
        <!--            <div class="space-y-4">-->
        <!--                <div>-->
        <!--                    <label class="block text-sm font-medium text-gray-700 mb-2">-->
        <!--                        Environment Mode-->
        <!--                    </label>-->
        <!--                    <div class="flex items-center">-->
        <!--                        <span class="text-sm mr-3">Development</span>-->
        <!--                        <label class="inline-flex relative items-center cursor-pointer select-none">-->
        <!--                            <input type="checkbox" id="app_mode_switch" name="app_mode_switch" class="sr-only" -->
        <?php //= ($dbSettings['app_mode']['value'] ?? '') === 'production' ? 'checked' : '' ?><!-- />-->
        <!--                            <div id="app_mode_track" class="w-14 h-7 rounded-full transition relative -->
        <?php //= ($dbSettings['app_mode']['value'] ?? '') === 'production' ? 'bg-green-500' : 'bg-red-500' ?><!--">-->
        <!--                                <span id="app_mode_knob" class="absolute left-1 top-1 w-5 h-5 bg-white rounded-full transition transform -->
        <?php //= ($dbSettings['app_mode']['value'] ?? '') === 'production' ? 'translate-x-7' : '' ?><!--"></span>-->
        <!--                            </div>-->
        <!--                        </label>-->
        <!--                        <span class="text-sm ml-3">Production</span>-->
        <!--                    </div>-->
        <!--                    <input type="hidden" name="app_mode" id="app_mode_value" value="-->
        <?php //= ($dbSettings['app_mode']['value'] ?? '') === 'production' ? 'production' : 'development' ?><!--">-->
        <!--                    <p class="text-sm text-gray-500 mt-1">-->
        <!--                        Development mode hides the main page with a message for non-admin users-->
        <!--                    </p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->

        <!-- Google Maps API -->
        <div class="border-b border-gray-200 pb-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">
                <i class="fas fa-map mr-2 text-primary"></i>
                Google Maps Integration
            </h2>
            <div>
                <label for="google_maps_api_key" class="block text-sm font-medium text-gray-700 mb-2">
                    Google Maps API Key
                </label>
                <div class="flex items-center space-x-3">
                    <div class="flex-1 relative">
                        <input type="password"
                               id="google_maps_api_key"
                               name="google_maps_api_key"
                               value="<?= str_repeat('*', min(40, strlen($dbSettings['google_maps_api_key']['value'] ?? ''))) ?>"
                               class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                               placeholder="Enter your Google Maps API key" readonly>
                        <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                            <button type="button"
                                    id="toggleApiKey"
                                    class="text-gray-400 hover:text-gray-600"
                                    onclick="toggleApiKeyVisibility()">
                                <i class="fas fa-eye" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>
                    <button type="button"
                            id="editApiKey"
                            onclick="editApiKey()"
                            class="bg-primary hover:bg-blue-600 text-white px-4 py-2 rounded-md">
                        <i class="fas fa-edit mr-1"></i>
                        Edit
                    </button>
                    <button type="button"
                            id="saveApiKey"
                            onclick="saveApiKey()"
                            class="bg-green-600 hover:bg-green-700 text-white px-4 py-2 rounded-md hidden">
                        <i class="fas fa-save mr-1"></i>
                        Save
                    </button>
                    <button type="button"
                            id="cancelApiKey"
                            onclick="cancelApiKeyEdit()"
                            class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-md hidden">
                        <i class="fas fa-times mr-1"></i>
                        Cancel
                    </button>
                </div>
                <p class="text-sm text-gray-500 mt-1">
                    Required for geocoding, distance calculations, and map display
                </p>
                <input type="hidden" id="original_api_key"
                       value="<?= htmlspecialchars($dbSettings['google_maps_api_key']['value'] ?? '') ?>">
            </div>
        </div>

        <!-- Authentication Settings -->
        <div class="border-b border-gray-200 pb-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">
                <i class="fas fa-shield-alt mr-2 text-primary"></i>
                Authentication Settings
            </h2>
            <div id="ldap_settings">
                <label class="flex items-center">
                    <input type="checkbox"
                           name="ldap_enabled"
                           value="1"
                            <?= ($dbSettings['ldap_enabled']['value'] ?? false) ? 'checked' : '' ?>
                           class="rounded border-gray-300 text-primary focus:ring-primary">
                    <span class="ml-2 text-sm text-gray-700">Enable LDAP Authentication</span>
                </label>
                <p class="text-sm text-gray-500 mt-1 ml-6">
                    When enabled, users must authenticate through LDAP. Disabled in development mode.
                </p>

                <div class="mt-4 p-4 bg-blue-50 rounded-md">
                    <h4 class="text-sm font-medium text-blue-800 mb-2">LDAP Configuration</h4>
                    <div class="text-sm text-blue-700 space-y-1">
                        <p><strong>Server:</strong> <?= LDAP_HOST ?></p>
                        <p><strong>Base DN:</strong> <?= LDAP_BASE_DN ?></p>
                        <p><strong>Security Group:</strong> <?= LDAP_SECURITY_GROUP ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Information -->
        <div class="bg-gray-50 rounded-lg p-6">
            <h2 class="text-lg font-semibold text-gray-800 mb-4">
                <i class="fas fa-info-circle mr-2 text-primary"></i>
                System Information
            </h2>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 text-sm">
                <div>
                    <h4 class="font-medium text-gray-700 mb-2">Application</h4>
                    <div class="space-y-1 text-gray-600">
                        <p><strong>Name:</strong> <?= APP_NAME ?></p>
                        <p><strong>Version:</strong> <?= APP_VERSION ?></p>
                        <p><strong>PHP Version:</strong> <?= PHP_VERSION ?></p>
                    </div>
                </div>
                <div>
                    <h4 class="font-medium text-gray-700 mb-2">Database</h4>
                    <div class="space-y-1 text-gray-600">
                        <p><strong>Host:</strong> <?= DB_HOST ?></p>
                        <p><strong>Database:</strong> <?= DB_NAME ?></p>
                        <p><strong>Connection:</strong>
                            <span class="text-green-600">
                                <i class="fas fa-check-circle mr-1"></i>
                                Connected
                            </span>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Form Actions -->
        <div class="flex justify-end space-x-4 pt-6 border-t">
            <button type="button"
                    onclick="resetForm()"
                    class="px-6 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md font-medium">
                <i class="fas fa-undo mr-2"></i>
                Reset
            </button>
            <button type="submit"
                    class="px-6 py-2 bg-primary hover:bg-blue-600 text-white rounded-md font-medium">
                <i class="fas fa-save mr-2"></i>
                Save Settings
            </button>
        </div>
    </form>
</div>

<script>
    let isEditingApiKey = false;
    let originalApiKey = '';

    function toggleLDAPSettings() {
        const switchEl = document.getElementById('app_mode_switch');
        const isProd = switchEl && switchEl.checked;
        const ldapSettings = document.getElementById('ldap_settings');
        const ldapCheckbox = document.querySelector('input[name="ldap_enabled"]');
        const hidden = document.getElementById('app_mode_value');
        const track = document.getElementById('app_mode_track');
        const knob = document.getElementById('app_mode_knob');

        // Update hidden input
        if (hidden) hidden.value = isProd ? 'production' : 'development';

        // Update switch colors and position
        if (track && knob) {
            track.classList.remove('bg-green-500', 'bg-red-500');
            track.classList.add(isProd ? 'bg-green-500' : 'bg-red-500');
            knob.classList.toggle('translate-x-7', !!isProd);
        }

        if (!ldapSettings || !ldapCheckbox) return;
        if (!isProd) {
            ldapCheckbox.disabled = true;
            ldapCheckbox.checked = false;
            ldapSettings.style.opacity = '0.5';
        } else {
            ldapCheckbox.disabled = false;
            ldapSettings.style.opacity = '1';
        }
    }

    function toggleApiKeyVisibility() {
        const input = document.getElementById('google_maps_api_key');
        const eyeIcon = document.getElementById('eyeIcon');

        if (input.type === 'password') {
            input.type = 'text';
            eyeIcon.className = 'fas fa-eye-slash';
        } else {
            input.type = 'password';
            eyeIcon.className = 'fas fa-eye';
        }
    }

    function editApiKey() {
        isEditingApiKey = true;
        originalApiKey = document.getElementById('original_api_key').value;

        const input = document.getElementById('google_maps_api_key');
        const editBtn = document.getElementById('editApiKey');
        const saveBtn = document.getElementById('saveApiKey');
        const cancelBtn = document.getElementById('cancelApiKey');

        input.value = originalApiKey;
        input.type = 'text';
        input.readOnly = false;
        input.focus();

        editBtn.classList.add('hidden');
        saveBtn.classList.remove('hidden');
        cancelBtn.classList.remove('hidden');
    }

    function saveApiKey() {
        const input = document.getElementById('google_maps_api_key');
        const newApiKey = input.value.trim();

        if (!newApiKey) {
            alert('Please enter a valid API key');
            return;
        }

        // Update the hidden field
        document.getElementById('original_api_key').value = newApiKey;

        // Show masked version
        input.value = '*'.repeat(Math.min(40, newApiKey.length));
        input.type = 'password';
        input.readOnly = true;

        const editBtn = document.getElementById('editApiKey');
        const saveBtn = document.getElementById('saveApiKey');
        const cancelBtn = document.getElementById('cancelApiKey');

        editBtn.classList.remove('hidden');
        saveBtn.classList.add('hidden');
        cancelBtn.classList.add('hidden');

        isEditingApiKey = false;

        // Show success message
        showNotification('API key updated. Remember to save settings to persist changes.', 'success');
    }

    function cancelApiKeyEdit() {
        const input = document.getElementById('google_maps_api_key');
        const editBtn = document.getElementById('editApiKey');
        const saveBtn = document.getElementById('saveApiKey');
        const cancelBtn = document.getElementById('cancelApiKey');

        // Restore masked version
        input.value = '*'.repeat(Math.min(40, originalApiKey.length));
        input.type = 'password';
        input.readOnly = true;

        editBtn.classList.remove('hidden');
        saveBtn.classList.add('hidden');
        cancelBtn.classList.add('hidden');

        isEditingApiKey = false;
    }

    function resetForm() {
        if (confirm('Are you sure you want to reset all settings to their current saved values?')) {
            location.reload();
        }
    }

    function showNotification(message, type) {
        const notification = document.createElement('div');
        notification.className = `fixed top-4 right-4 p-4 rounded-md z-50 ${type === 'success' ? 'bg-green-100 text-green-700 border border-green-400' : 'bg-red-100 text-red-700 border border-red-400'}`;
        notification.innerHTML = `
        <div class="flex items-center">
            <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
            ${message}
        </div>
    `;

        document.body.appendChild(notification);

        setTimeout(() => {
            notification.remove();
        }, 5000);
    }

    // Initialize LDAP settings state and enhance API key editing UX
    document.addEventListener('DOMContentLoaded', function () {
        toggleLDAPSettings();
        const modeSwitch = document.getElementById('app_mode_switch');
        if (modeSwitch) {
            modeSwitch.addEventListener('change', toggleLDAPSettings);
        }
        const apiInput = document.getElementById('google_maps_api_key');
        if (apiInput) {
            // Auto-enter edit mode when focusing the field to make it feel editable
            apiInput.addEventListener('focus', function () {
                if (apiInput.readOnly) {
                    editApiKey();
                }
            });
        }
    });

    // Form validation and submission
    // - Ensure API key submits actual value (not masked)
    // - Ensure app_mode hidden reflects the switch state on submit
    document.querySelector('form').addEventListener('submit', function (e) {
        // API key unmask for submit
        const input = document.getElementById('google_maps_api_key');
        const original = document.getElementById('original_api_key').value;
        const masked = input.value && /^[*]+$/.test(input.value);
        if (masked) {
            input.value = original;
        }

        // Set app_mode from switch
        const modeSwitch = document.getElementById('app_mode_switch');
        const modeHidden = document.getElementById('app_mode_value');
        if (modeHidden) {
            modeHidden.value = (modeSwitch && modeSwitch.checked) ? 'production' : 'development';
        }
    });
</script>