<div class="max-w-6xl mx-auto">
    <!-- Add/Edit Form -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-plus mr-2 text-primary"></i>
            <span id="formTitle">Add New Material</span>
        </h2>

        <form id="materialForm" method="POST" class="space-y-4">
            <input type="hidden" id="materialId" name="id" value="">
            <input type="hidden" name="page" value="materials">
            <input type="hidden" id="formAction" name="action" value="add">

            <!-- Code, Name, Group in one row -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <!-- Material Code -->
                <div>
                    <label for="code" class="block text-sm font-medium text-gray-700 mb-1">
                        <i class="fas fa-barcode mr-1"></i>
                        Material Code *
                    </label>
                    <input type="text"
                           id="code"
                           name="code"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                           placeholder="e.g., MAT001"
                           required>
                </div>

                <!-- Material Name -->
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-1">
                        <i class="fas fa-tag mr-1"></i>
                        Material Name *
                    </label>
                    <input type="text"
                           id="name"
                           name="name"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                           placeholder="e.g., Steel Rebar"
                           required>
                </div>

                <!-- Material Group -->
                <div>
                    <label for="material_group" class="block text-sm font-medium text-gray-700 mb-1">
                        <i class="fas fa-layer-group mr-1"></i>
                        Material Group *
                    </label>
                    <input type="text"
                           id="material_group"
                           name="material_group"
                           list="groups"
                           class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                           placeholder="e.g., Construction Materials"
                           required>
                    <datalist id="groups">
                        <?php foreach ($groups as $group): ?>
                        <option value="<?= htmlspecialchars($group['material_group']) ?>">
                            <?php endforeach; ?>
                    </datalist>
                </div>
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">
                    <i class="fas fa-align-left mr-1"></i>
                    Description
                </label>
                <textarea id="description"
                          name="description"
                          rows="2"
                          class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                          placeholder="Optional description..."></textarea>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end space-x-3">
                <button type="button"
                        id="cancelBtn"
                        onclick="resetForm()"
                        class="px-4 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md">
                    <i class="fas fa-times mr-1"></i>
                    Cancel
                </button>
                <button type="submit"
                        class="px-4 py-2 bg-primary hover:bg-blue-600 text-white rounded-md">
                    <i class="fas fa-save mr-1"></i>
                    <span id="submitText">Add Material</span>
                </button>
            </div>
        </form>

    </div>

    <!-- Materials List -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex justify-between items-center mb-6">
            <h1 class="text-2xl font-bold text-gray-800">
                <i class="fas fa-boxes mr-2 text-primary"></i>
                Materials Management
            </h1>
            
            <!-- Search Form -->
            <form method="GET" class="flex gap-2">
                <input type="hidden" name="page" value="materials">
                <input type="text" 
                       name="search" 
                       value="<?= htmlspecialchars($search) ?>"
                       placeholder="Search materials..."
                       class="px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary">
                <button type="submit" class="bg-gray-500 hover:bg-gray-600 text-white px-3 py-2 rounded-md">
                    <i class="fas fa-search"></i>
                </button>
                <?php if ($search): ?>
                    <a href="<?= BASE_URL ?>?page=materials" class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-3 py-2 rounded-md">
                        <i class="fas fa-times"></i>
                    </a>
                <?php endif; ?>
            </form>
        </div>
        
        <?php if (empty($materials)): ?>
            <div class="text-center py-12">
                <i class="fas fa-boxes text-6xl text-gray-300 mb-4"></i>
                <h3 class="text-lg font-medium text-gray-900 mb-2">No materials found</h3>
                <p class="text-gray-500 mb-4">
                    <?= $search ? 'No materials match your search criteria.' : 'Get started by adding your first material above.' ?>
                </p>
            </div>
        <?php else: ?>
            <!-- Materials Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                #
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Code
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Name
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Group
                            </th>
<!--                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">-->
<!--                                Price-->
<!--                            </th>-->
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Actions
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php foreach ($materials as $index => $material): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?= (($pagination['page'] - 1) * $pagination['perPage']) + $index + 1 ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="text-sm font-medium text-gray-900">
                                        <?= htmlspecialchars($material['code']) ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">
                                        <?= htmlspecialchars($material['name']) ?>
                                    </div>
                                    <?php if (!empty($material['description'])): ?>
                                        <div class="text-sm text-gray-500">
                                            <?= htmlspecialchars(substr($material['description'], 0, 50)) ?>
                                            <?= strlen($material['description']) > 50 ? '...' : '' ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                        <?= htmlspecialchars($material['material_group']) ?>
                                    </span>
                                </td>
<!--                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">-->
<!--                                    $--><?php //= number_format($material['price'], 2) ?>
<!--                                </td>-->
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                    <button onclick="editMaterial(<?= htmlspecialchars(json_encode($material)) ?>)" 
                                            class="text-primary hover:text-blue-600">
                                        <i class="fas fa-edit mr-1"></i>
                                        Edit
                                    </button>
                                    <button onclick="deleteMaterial(<?= $material['id'] ?>, '<?= htmlspecialchars($material['name']) ?>')" 
                                            class="text-red-600 hover:text-red-800">
                                        <i class="fas fa-trash mr-1"></i>
                                        Delete
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if ($pagination['totalPages'] > 1): ?>
                <div class="mt-6 flex items-center justify-between">
                    <div class="text-sm text-gray-700">
                        Showing <?= (($pagination['page'] - 1) * $pagination['perPage']) + 1 ?> to 
                        <?= min($pagination['page'] * $pagination['perPage'], $pagination['total']) ?> of 
                        <?= $pagination['total'] ?> results
                    </div>
                    
                    <div class="flex space-x-2">
                        <?php if ($pagination['page'] > 1): ?>
                            <a href="<?= BASE_URL ?>?page=materials&p=<?= $pagination['page'] - 1 ?><?= $search ? '&search=' . urlencode($search) : '' ?>" 
                               class="px-3 py-2 text-sm bg-gray-200 hover:bg-gray-300 rounded-md">
                                <i class="fas fa-chevron-left mr-1"></i>
                                Previous
                            </a>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $pagination['page'] - 2); $i <= min($pagination['totalPages'], $pagination['page'] + 2); $i++): ?>
                            <a href="<?= BASE_URL ?>?page=materials&p=<?= $i ?><?= $search ? '&search=' . urlencode($search) : '' ?>" 
                               class="px-3 py-2 text-sm <?= $i === $pagination['page'] ? 'bg-primary text-white' : 'bg-gray-200 hover:bg-gray-300' ?> rounded-md">
                                <?= $i ?>
                            </a>
                        <?php endfor; ?>
                        
                        <?php if ($pagination['page'] < $pagination['totalPages']): ?>
                            <a href="<?= BASE_URL ?>?page=materials&p=<?= $pagination['page'] + 1 ?><?= $search ? '&search=' . urlencode($search) : '' ?>" 
                               class="px-3 py-2 text-sm bg-gray-200 hover:bg-gray-300 rounded-md">
                                Next
                                <i class="fas fa-chevron-right ml-1"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl max-w-md w-full">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="flex-shrink-0">
                        <i class="fas fa-exclamation-triangle text-red-500 text-2xl"></i>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-lg font-medium text-gray-900">Delete Material</h3>
                    </div>
                </div>
                <div class="mb-4">
                    <p class="text-sm text-gray-500">
                        Are you sure you want to delete "<span id="deleteMaterialName"></span>"? 
                        This action cannot be undone.
                    </p>
                </div>
                <div class="flex justify-end space-x-3">
                    <button onclick="closeDeleteModal()" 
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md">
                        Cancel
                    </button>
                    <form id="deleteForm" method="POST" class="inline">
                        <input type="hidden" name="page" value="materials">
                        <input type="hidden" name="action" value="delete">
                        <button type="submit" 
                                class="px-4 py-2 text-sm font-medium text-white bg-red-600 hover:bg-red-700 rounded-md">
                            Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function editMaterial(material) {
    document.getElementById('formTitle').textContent = 'Edit Material';
    document.getElementById('materialId').value = material.id;
    document.getElementById('formAction').value = 'edit';
    document.getElementById('code').value = material.code;
    document.getElementById('name').value = material.name;
    document.getElementById('material_group').value = material.material_group;
    // document.getElementById('price').value = material.price;
    document.getElementById('description').value = material.description || '';
    document.getElementById('submitText').textContent = 'Update Material';
    
    // Scroll to form
    document.getElementById('materialForm').scrollIntoView({ behavior: 'smooth' });
}

function resetForm() {
    document.getElementById('formTitle').textContent = 'Add New Material';
    document.getElementById('materialId').value = '';
    document.getElementById('formAction').value = 'add';
    document.getElementById('materialForm').reset();
    document.getElementById('submitText').textContent = 'Add Material';
}

function deleteMaterial(id, name) {
    document.getElementById('deleteMaterialName').textContent = name;
    document.getElementById('deleteForm').action = '<?= BASE_URL ?>?page=materials&action=delete&id=' + id;
    document.getElementById('deleteModal').classList.remove('hidden');
}

function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}

// Close modal when clicking outside
document.getElementById('deleteModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeDeleteModal();
    }
});

// Handle form submission
document.getElementById('materialForm').addEventListener('submit', function(e) {
    const action = document.getElementById('formAction').value;
    const id = document.getElementById('materialId').value;
    
    if (action === 'edit' && id) {
        this.action = '<?= BASE_URL ?>?page=materials&action=edit&id=' + id;
    } else {
        this.action = '<?= BASE_URL ?>?page=materials&action=add';
    }
});
</script>