<div class="bg-white rounded-lg shadow-md p-6">
    <div class="flex items-center mb-6">
        <a href="<?= BASE_URL ?>materials" class="text-gray-500 hover:text-gray-700 mr-4">
            <i class="fas fa-arrow-left text-xl"></i>
        </a>
        <h1 class="text-2xl font-bold text-gray-800">
            <i class="fas fa-boxes mr-2 text-primary"></i>
            <?= $isEdit ? 'Edit Material' : 'Add New Material' ?>
        </h1>
    </div>
    
    <?php if (!empty($errors['general'])): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
            <i class="fas fa-exclamation-circle mr-2"></i>
            <?= htmlspecialchars($errors['general']) ?>
        </div>
    <?php endif; ?>
    
    <form method="POST" class="space-y-6">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Material Code -->
            <div>
                <label for="code" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-barcode mr-1"></i>
                    Material Code *
                </label>
                <input type="text" 
                       id="code" 
                       name="code" 
                       value="<?= htmlspecialchars($material['code'] ?? '') ?>"
                       class="w-full px-4 py-2 border <?= isset($errors['code']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                       placeholder="e.g., MAT001"
                       required>
                <?php if (isset($errors['code'])): ?>
                    <p class="text-red-500 text-sm mt-1">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?= htmlspecialchars($errors['code']) ?>
                    </p>
                <?php endif; ?>
            </div>
            
            <!-- Material Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-tag mr-1"></i>
                    Material Name *
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       value="<?= htmlspecialchars($material['name'] ?? '') ?>"
                       class="w-full px-4 py-2 border <?= isset($errors['name']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                       placeholder="e.g., Steel Rebar"
                       required>
                <?php if (isset($errors['name'])): ?>
                    <p class="text-red-500 text-sm mt-1">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?= htmlspecialchars($errors['name']) ?>
                    </p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Material Group -->
            <div>
                <label for="material_group" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-layer-group mr-1"></i>
                    Material Group *
                </label>
                <input type="text" 
                       id="material_group" 
                       name="material_group" 
                       value="<?= htmlspecialchars($material['material_group'] ?? '') ?>"
                       list="groups"
                       class="w-full px-4 py-2 border <?= isset($errors['material_group']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                       placeholder="e.g., Construction Materials"
                       required>
                <datalist id="groups">
                    <?php foreach ($groups as $group): ?>
                        <option value="<?= htmlspecialchars($group['material_group']) ?>">
                    <?php endforeach; ?>
                </datalist>
                <?php if (isset($errors['material_group'])): ?>
                    <p class="text-red-500 text-sm mt-1">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?= htmlspecialchars($errors['material_group']) ?>
                    </p>
                <?php endif; ?>
            </div>
            
            <!-- Price -->
<!--            <div>-->
<!--                <label for="price" class="block text-sm font-medium text-gray-700 mb-2">-->
<!--                    <i class="fas fa-dollar-sign mr-1"></i>-->
<!--                    Price *-->
<!--                </label>-->
<!--                <div class="relative">-->
<!--                    <span class="absolute left-3 top-2 text-gray-500">$</span>-->
<!--                    <input type="number" -->
<!--                           id="price" -->
<!--                           name="price" -->
<!--                           value="--><?php //= htmlspecialchars($material['price'] ?? '') ?><!--"-->
<!--                           step="0.01"-->
<!--                           min="0"-->
<!--                           class="w-full pl-8 pr-4 py-2 border --><?php //= isset($errors['price']) ? 'border-red-500' : 'border-gray-300' ?><!-- rounded-md focus:ring-primary focus:border-primary"-->
<!--                           placeholder="0.00"-->
<!--                           required>-->
<!--                </div>-->
<!--                --><?php //if (isset($errors['price'])): ?>
<!--                    <p class="text-red-500 text-sm mt-1">-->
<!--                        <i class="fas fa-exclamation-circle mr-1"></i>-->
<!--                        --><?php //= htmlspecialchars($errors['price']) ?>
<!--                    </p>-->
<!--                --><?php //endif; ?>
<!--            </div>-->
        </div>
        
        <!-- Description -->
        <div>
            <label for="description" class="block text-sm font-medium text-gray-700 mb-2">
                <i class="fas fa-align-left mr-1"></i>
                Description
            </label>
            <textarea id="description" 
                      name="description" 
                      rows="3"
                      class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                      placeholder="Optional description of the material..."><?= htmlspecialchars($material['description'] ?? '') ?></textarea>
        </div>
        
        <!-- Form Actions -->
        <div class="flex justify-end space-x-4 pt-6 border-t">
            <a href="<?= BASE_URL ?>materials" 
               class="px-6 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md font-medium">
                <i class="fas fa-times mr-2"></i>
                Cancel
            </a>
            <button type="submit" 
                    class="px-6 py-2 bg-primary hover:bg-blue-600 text-white rounded-md font-medium">
                <i class="fas fa-save mr-2"></i>
                <?= $isEdit ? 'Update Material' : 'Add Material' ?>
            </button>
        </div>
    </form>
</div>

<script>
// Auto-suggest for material groups
document.getElementById('material_group').addEventListener('input', function() {
    // This could be enhanced with AJAX to get suggestions from the server
});

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const code = document.getElementById('code').value.trim();
    const name = document.getElementById('name').value.trim();
    const group = document.getElementById('material_group').value.trim();
    // const price = document.getElementById('price').value;
    
    if (!code || !name || !group) {
        e.preventDefault();
        alert('Please fill in all required fields.');
        return false;
    }
    
    // if (parseFloat(price) < 0) {
    //     e.preventDefault();
    //     alert('Price cannot be negative.');
    //     return false;
    // }
});
</script>