<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Maintenance Mode - <?= APP_NAME ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="text-center">
        <div class="mb-8">
            <i class="fas fa-map-marked-alt text-6xl text-primary mb-4"></i>
            <h1 class="text-4xl font-bold text-gray-800 mb-2"><?= APP_NAME ?></h1>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-8 max-w-md">
            <i class="fas fa-tools text-6xl text-orange-500 mb-4"></i>
            <h2 class="text-2xl font-bold text-gray-800 mb-4">Under Maintenance</h2>
            <p class="text-gray-600 mb-6">
                We're currently performing scheduled maintenance. Please check back soon.
            </p>
            <div class="text-sm text-gray-500">
                <p>If you're an administrator, you can still access the system:</p>
                <a href="<?= BASE_URL ?>login" 
                   class="text-primary hover:text-blue-600 font-medium">
                    <i class="fas fa-sign-in-alt mr-1"></i>
                    Admin Login
                </a>
            </div>
        </div>
    </div>
</body>
</html>