<div class="max-w-6xl mx-auto">
    <!-- Add/Edit Form - Full Width with Two Column Layout -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h2 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-plus mr-2 text-primary"></i>
            <span id="formTitle">Add New Location</span>
        </h2>
        
        <form id="locationForm" method="POST" class="space-y-6">
            <input type="hidden" id="locationId" name="id" value="">
            <input type="hidden" name="page" value="locations">
            <input type="hidden" id="formAction" name="action" value="add">
            <input type="hidden" id="latitude" name="latitude" value="">
            <input type="hidden" id="longitude" name="longitude" value="">
            
            <!-- Two Column Layout -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                
                <!-- Left Column: Location Details -->
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-800 border-b border-gray-200 pb-2">
                        <i class="fas fa-map-marker-alt mr-2 text-primary"></i>
                        Location Details
                    </h3>
                    
                    <!-- Location Name -->
                    <div>
                        <label for="locationName" class="block text-sm font-medium text-gray-700 mb-1">
                            <i class="fas fa-building mr-1"></i>
                            Location Name *
                        </label>
                        <input type="text" 
                               id="locationName" 
                               name="name" 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                               placeholder="e.g., Downtown Production Facility"
                               required>
                    </div>
                    
                    <!-- Address Search -->
                    <div>
                        <label for="address_search" class="block text-sm font-medium text-gray-700 mb-1">
                            <i class="fas fa-search mr-1"></i>
                            Search Address
                        </label>
                        <div class="flex gap-2">
                            <input type="text" 
                                   id="address_search" 
                                   class="flex-1 px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                                   placeholder="Enter address to search">
                            <button type="button" 
                                    id="find_address" 
                                    class="bg-primary hover:bg-blue-600 text-white px-3 py-2 rounded-md">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </div>
                    
                    <!-- Address Line 1 -->
                    <div>
                        <label for="address_line1" class="block text-sm font-medium text-gray-700 mb-1">
                            Street Address *
                        </label>
                        <input type="text" 
                               id="address_line1" 
                               name="address_line1" 
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                               required>
                    </div>
                    
                    <!-- City, Province, Postal Code Row -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-3">
                        <div>
                            <label for="city" class="block text-sm font-medium text-gray-700 mb-1">
                                City *
                            </label>
                            <input type="text" 
                                   id="city" 
                                   name="city" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                                   required>
                        </div>
                        
                        <div>
                            <label for="province" class="block text-sm font-medium text-gray-700 mb-1">
                                Province *
                            </label>
                            <input type="text" 
                                   id="province" 
                                   name="province" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                                   required>
                        </div>
                        
                        <div>
                            <label for="postal_code" class="block text-sm font-medium text-gray-700 mb-1">
                                Postal Code *
                            </label>
                            <input type="text" 
                                   id="postal_code" 
                                   name="postal_code" 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                                   required>
                        </div>
                    </div>
                    
                    <!-- Country -->
                    <div>
                        <label for="country" class="block text-sm font-medium text-gray-700 mb-1">
                            Country
                        </label>
                        <input type="text" 
                               id="country" 
                               name="country" 
                               value="Canada"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary">
                    </div>
                </div>
                
                <!-- Right Column: Materials Selection -->
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-800 border-b border-gray-200 pb-2">
                        <i class="fas fa-industry mr-2 text-primary"></i>
                        Materials Produced
                    </h3>
                    
                    <div class="bg-gray-50 rounded-lg p-4 border border-gray-200">
                        <?php if (empty($materials)): ?>
                            <div class="text-center py-8">
                                <i class="fas fa-boxes text-4xl text-gray-300 mb-3"></i>
                                <p class="text-gray-500 text-sm">No materials available.</p>
                                <p class="text-gray-400 text-xs">Please add materials first.</p>
                            </div>
                        <?php else: ?>
                            <div class="max-h-80 overflow-y-auto">
                                <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-3">
                                    <?php foreach ($materials as $material): ?>
                                        <label class="flex items-start space-x-2 p-2 hover:bg-white rounded-md cursor-pointer transition-colors">
                                            <input type="checkbox" 
                                                   name="materials[<?= $material['id'] ?>][selected]" 
                                                   value="1"
                                                   data-material-id="<?= $material['id'] ?>"
                                                   class="material-checkbox mt-1 rounded border-gray-300 text-primary focus:ring-primary">
                                            <div class="flex-1 min-w-0">
                                                <div class="text-sm font-medium text-gray-900 truncate">
                                                    <?= htmlspecialchars($material['name']) ?>
                                                </div>
                                                <div class="text-xs text-gray-500">
                                                    <?= htmlspecialchars($material['code']) ?>
                                                </div>
<!--                                                <div class="text-xs text-green-600 font-medium">-->
<!--                                                    $--><?php //= number_format($material['price'], 2) ?>
<!--                                                </div>-->
                                            </div>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <div class="mt-4 pt-3 border-t border-gray-200">
                            <p class="text-xs text-gray-500 flex items-center">
                                <i class="fas fa-info-circle mr-1"></i>
                                Select all materials that are produced at this location. Since these are materials in continuous production, they are always in stock.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Form Actions -->
            <div class="flex justify-end space-x-3 pt-6 border-t">
                <button type="button" 
                        onclick="resetLocationForm()" 
                        class="px-6 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md font-medium">
                    <i class="fas fa-times mr-1"></i>
                    Cancel
                </button>
                <button type="submit" 
                        class="px-6 py-2 bg-primary hover:bg-blue-600 text-white rounded-md font-medium">
                    <i class="fas fa-save mr-1"></i>
                    <span id="submitLocationText">Add Location</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Map and Table Layout - Half Width Each -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Map Section - Left Side -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-gray-800">
                    <i class="fas fa-map mr-2 text-primary"></i>
                    Interactive Map
                </h3>
                <div class="text-sm text-gray-600">
                    <span class="bg-gray-100 px-2 py-1 rounded text-xs" id="locationCount">
                        <?= count($locations) ?> location(s)
                    </span>
                </div>
            </div>
            <div id="map" class="w-full h-96 bg-gray-200 rounded-md border"></div>
            <div class="mt-2 text-sm text-gray-600 space-y-1">
                <p><i class="fas fa-info-circle mr-1"></i>
                    Click on the map to set new location, or use address search above.
                </p>
                <div class="flex items-center space-x-4 text-xs">
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-red-500 rounded-full mr-1"></div>
                        <span>Active Locations</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-gray-400 rounded-full mr-1"></div>
                        <span>Inactive Locations</span>
                    </div>
                    <div class="flex items-center">
                        <div class="w-3 h-3 bg-green-500 rounded-full mr-1"></div>
                        <span>New/Edit Location</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Locations Table - Right Side -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-lg font-semibold text-gray-800">
                    <i class="fas fa-list mr-2 text-primary"></i>
                    Production Locations
                </h3>
                
                <!-- Live Search -->
                <div class="flex gap-2">
                    <div class="relative">
                        <input type="text" 
                               id="liveSearch" 
                               value="<?= htmlspecialchars($search) ?>"
                               placeholder="Search locations..."
                               class="px-2 py-1 text-sm border border-gray-300 rounded-md focus:ring-primary focus:border-primary pr-8">
                        <div class="absolute right-2 top-1/2 transform -translate-y-1/2">
                            <i class="fas fa-search text-gray-400 text-xs"></i>
                        </div>
                    </div>
                    <button id="clearSearch" 
                            class="bg-gray-300 hover:bg-gray-400 text-gray-700 px-2 py-1 rounded-md text-sm"
                            style="display: <?= $search ? 'block' : 'none' ?>">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
            
            <!-- Scrollable Table Container -->
            <div class="h-80 overflow-y-auto border border-gray-200 rounded-md">
                <div id="noResults" class="text-center py-12 hidden">
                    <i class="fas fa-search text-4xl text-gray-300 mb-4"></i>
                    <h4 class="text-lg font-medium text-gray-900 mb-2">No locations found</h4>
                    <p class="text-gray-500 text-sm">No locations match your search criteria.</p>
                </div>
                
                <?php if (empty($locations)): ?>
                    <div class="text-center py-12" id="emptyState">
                        <i class="fas fa-industry text-4xl text-gray-300 mb-4"></i>
                        <h4 class="text-lg font-medium text-gray-900 mb-2">No locations found</h4>
                        <p class="text-gray-500 text-sm">Add your first production location using the form above.</p>
                    </div>
                <?php else: ?>
                    <table class="min-w-full divide-y divide-gray-200" id="locationsTable">
                        <thead class="bg-gray-50 sticky top-0">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Location
                                </th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status
                                </th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Actions
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200" id="locationsTableBody">
                            <?php foreach ($locations as $location): ?>
                                <tr class="hover:bg-gray-50 location-row" 
                                    data-name="<?= htmlspecialchars(strtolower($location['name'])) ?>"
                                    data-city="<?= htmlspecialchars(strtolower($location['city'])) ?>"
                                    data-province="<?= htmlspecialchars(strtolower($location['province'])) ?>"
                                    data-postal="<?= htmlspecialchars(strtolower($location['postal_code'])) ?>"
                                    data-address="<?= htmlspecialchars(strtolower($location['address_line1'])) ?>">
                                    <td class="px-3 py-2">
                                        <div class="text-sm font-medium text-gray-900">
                                            <i class="fas fa-industry mr-1 text-primary"></i>
                                            <?= htmlspecialchars($location['name']) ?>
                                        </div>
                                        <div class="text-xs text-gray-500">
                                            <?= htmlspecialchars($location['city']) ?>, <?= htmlspecialchars($location['province']) ?>
                                        </div>
                                        <div class="text-xs text-gray-400">
                                            <?= htmlspecialchars($location['postal_code']) ?>
                                        </div>
                                    </td>
                                    <td class="px-3 py-2">
                                        <label class="relative inline-flex items-center cursor-pointer">
                                            <input type="checkbox" 
                                                   class="sr-only peer" 
                                                   <?= $location['active'] ? 'checked' : '' ?>
                                                   onchange="toggleLocation(<?= $location['id'] ?>, this)">
                                            <div class="w-9 h-5 rounded-full relative transition-all" style="background-color: <?= $location['active'] ? '#22c55e' : '#ef4444' ?>;">
                                                <span class="absolute left-[2px] top-[2px] h-4 w-4 bg-white rounded-full transition-transform <?= $location['active'] ? 'translate-x-4' : '' ?>"></span>
                                            </div>
                                        </label>
                                        <div class="text-xs mt-1 font-medium" style="color: <?= $location['active'] ? '#16a34a' : '#dc2626' ?>;">
                                            <?= $location['active'] ? 'Active' : 'Inactive' ?>
                                        </div>
                                    </td>
                                    <td class="px-3 py-2">
                                        <div class="flex flex-col space-y-1">
                                            <button onclick="zoomToLocation(<?= $location['latitude'] ?>, <?= $location['longitude'] ?>)" 
                                                    class="text-xs text-purple-600 hover:text-purple-800">
                                                <i class="fas fa-search-plus mr-1"></i>
                                                Zoom
                                            </button>
                                            <button onclick="editLocation(<?= htmlspecialchars(json_encode($location)) ?>)" 
                                                    class="text-xs text-primary hover:text-blue-600">
                                                <i class="fas fa-edit mr-1"></i>
                                                Edit
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
            
            <!-- Pagination -->
            <?php if ($pagination['totalPages'] > 1): ?>
                <div class="mt-4 flex items-center justify-between text-sm">
                    <div class="text-gray-700">
                        <?= $pagination['total'] ?> total
                    </div>
                    
                    <div class="flex space-x-1">
                        <?php if ($pagination['page'] > 1): ?>
                            <a href="<?= BASE_URL ?>?page=locations&p=<?= $pagination['page'] - 1 ?><?= $search ? '&search=' . urlencode($search) : '' ?>" 
                               class="px-2 py-1 text-xs bg-gray-200 hover:bg-gray-300 rounded">
                                <i class="fas fa-chevron-left"></i>
                            </a>
                        <?php endif; ?>
                        
                        <span class="px-2 py-1 text-xs bg-primary text-white rounded">
                            <?= $pagination['page'] ?>
                        </span>
                        
                        <?php if ($pagination['page'] < $pagination['totalPages']): ?>
                            <a href="<?= BASE_URL ?>?page=locations&p=<?= $pagination['page'] + 1 ?><?= $search ? '&search=' . urlencode($search) : '' ?>" 
                               class="px-2 py-1 text-xs bg-gray-200 hover:bg-gray-300 rounded">
                                <i class="fas fa-chevron-right"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<script>
let map;
let marker;
let geocoder;
let locationMarkers = [];
let allLocationRows = [];

// Store all location rows for filtering
document.addEventListener('DOMContentLoaded', function() {
    allLocationRows = Array.from(document.querySelectorAll('.location-row'));
    setupLiveSearch();
});

function setupLiveSearch() {
    const searchInput = document.getElementById('liveSearch');
    const clearButton = document.getElementById('clearSearch');
    const noResults = document.getElementById('noResults');
    const locationsTable = document.getElementById('locationsTable');
    const locationCount = document.getElementById('locationCount');
    
    // Live search functionality
    searchInput.addEventListener('input', function() {
        const searchTerm = this.value.toLowerCase().trim();
        
        if (searchTerm === '') {
            // Show all rows
            allLocationRows.forEach(row => {
                row.style.display = '';
            });
            clearButton.style.display = 'none';
            noResults.classList.add('hidden');
            if (locationsTable) locationsTable.style.display = '';
            updateLocationCount(allLocationRows.length);
            updateMapMarkers();
        } else {
            // Filter rows
            let visibleCount = 0;
            allLocationRows.forEach(row => {
                const name = row.dataset.name || '';
                const city = row.dataset.city || '';
                const province = row.dataset.province || '';
                const postal = row.dataset.postal || '';
                const address = row.dataset.address || '';
                
                const matches = name.includes(searchTerm) || 
                               city.includes(searchTerm) || 
                               province.includes(searchTerm) || 
                               postal.includes(searchTerm) || 
                               address.includes(searchTerm);
                
                if (matches) {
                    row.style.display = '';
                    visibleCount++;
                } else {
                    row.style.display = 'none';
                }
            });
            
            clearButton.style.display = 'block';
            
            if (visibleCount === 0) {
                noResults.classList.remove('hidden');
                if (locationsTable) locationsTable.style.display = 'none';
            } else {
                noResults.classList.add('hidden');
                if (locationsTable) locationsTable.style.display = '';
            }
            
            updateLocationCount(visibleCount);
            updateMapMarkers(searchTerm);
        }
    });
    
    // Clear search functionality
    clearButton.addEventListener('click', function() {
        searchInput.value = '';
        searchInput.dispatchEvent(new Event('input'));
        searchInput.focus();
    });
    
    // Enter key should not submit form
    searchInput.addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
        }
    });
}

function updateLocationCount(count) {
    const locationCount = document.getElementById('locationCount');
    if (locationCount) {
        locationCount.textContent = `${count} location(s)`;
    }
}

function updateMapMarkers(searchTerm = '') {
    if (!locationMarkers.length) return;
    
    locationMarkers.forEach(markerItem => {
        const marker = markerItem.marker;
        const title = marker.getTitle().toLowerCase();
        
        if (searchTerm === '') {
            // Show all markers
            marker.setVisible(true);
        } else {
            // Show only matching markers
            const matches = title.includes(searchTerm);
            marker.setVisible(matches);
        }
    });
    
    // Adjust map bounds to show visible markers
    if (searchTerm !== '') {
        const visibleMarkers = locationMarkers.filter(item => item.marker.getVisible());
        if (visibleMarkers.length > 0) {
            const bounds = new google.maps.LatLngBounds();
            visibleMarkers.forEach(item => {
                bounds.extend(item.marker.getPosition());
            });
            map.fitBounds(bounds);
            
            // Don't zoom in too much for single markers
            google.maps.event.addListenerOnce(map, 'bounds_changed', function() {
                if (map.getZoom() > 15) {
                    map.setZoom(15);
                }
            });
        }
    } else {
        // Reset to show all markers
        if (locationMarkers.length > 0) {
            const bounds = new google.maps.LatLngBounds();
            locationMarkers.forEach(item => {
                bounds.extend(item.marker.getPosition());
            });
            map.fitBounds(bounds);
        }
    }
}

function initMap() {
    geocoder = new google.maps.Geocoder();
    
    // Initialize map centered on Canada
    map = new google.maps.Map(document.getElementById('map'), {
        zoom: 4,
        center: { lat: 56.1304, lng: -106.3468 }
    });
    
    // Add click listener to map
    map.addListener('click', function(e) {
        placeMarker(e.latLng);
    });
    
    // Add existing location markers and store them in array
    const bounds = new google.maps.LatLngBounds();
    let hasLocations = false;
    
    <?php foreach ($locations as $location): ?>
        const marker<?= $location['id'] ?> = new google.maps.Marker({
            position: { lat: <?= $location['latitude'] ?>, lng: <?= $location['longitude'] ?> },
            map: map,
            title: '<?= htmlspecialchars($location['name']) ?>',
            icon: {
                url: <?= $location['active'] ? "'https://maps.google.com/mapfiles/ms/icons/red-dot.png'" : "'https://maps.google.com/mapfiles/ms/icons/grey-dot.png'" ?>
            }
        });
        
        // Store marker reference
        locationMarkers.push({
            id: <?= $location['id'] ?>,
            marker: marker<?= $location['id'] ?>,
            active: <?= $location['active'] ? 'true' : 'false' ?>
        });
        
        const infoWindow<?= $location['id'] ?> = new google.maps.InfoWindow({
            content: `
                <div class="p-3 max-w-xs">
                    <h4 class="font-bold text-<?= $location['active'] ? 'red' : 'gray' ?>-600 mb-2">
                        <i class="fas fa-industry mr-1"></i>
                        <?= htmlspecialchars($location['name']) ?>
                    </h4>
                    <div class="space-y-1 text-sm">
                        <p><i class="fas fa-map-marker-alt mr-1 text-gray-400"></i><?= htmlspecialchars($location['address_line1']) ?></p>
                        <p class="ml-4"><?= htmlspecialchars($location['city']) ?>, <?= htmlspecialchars($location['province']) ?> <?= htmlspecialchars($location['postal_code']) ?></p>
                        <p><i class="fas fa-info-circle mr-1 text-gray-400"></i>
                            <span class="text-<?= $location['active'] ? 'green' : 'red' ?>-600 font-medium">
                                <?= $location['active'] ? 'Active Production' : 'Inactive' ?>
                            </span>
                        </p>
                        <p class="text-xs text-blue-600">Materials production facility</p>
                    </div>
                    <div class="mt-3 pt-2 border-t border-gray-200 flex gap-2">
                        <button onclick="editLocation(<?= htmlspecialchars(json_encode($location)) ?>)" 
                                class="text-xs bg-blue-500 hover:bg-blue-600 text-white px-2 py-1 rounded flex items-center">
                            <i class="fas fa-edit mr-1"></i>Edit
                        </button>
                        <button onclick="zoomToLocation(<?= $location['latitude'] ?>, <?= $location['longitude'] ?>)" 
                                class="text-xs bg-purple-500 hover:bg-purple-600 text-white px-2 py-1 rounded flex items-center">
                            <i class="fas fa-search-plus mr-1"></i>Zoom
                        </button>
                    </div>
                </div>
            `
        });
        
        marker<?= $location['id'] ?>.addListener('click', function() {
            // Close all other info windows
            <?php foreach ($locations as $loc): ?>
                if (<?= $loc['id'] ?> !== <?= $location['id'] ?>) {
                    infoWindow<?= $loc['id'] ?>.close();
                }
            <?php endforeach; ?>
            
            infoWindow<?= $location['id'] ?>.open(map, marker<?= $location['id'] ?>);
        });
        
        // Add to bounds for auto-fitting
        bounds.extend(marker<?= $location['id'] ?>.getPosition());
        hasLocations = true;
    <?php endforeach; ?>
    
    // Auto-fit map to show all locations if any exist
    if (hasLocations) {
        map.fitBounds(bounds);
        
        // Don't zoom in too much if there's only one location
        google.maps.event.addListenerOnce(map, 'bounds_changed', function() {
            if (map.getZoom() > 15) {
                map.setZoom(15);
            }
        });
    }
}

function placeMarker(location) {
    if (marker) {
        marker.setMap(null);
    }
    
    marker = new google.maps.Marker({
        position: location,
        map: map,
        draggable: true,
        title: 'New Location',
        icon: {
            url: 'https://maps.google.com/mapfiles/ms/icons/green-dot.png'
        }
    });
    
    marker.addListener('dragend', function() {
        updateCoordinates(marker.getPosition().lat(), marker.getPosition().lng());
    });
    
    updateCoordinates(location.lat(), location.lng());
    
    // Reverse geocode to get address
    geocoder.geocode({ location: location }, function(results, status) {
        if (status === 'OK' && results[0]) {
            fillAddressFields(results[0]);
        }
    });
}

function updateCoordinates(lat, lng) {
    document.getElementById('latitude').value = lat;
    document.getElementById('longitude').value = lng;
}

function fillAddressFields(result) {
    const components = result.address_components;
    
    document.getElementById('address_line1').value = '';
    document.getElementById('city').value = '';
    document.getElementById('province').value = '';
    document.getElementById('postal_code').value = '';
    
    let streetNumber = '';
    let route = '';
    
    components.forEach(component => {
        const types = component.types;
        
        if (types.includes('street_number')) {
            streetNumber = component.long_name;
        } else if (types.includes('route')) {
            route = component.long_name;
        } else if (types.includes('locality')) {
            document.getElementById('city').value = component.long_name;
        } else if (types.includes('administrative_area_level_1')) {
            document.getElementById('province').value = component.short_name;
        } else if (types.includes('postal_code')) {
            document.getElementById('postal_code').value = component.long_name;
        } else if (types.includes('country')) {
            document.getElementById('country').value = component.long_name;
        }
    });
    
    if (streetNumber && route) {
        document.getElementById('address_line1').value = streetNumber + ' ' + route;
    } else if (route) {
        document.getElementById('address_line1').value = route;
    }
}

// Address search functionality
document.getElementById('find_address').addEventListener('click', function() {
    const address = document.getElementById('address_search').value;
    
    if (!address) {
        alert('Please enter an address to search');
        return;
    }
    
    geocoder.geocode({ address: address }, function(results, status) {
        if (status === 'OK' && results[0]) {
            const location = results[0].geometry.location;
            
            map.setCenter(location);
            map.setZoom(15);
            
            placeMarker(location);
        } else {
            alert('Address not found. Please try a different search term.');
        }
    });
});

function editLocation(location) {
    document.getElementById('formTitle').textContent = 'Edit Location';
    document.getElementById('locationId').value = location.id;
    document.getElementById('formAction').value = 'edit';
    document.getElementById('locationName').value = location.name;
    document.getElementById('address_line1').value = location.address_line1;
    document.getElementById('city').value = location.city;
    document.getElementById('province').value = location.province;
    document.getElementById('postal_code').value = location.postal_code;
    document.getElementById('country').value = location.country;
    document.getElementById('latitude').value = location.latitude;
    document.getElementById('longitude').value = location.longitude;
    document.getElementById('submitLocationText').textContent = 'Update Location';
    
    // Update map
    const pos = { lat: parseFloat(location.latitude), lng: parseFloat(location.longitude) };
    map.setCenter(pos);
    map.setZoom(15);
    
    if (marker) {
        marker.setMap(null);
    }
    
    marker = new google.maps.Marker({
        position: pos,
        map: map,
        draggable: true,
        title: location.name,
        icon: {
            url: 'https://maps.google.com/mapfiles/ms/icons/green-dot.png'
        }
    });
    
    marker.addListener('dragend', function() {
        updateCoordinates(marker.getPosition().lat(), marker.getPosition().lng());
    });

    // Clear all material checkboxes first
    document.querySelectorAll('.material-checkbox').forEach(cb => { cb.checked = false; });
    
    // Fetch and preselect assigned materials
    fetch('<?= BASE_URL ?>?page=locations&action=materials&id=' + encodeURIComponent(location.id))
        .then(r => r.json())
        .then(data => {
            if (data && data.success && Array.isArray(data.material_ids)) {
                const set = new Set(data.material_ids.map(Number));
                document.querySelectorAll('.material-checkbox').forEach(cb => {
                    const mid = Number(cb.getAttribute('data-material-id'));
                    cb.checked = set.has(mid);
                });
            }
        })
        .catch(() => {/* ignore */});
    
    // Scroll to form
    document.getElementById('locationForm').scrollIntoView({ behavior: 'smooth' });
}

function resetLocationForm() {
    document.getElementById('formTitle').textContent = 'Add New Location';
    document.getElementById('locationId').value = '';
    document.getElementById('formAction').value = 'add';
    document.getElementById('locationForm').reset();
    document.getElementById('submitLocationText').textContent = 'Add Location';
    
    // Reset materials checkboxes
    document.querySelectorAll('input[type="checkbox"]').forEach(cb => {
        cb.checked = false;
    });
    
    if (marker) {
        marker.setMap(null);
        marker = null;
    }
    
    // Reset map view to show all locations
    if (locationMarkers.length > 0) {
        const bounds = new google.maps.LatLngBounds();
        locationMarkers.forEach(item => {
            bounds.extend(item.marker.getPosition());
        });
        map.fitBounds(bounds);
    } else {
        map.setCenter({ lat: 56.1304, lng: -106.3468 });
        map.setZoom(4);
    }
}

function zoomToLocation(lat, lng) {
    map.setCenter({ lat: lat, lng: lng });
    map.setZoom(15);
    
    // Highlight the specific marker temporarily
    const targetMarker = locationMarkers.find(item => {
        const pos = item.marker.getPosition();
        return Math.abs(pos.lat() - lat) < 0.0001 && Math.abs(pos.lng() - lng) < 0.0001;
    });
    
    if (targetMarker) {
        // Bounce the marker briefly
        targetMarker.marker.setAnimation(google.maps.Animation.BOUNCE);
        setTimeout(() => {
            targetMarker.marker.setAnimation(null);
        }, 2000);
    }
}

function toggleLocation(locationId, checkbox) {
    fetch('<?= BASE_URL ?>?page=locations&action=toggle&id=' + locationId, {
        method: 'POST'
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const statusText = checkbox.closest('td').querySelector('div.text-xs');
            if (statusText) {
                statusText.textContent = data.active ? 'Active' : 'Inactive';
                statusText.style.color = data.active ? '#16a34a' : '#dc2626';
            }

            // Update switch track color and knob position dynamically
            const track = checkbox.parentElement.querySelector('div.w-9');
            if (track) {
                track.style.backgroundColor = data.active ? '#22c55e' : '#ef4444';
                const knob = track.querySelector('span');
                if (knob) {
                    knob.style.transform = data.active ? 'translateX(16px)' : 'translateX(0)';
                }
            }
            
            // Update marker color on map
            const markerItem = locationMarkers.find(item => item.id == locationId);
            if (markerItem) {
                markerItem.active = data.active;
                markerItem.marker.setIcon({
                    url: data.active ? 'https://maps.google.com/mapfiles/ms/icons/red-dot.png' : 'https://maps.google.com/mapfiles/ms/icons/grey-dot.png'
                });
            }
            
            showNotification(data.message, 'success');
        } else {
            checkbox.checked = !checkbox.checked;
            showNotification(data.message || 'Failed to update location status', 'error');
        }
    })
    .catch(error => {
        checkbox.checked = !checkbox.checked;
        showNotification('An error occurred while updating the location status', 'error');
    });
}

function showNotification(message, type) {
    const notification = document.createElement('div');
    notification.className = `fixed top-4 right-4 p-4 rounded-md z-50 ${type === 'success' ? 'bg-green-100 text-green-700 border border-green-400' : 'bg-red-100 text-red-700 border border-red-400'}`;
    notification.innerHTML = `
        <div class="flex items-center">
            <i class="fas ${type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle'} mr-2"></i>
            ${message}
        </div>
    `;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 3000);
}

// Handle form submission
document.getElementById('locationForm').addEventListener('submit', function(e) {
    const lat = document.getElementById('latitude').value;
    const lng = document.getElementById('longitude').value;
    
    if (!lat || !lng) {
        e.preventDefault();
        alert('Please select a location on the map or search for an address.');
        return false;
    }
    
    const action = document.getElementById('formAction').value;
    const id = document.getElementById('locationId').value;
    
    if (action === 'edit' && id) {
        this.action = '<?= BASE_URL ?>?page=locations&action=edit&id=' + id;
    } else {
        this.action = '<?= BASE_URL ?>?page=locations&action=add';
    }
});
</script>