<div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
    <!-- Form Section -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center mb-6">
            <input type="hidden" id="loc_id" value="<?= htmlspecialchars($location['id'] ?? '') ?>">
            <a href="<?= BASE_URL ?>locations" class="text-gray-500 hover:text-gray-700 mr-4">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-2xl font-bold text-gray-800">
                <i class="fas fa-map-marker-alt mr-2 text-primary"></i>
                <?= $isEdit ? 'Edit Location' : 'Add New Location' ?>
            </h1>
        </div>
        
        <?php if (!empty($errors['general'])): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-6">
                <i class="fas fa-exclamation-circle mr-2"></i>
                <?= htmlspecialchars($errors['general']) ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" class="space-y-6">
            <!-- Location Name -->
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-building mr-1"></i>
                    Location Name *
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       value="<?= htmlspecialchars($location['name'] ?? '') ?>"
                       class="w-full px-4 py-2 border <?= isset($errors['name']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                       placeholder="e.g., Downtown Warehouse"
                       required>
                <?php if (isset($errors['name'])): ?>
                    <p class="text-red-500 text-sm mt-1">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?= htmlspecialchars($errors['name']) ?>
                    </p>
                <?php endif; ?>
            </div>
            
            <!-- Address Search -->
            <div>
                <label for="address_search" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-search mr-1"></i>
                    Search Address
                </label>
                <div class="flex gap-2">
                    <input type="text" 
                           id="address_search" 
                           class="flex-1 px-4 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                           placeholder="Enter address to search and auto-fill">
                    <button type="button" 
                            id="find_address" 
                            class="bg-primary hover:bg-blue-600 text-white px-4 py-2 rounded-md">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
                <p class="text-xs text-gray-500 mt-1">
                    Search for an address to automatically fill the form fields below
                </p>
            </div>
            
            <!-- Address Line 1 -->
            <div>
                <label for="address_line1" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-map-marker-alt mr-1"></i>
                    Address Line 1 *
                </label>
                <input type="text" 
                       id="address_line1" 
                       name="address_line1" 
                       value="<?= htmlspecialchars($location['address_line1'] ?? '') ?>"
                       class="w-full px-4 py-2 border <?= isset($errors['address_line1']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                       placeholder="Street address"
                       required>
                <?php if (isset($errors['address_line1'])): ?>
                    <p class="text-red-500 text-sm mt-1">
                        <i class="fas fa-exclamation-circle mr-1"></i>
                        <?= htmlspecialchars($errors['address_line1']) ?>
                    </p>
                <?php endif; ?>
            </div>
            
            <!-- Address Line 2 -->
            <div>
                <label for="address_line2" class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-map-marker-alt mr-1"></i>
                    Address Line 2
                </label>
                <input type="text" 
                       id="address_line2" 
                       name="address_line2" 
                       value="<?= htmlspecialchars($location['address_line2'] ?? '') ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary"
                       placeholder="Apartment, suite, etc. (optional)">
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- City -->
                <div>
                    <label for="city" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-city mr-1"></i>
                        City *
                    </label>
                    <input type="text" 
                           id="city" 
                           name="city" 
                           value="<?= htmlspecialchars($location['city'] ?? '') ?>"
                           class="w-full px-4 py-2 border <?= isset($errors['city']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                           required>
                    <?php if (isset($errors['city'])): ?>
                        <p class="text-red-500 text-sm mt-1">
                            <i class="fas fa-exclamation-circle mr-1"></i>
                            <?= htmlspecialchars($errors['city']) ?>
                        </p>
                    <?php endif; ?>
                </div>
                
                <!-- Province -->
                <div>
                    <label for="province" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-flag mr-1"></i>
                        Province *
                    </label>
                    <input type="text" 
                           id="province" 
                           name="province" 
                           value="<?= htmlspecialchars($location['province'] ?? '') ?>"
                           class="w-full px-4 py-2 border <?= isset($errors['province']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                           required>
                    <?php if (isset($errors['province'])): ?>
                        <p class="text-red-500 text-sm mt-1">
                            <i class="fas fa-exclamation-circle mr-1"></i>
                            <?= htmlspecialchars($errors['province']) ?>
                        </p>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Postal Code -->
                <div>
                    <label for="postal_code" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-mail-bulk mr-1"></i>
                        Postal Code *
                    </label>
                    <input type="text" 
                           id="postal_code" 
                           name="postal_code" 
                           value="<?= htmlspecialchars($location['postal_code'] ?? '') ?>"
                           class="w-full px-4 py-2 border <?= isset($errors['postal_code']) ? 'border-red-500' : 'border-gray-300' ?> rounded-md focus:ring-primary focus:border-primary"
                           required>
                    <?php if (isset($errors['postal_code'])): ?>
                        <p class="text-red-500 text-sm mt-1">
                            <i class="fas fa-exclamation-circle mr-1"></i>
                            <?= htmlspecialchars($errors['postal_code']) ?>
                        </p>
                    <?php endif; ?>
                </div>
                
                <!-- Country -->
                <div>
                    <label for="country" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-globe mr-1"></i>
                        Country
                    </label>
                    <input type="text" 
                           id="country" 
                           name="country" 
                           value="<?= htmlspecialchars($location['country'] ?? 'Canada') ?>"
                           class="w-full px-4 py-2 border border-gray-300 rounded-md focus:ring-primary focus:border-primary">
                </div>
            </div>
            
            <!-- Hidden Coordinates -->
            <input type="hidden" id="latitude" name="latitude" value="<?= htmlspecialchars($location['latitude'] ?? '') ?>">
            <input type="hidden" id="longitude" name="longitude" value="<?= htmlspecialchars($location['longitude'] ?? '') ?>">
            
            <!-- Materials Selection -->
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">
                    <i class="fas fa-boxes mr-1"></i>
                    Available Materials
                </label>
                <div class="max-h-48 overflow-y-auto border border-gray-300 rounded-md p-3 bg-gray-50">
                    <?php if (empty($materials)): ?>
                        <p class="text-gray-500 text-sm">No materials available</p>
                    <?php else: ?>
                        <?php foreach ($materials as $material): ?>
                            <div class="flex items-center space-x-2 py-2 border-b border-gray-200 last:border-b-0">
                                <input type="checkbox" 
                                       name="materials[<?= $material['id'] ?>][selected]" 
                                       value="1"
                                       <?= isset($material['selected']) && $material['selected'] ? 'checked' : '' ?>
                                       data-material-id="<?= $material['id'] ?>"
                                       class="mat-check rounded border-gray-300 text-primary focus:ring-primary"
                                       onchange="toggleMaterialFields(<?= $material['id'] ?>, this.checked)">
                                <div class="flex-1">
                                    <span class="text-sm font-medium">
                                        <?= htmlspecialchars($material['name']) ?>
                                    </span>
                                    <span class="text-xs text-gray-500">
                                        (<?= htmlspecialchars($material['code']) ?>)
                                    </span>
                                </div>
                                <div id="material_fields_<?= $material['id'] ?>" 
                                     class="flex space-x-2 <?= !isset($material['selected']) || !$material['selected'] ? 'hidden' : '' ?>">
                                    <input type="number" 
                                           name="materials[<?= $material['id'] ?>][quantity]" 
                                           value="<?= htmlspecialchars($material['quantity'] ?? '0') ?>"
                                           placeholder="Qty"
                                           class="w-16 px-2 py-1 text-xs border border-gray-300 rounded">
                                    <input type="text" 
                                           name="materials[<?= $material['id'] ?>][unit]" 
                                           value="<?= htmlspecialchars($material['unit'] ?? 'units') ?>"
                                           placeholder="Unit"
                                           class="w-16 px-2 py-1 text-xs border border-gray-300 rounded">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Form Actions -->
            <div class="flex justify-end space-x-4 pt-6 border-t">
                <a href="<?= BASE_URL ?>locations" 
                   class="px-6 py-2 text-gray-700 bg-gray-200 hover:bg-gray-300 rounded-md font-medium">
                    <i class="fas fa-times mr-2"></i>
                    Cancel
                </a>
                <button type="submit" 
                        class="px-6 py-2 bg-primary hover:bg-blue-600 text-white rounded-md font-medium">
                    <i class="fas fa-save mr-2"></i>
                    <?= $isEdit ? 'Update Location' : 'Add Location' ?>
                </button>
            </div>
        </form>
    </div>
    
    <!-- Map Section -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-map mr-2 text-primary"></i>
            Location Map
        </h3>
        <div id="map" class="w-full h-96 bg-gray-200 rounded-md mb-4"></div>
        <p class="text-sm text-gray-600">
            <i class="fas fa-info-circle mr-1"></i>
            Click on the map to set the location, or use the address search above to find and auto-fill the coordinates.
        </p>
    </div>
</div>

<script>
let map;
let marker;
let geocoder;

function initMap() {
    geocoder = new google.maps.Geocoder();
    
    // Initialize map
    const initialLat = <?= !empty($location['latitude']) ? $location['latitude'] : '56.1304' ?>;
    const initialLng = <?= !empty($location['longitude']) ? $location['longitude'] : '-106.3468' ?>;
    
    map = new google.maps.Map(document.getElementById('map'), {
        zoom: <?= !empty($location['latitude']) ? '15' : '4' ?>,
        center: { lat: initialLat, lng: initialLng }
    });
    
    // Add marker if coordinates exist
    <?php if (!empty($location['latitude']) && !empty($location['longitude'])): ?>
        marker = new google.maps.Marker({
            position: { lat: initialLat, lng: initialLng },
            map: map,
            draggable: true,
            title: 'Location'
        });
        
        marker.addListener('dragend', function() {
            updateCoordinates(marker.getPosition().lat(), marker.getPosition().lng());
        });
    <?php endif; ?>
    
    // Add click listener to map
    map.addListener('click', function(e) {
        placeMarker(e.latLng);
    });
}

function placeMarker(location) {
    if (marker) {
        marker.setMap(null);
    }
    
    marker = new google.maps.Marker({
        position: location,
        map: map,
        draggable: true,
        title: 'Location'
    });
    
    marker.addListener('dragend', function() {
        updateCoordinates(marker.getPosition().lat(), marker.getPosition().lng());
    });
    
    updateCoordinates(location.lat(), location.lng());
    
    // Reverse geocode to get address
    geocoder.geocode({ location: location }, function(results, status) {
        if (status === 'OK' && results[0]) {
            fillAddressFields(results[0]);
        }
    });
}

function updateCoordinates(lat, lng) {
    document.getElementById('latitude').value = lat;
    document.getElementById('longitude').value = lng;
}

function fillAddressFields(result) {
    const components = result.address_components;
    
    // Clear existing values
    document.getElementById('address_line1').value = '';
    document.getElementById('city').value = '';
    document.getElementById('province').value = '';
    document.getElementById('postal_code').value = '';
    
    let streetNumber = '';
    let route = '';
    
    components.forEach(component => {
        const types = component.types;
        
        if (types.includes('street_number')) {
            streetNumber = component.long_name;
        } else if (types.includes('route')) {
            route = component.long_name;
        } else if (types.includes('locality')) {
            document.getElementById('city').value = component.long_name;
        } else if (types.includes('administrative_area_level_1')) {
            document.getElementById('province').value = component.short_name;
        } else if (types.includes('postal_code')) {
            document.getElementById('postal_code').value = component.long_name;
        } else if (types.includes('country')) {
            document.getElementById('country').value = component.long_name;
        }
    });
    
    if (streetNumber && route) {
        document.getElementById('address_line1').value = streetNumber + ' ' + route;
    } else if (route) {
        document.getElementById('address_line1').value = route;
    }
}

// Address search functionality
document.getElementById('find_address').addEventListener('click', function() {
    const address = document.getElementById('address_search').value;
    
    if (!address) {
        alert('Please enter an address to search');
        return;
    }
    
    geocoder.geocode({ address: address }, function(results, status) {
        if (status === 'OK' && results[0]) {
            const location = results[0].geometry.location;
            
            map.setCenter(location);
            map.setZoom(15);
            
            placeMarker(location);
        } else {
            alert('Address not found. Please try a different search term.');
        }
    });
});

// Material fields toggle
function toggleMaterialFields(materialId, checked) {
    const fields = document.getElementById('material_fields_' + materialId);
    if (checked) {
        fields.classList.remove('hidden');
    } else {
        fields.classList.add('hidden');
    }
}

// Pre-select materials for edit mode by fetching assigned materials
window.addEventListener('DOMContentLoaded', function() {
    const locId = document.getElementById('loc_id').value;
    if (locId) {
        fetch('<?= BASE_URL ?>?page=locations&action=materials&id=' + encodeURIComponent(locId))
            .then(r => r.json())
            .then(data => {
                if (data && data.success && Array.isArray(data.material_ids)) {
                    const set = new Set(data.material_ids.map(Number));
                    document.querySelectorAll('.mat-check').forEach(cb => {
                        const mid = Number(cb.getAttribute('data-material-id'));
                        if (set.has(mid)) {
                            cb.checked = true;
                            toggleMaterialFields(mid, true);
                        }
                    });
                }
            })
            .catch(() => { /* ignore */ });
    }
});

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const lat = document.getElementById('latitude').value;
    const lng = document.getElementById('longitude').value;
    
    if (!lat || !lng) {
        e.preventDefault();
        alert('Please select a location on the map or search for an address.');
        return false;
    }
});
</script>