<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= APP_NAME ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#3b82f6',
                        secondary: '#64748b'
                    }
                }
            }
        }
    </script>

    <?php
    // Favicon from settings (branding_favicon). Accepts absolute, site-relative or data URL.
    $__fav = $settings['branding_favicon'] ?? '';
    if ($__fav && !preg_match('~^(https?://|/|data:)~i', $__fav)) {
        $__fav = BASE_URL . ltrim($__fav, '/');
    }
    if ($__fav):
        $extPath = strtolower(parse_url($__fav, PHP_URL_PATH) ?? '');
        $type = (str_ends_with($extPath, '.png') ? 'image/png' : 'image/x-icon');
    ?>
    <link rel="icon" type="<?= $type ?>" href="<?= htmlspecialchars($__fav) ?>">
    <?php endif; ?>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg">
        <div class="max-w-7xl mx-auto px-4">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="<?= BASE_URL ?>" class="text-xl font-bold text-primary">
                        <?php
                        $__logo = $settings['branding_logo'] ?? '';
                        if ($__logo && !preg_match('~^(https?://|/|data:)~i', $__logo)) {
                            $__logo = BASE_URL . ltrim($__logo, '/');
                        }
                        if ($__logo): ?>
                            <img src="<?= htmlspecialchars($__logo) ?>" alt="<?= APP_NAME ?> logo" class="h-8 w-auto object-contain" />
                        <?php else: ?>
                            <i class="fas fa-map-marked-alt mr-2"></i>
                            <?= APP_NAME ?>
                        <?php endif; ?>
                    </a>
                </div>
                
                <div class="flex items-center space-x-4">
                    <?php $isLoggedIn = isset($_SESSION['user_id']); ?>
                    <?php if ($isLoggedIn): ?>
                        <!-- Authenticated Navigation -->
                        <a href="<?= BASE_URL ?>" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-home mr-1"></i> Home
                        </a>
                        <a href="<?= BASE_URL ?>?page=releases" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-star mr-1"></i> What's New
                        </a>
                        <?php 
                        // Check if user has admin privileges (same logic as Controller::isAdmin())
                        $isAdmin = false;
                        if (isset($_SESSION['user_id']) && isset($_SESSION['username'])) {
                            $username = strtolower($_SESSION['username']);
                            
                            // Block the limited "mapd" account explicitly
                            if ($username !== 'mapd') {
                                $authMethod = $_SESSION['auth_method'] ?? 'local';
                                
                                if ($authMethod === 'ldap') {
                                    // LDAP users are admins if they authenticated successfully
                                    $isAdmin = true;
                                } else {
                                    // For local users, only allow the built-in "admin" account
                                    $isAdmin = ($username === 'admin');
                                }
                            }
                        }
                        ?>
                        <?php if ($isAdmin): ?>
                            <a href="<?= BASE_URL ?>?page=materials" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                                <i class="fas fa-cubes mr-1"></i> Materials
                            </a>
                            <a href="<?= BASE_URL ?>?page=locations" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                                <i class="fas fa-map-marker-alt mr-1"></i> Locations
                            </a>
                            <a href="<?= BASE_URL ?>?page=settings" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                                <i class="fas fa-cog mr-1"></i> Settings
                            </a>
                        <?php endif; ?>
                        
                        <div class="flex items-center space-x-2 border-l pl-4">
                            <span class="text-sm text-gray-600">
                                <i class="fas fa-user mr-1"></i>
                                <?= htmlspecialchars($_SESSION['display_name'] ?? ($_SESSION['username'] ?? '')) ?>
                            </span>
                            <a href="<?= BASE_URL ?>?page=logout" class="bg-red-600 hover:bg-red-700 text-white px-3 py-2 rounded-md text-sm font-medium">
                                <i class="fas fa-sign-out-alt mr-1"></i> Logout
                            </a>
                        </div>
                    <?php else: ?>
                        <!-- Public Navigation -->
                        <a href="<?= BASE_URL ?>" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-home mr-1"></i> Home
                        </a>
                        <a href="<?= BASE_URL ?>?page=how-to-use" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-question-circle mr-1"></i> How to Use
                        </a>
                        <a href="<?= BASE_URL ?>?page=releases" class="text-gray-700 hover:text-primary px-3 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-star mr-1"></i> What's New
                        </a>
                        <a href="<?= BASE_URL ?>?page=login" class="bg-primary hover:bg-blue-600 text-white px-4 py-2 rounded-md text-sm font-medium">
                            <i class="fas fa-sign-in-alt mr-1"></i> Login
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <?php if (isset($settings['app_mode']) && $settings['app_mode'] === 'development' && !$isLoggedIn): ?>
        <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 text-center">
            <i class="fas fa-exclamation-triangle mr-1"></i>
            Development Mode � functionality may be limited.
        </div>
    <?php endif; ?>