<div class="max-w-6xl mx-auto">
    <!-- Search Form - Full Width -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">
            <i class="fas fa-search mr-2 text-primary"></i>
            Find Materials & Locations
        </h2>
        <?php
        $page = $_GET['page'] ?? '';
        $action = $_GET['action'] ?? '';

        if ($page === 'home') {
            // Only show search form if action is NOT "search"
            if ($action !== 'search') {
                ?>
                <form action="<?= BASE_URL ?>?page=home&action=search" method="POST" class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Location Input -->
                        <div>
                            <label for="location" class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-map-marker-alt mr-1"></i>
                                Your Address *
                            </label>
                            <div class="relative">
                                <input type="text"
                                       id="location"
                                       name="location"
                                       value="<?= htmlspecialchars($userLocation) ?>"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-md focus:ring-primary focus:border-primary text-lg"
                                       placeholder="Enter your address or postal code"
                                       required>
                                <button type="button"
                                        id="location-picker"
                                        class="absolute right-3 top-3 text-primary hover:text-blue-600"
                                        title="Use current location">
                                    <i class="fas fa-crosshairs text-xl"></i>
                                </button>
                            </div>
                        </div>

                        <!-- Materials Input -->
                        <div>
                            <label for="materials_input" class="block text-sm font-medium text-gray-700 mb-2">
                                <i class="fas fa-boxes mr-1"></i>
                                Materials You Need *
                            </label>
                            <div class="relative">
                                <input type="text"
                                       id="materials_input"
                                       value="<?= htmlspecialchars($materialsInput ?? '') ?>"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-md focus:ring-primary focus:border-primary text-lg"
                                       placeholder="Type material names separated by commas"
                                       required>
                                <div id="materials_dropdown"
                                     class="absolute z-10 w-full bg-white border border-gray-300 rounded-md shadow-lg hidden max-h-48 overflow-y-auto">
                                    <!-- Dropdown will be populated by JavaScript -->
                                </div>
                            </div>

                            <!-- Selected Materials Display -->
                            <div id="selected_materials" class="mt-3">
                                <div class="flex flex-wrap gap-2" id="materials_tags">
                                    <?php foreach ($selectedMaterials as $index => $material): ?>
                                        <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-primary text-white">
                                    <?= htmlspecialchars($material) ?>
                                    <button type="button" onclick="removeMaterial(<?= $index ?>)"
                                            class="ml-2 text-white hover:text-gray-200">
                                        <i class="fas fa-times"></i>
                                    </button>
                                </span>
                                    <?php endforeach; ?>
                                </div>
                            </div>

                            <!-- Hidden input for selected materials -->
                            <input type="hidden" id="selected_materials_input" name="materials"
                                   value="<?= htmlspecialchars($materialsInput ?? '') ?>">
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="text-center">
                        <button type="submit"
                                class="bg-primary hover:bg-blue-600 text-white font-medium py-4 px-8 rounded-md text-lg transition duration-200 shadow-lg">
                            <i class="fas fa-search mr-2"></i>
                            Search Again
                        </button>
                    </div>
                </form>
                <?php
            }
        }
        ?>
    </div>

    <!-- Search Results - Full Width -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <div class="flex items-center justify-between mb-6">
            <h2 class="text-2xl font-bold text-gray-800">
                <i class="fas fa-store mr-2 text-primary"></i>
                Available Locations Near You
            </h2>
            <div class="text-sm text-gray-600">
                <i class="fas fa-map-marker-alt mr-1"></i>
                Your location: <?= htmlspecialchars($userLocation) ?>
            </div>
        </div>

        <?php if (!empty($selectedMaterials)): ?>
            <div class="mb-4 p-3 bg-blue-50 rounded-md">
                <div class="flex items-center text-sm text-blue-800">
                    <i class="fas fa-shopping-cart mr-2"></i>
                    <span class="font-medium">You're looking for:</span>
                    <div class="ml-2 flex flex-wrap gap-1">
                        <?php foreach ($selectedMaterials as $material): ?>
                            <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-blue-200 text-blue-800">
                                <?= htmlspecialchars($material) ?>
                            </span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php if (empty($locations)): ?>
            <div class="text-center py-12">
                <i class="fas fa-store-slash text-6xl text-gray-300 mb-4"></i>
                <h3 class="text-xl font-medium text-gray-900 mb-2">No available locations found</h3>
                <p class="text-gray-500 mb-4">
                    <?= isset($searchMessage) ? htmlspecialchars($searchMessage) : 'No available locations have the materials you need.' ?>
                </p>

                <!-- Debug Information -->
                <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4 mb-4 text-left max-w-2xl mx-auto">
                    <h4 class="font-medium text-yellow-800 mb-2">
                        <i class="fas fa-info-circle mr-1"></i>
                        Search Information
                    </h4>
                    <div class="text-sm text-yellow-700 space-y-1">
                        <p><strong>Your materials
                                request:</strong> <?= htmlspecialchars(implode(', ', $selectedMaterials)) ?></p>
                        <p><strong>Your address:</strong> <?= htmlspecialchars($userLocation) ?></p>
                        <p><strong>Search area:</strong> All active Locations</p>
                    </div>
                    <div class="mt-3 space-x-2">
                        <a href="<?= BASE_URL ?>debug_materials.php" target="_blank"
                           class="text-blue-600 hover:text-blue-800 text-sm">
                            <i class="fas fa-external-link-alt mr-1"></i>
                            View all available materials
                        </a>
                        <a href="<?= BASE_URL ?>add_materials.php" target="_blank"
                           class="text-green-600 hover:text-green-800 text-sm">
                            <i class="fas fa-plus mr-1"></i>
                            Add sample materials
                        </a>
                    </div>
                </div>

                <div class="space-y-2 text-sm text-gray-600 max-w-md mx-auto">
                    <p><strong>Suggestions:</strong></p>
                    <ul class="list-disc list-inside space-y-1 text-left">
                        <li>Try simpler terms like "concrete", "cement", "sand"</li>
                        <li>Check spelling of material names</li>
                        <li>Try searching for one material at a time</li>
                        <li>Contact us to check material availability</li>
                    </ul>
                </div>
            </div>
        <?php else: ?>
            <div class="mb-4 p-3 bg-green-50 rounded-md">
                <div class="text-sm text-green-800">
                    <i class="fas fa-check-circle mr-2"></i>
                    <strong>Found <?= count($locations) ?> available location(s)</strong> with your requested materials,
                    sorted by one-way driving time from your address.
                </div>
            </div>

            <!-- Results Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Rank
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Location
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Distance from You
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Available Materials
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Match
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($locations as $index => $location): ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="flex-shrink-0 h-8 w-8">
                                        <div class="h-8 w-8 rounded-full bg-primary text-white flex items-center justify-center text-sm font-medium">
                                            <?= $index + 1 ?>
                                        </div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">
                                    <i class="fas fa-store mr-1 text-primary"></i>
                                    <?= htmlspecialchars($location['name']) ?>
                                </div>
                                <div class="text-sm text-gray-500">
                                    <?= htmlspecialchars($location['address_line1']) ?>
                                </div>
                                <div class="text-sm text-gray-500">
                                    <?= htmlspecialchars($location['city']) ?>
                                    , <?= htmlspecialchars($location['province']) ?> <?= htmlspecialchars($location['postal_code']) ?>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900">
                                    <i class="fas fa-route mr-1 text-gray-400"></i>
                                    <?= number_format($location['distance'], 1) ?> km
                                </div>
                                <?php if (isset($location['driving_duration'])): ?>
                                    <div class="text-sm text-gray-500">
                                        <i class="fas fa-clock mr-1 text-gray-400"></i>
                                        <?= htmlspecialchars($location['driving_duration']) ?> drive
                                        <?php if (isset($location['traffic_duration_seconds']) && isset($location['duration_seconds'])): ?>
                                            <?php 
                                            $trafficDelay = $location['traffic_duration_seconds'] - $location['duration_seconds'];
                                            $delayMinutes = round($trafficDelay / 60);
                                            ?>
                                            <?php if ($delayMinutes > 2): ?>
                                                <span class="text-xs text-orange-600 ml-1" title="Traffic delay: <?= $delayMinutes ?> min">
                                                    <i class="fas fa-exclamation-triangle"></i>
                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-gray-900">
                                    <?php if (!empty($location['available_materials'])): ?>
                                        <?php foreach ($location['available_materials'] as $material): ?>
                                            <div class="flex items-center justify-between py-1 px-2 mb-1 bg-gray-50 rounded">
                                                <span class="font-medium"><?= htmlspecialchars($material['name']) ?></span>
                                                <!-- <div class="text-xs text-green-600 font-medium">-->
                                                <!--  $--><?php //= number_format($material['price'], 2) ?>
                                                <!--  </div>-->
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <span class="text-gray-500">Materials available</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm">
                                    <div class="flex items-center">
                                        <div class="w-16 bg-gray-200 rounded-full h-2 mr-2">
                                            <div class="bg-green-600 h-2 rounded-full"
                                                 style="width: <?= $location['match_percentage'] ?? 0 ?>%"></div>
                                        </div>
                                        <span class="text-xs font-medium text-gray-600">
                                                <?= $location['match_percentage'] ?? 0 ?>%
                                            </span>
                                    </div>
                                    <div class="text-xs text-gray-500 mt-1">
                                        <?= $location['available_material_count'] ?? 0 ?>
                                        of <?= count($selectedMaterials) ?> materials
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex flex-col space-y-1">
                                    <button onclick="showDetails(<?= $location['id'] ?>)"
                                            class="text-primary hover:text-blue-600 text-left">
                                        <i class="fas fa-info-circle mr-1"></i>
                                        Details
                                    </button>
                                    <button onclick="showOnMap(<?= $location['latitude'] ?>, <?= $location['longitude'] ?>)"
                                            class="text-green-600 hover:text-green-800 text-left">
                                        <i class="fas fa-map mr-1"></i>
                                        Show on Map
                                    </button>
                                    <button onclick="getDirections('<?= htmlspecialchars($location['address_line1']) ?>, <?= htmlspecialchars($location['city']) ?>, <?= htmlspecialchars($location['province']) ?>')"
                                            class="text-purple-600 hover:text-purple-800 text-left">
                                        <i class="fas fa-directions mr-1"></i>
                                        Get Directions
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>

    <!-- Map View - Full Width -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-map mr-2 text-primary"></i>
            Locations Map
        </h3>
        <div id="map" class="w-full h-96 bg-gray-200 rounded-md"></div>
        <div class="mt-4 text-sm text-gray-600">
            <div class="flex items-center space-x-4">
                <div class="flex items-center">
                    <div class="w-4 h-4 bg-blue-500 rounded-full mr-2"></div>
                    <span>Your Location</span>
                </div>
                <div class="flex items-center">
                    <div class="w-4 h-4 bg-red-500 rounded-full mr-2"></div>
                    <span>Available Locations</span>
                </div>
            </div>
            <p class="mt-2 text-xs">
                Available locations are sorted by one-way driving time from your address. Click on markers for more details.
            </p>
        </div>
    </div>
</div>

<!-- Details Modal -->
<div id="detailsModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl max-w-lg w-full">
            <div class="p-6">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-800">Location Details</h3>
                    <button onclick="closeDetails()" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                <div id="detailsContent">
                    <!-- Details will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    let map;
    let userMarker;
    let locationMarkers = [];
    let selectedMaterials = <?= json_encode($selectedMaterials) ?>;

    // Format 'HH:MM' or minutes number into 'X hours Y minutes'
    function formatDurationToWords(val) {
        let h = 0, m = 0;
        if (typeof val === 'number') {
            const total = Math.round(val);
            h = Math.floor(total / 60);
            m = total % 60;
        } else if (typeof val === 'string' && /^\d{1,2}:\d{2}$/.test(val)) {
            const parts = val.split(':');
            h = parseInt(parts[0], 10);
            m = parseInt(parts[1], 10);
        } else {
            return val; // unknown format, return as-is
        }
        const partsOut = [];
        if (h > 0) partsOut.push(h + ' hour' + (h === 1 ? '' : 's'));
        if (m > 0) partsOut.push(m + ' minute' + (m === 1 ? '' : 's'));
        if (partsOut.length === 0) return '0 minutes';
        return partsOut.join(' ');
    }

    function initMap() {
        // Initialize map
        map = new google.maps.Map(document.getElementById('map'), {
            zoom: 10,
            center: {lat: <?= $userCoords['lat'] ?>, lng: <?= $userCoords['lng'] ?>}
        });

        // Add customer location marker (blue)
        userMarker = new google.maps.Marker({
            position: {lat: <?= $userCoords['lat'] ?>, lng: <?= $userCoords['lng'] ?>},
            map: map,
            title: 'Your Location',
            icon: {
                url: 'https://maps.google.com/mapfiles/ms/icons/blue-dot.png'
            }
        });

        const customerInfoWindow = new google.maps.InfoWindow({
            content: `
            <div class="p-2">
                <h4 class="font-bold text-blue-600">Your Location</h4>
                <p class="text-sm"><?= htmlspecialchars($userLocation) ?></p>
                <p class="text-xs text-gray-500">Looking for: <?= htmlspecialchars(implode(', ', $selectedMaterials)) ?></p>
            </div>
        `
        });

        userMarker.addListener('click', function () {
            customerInfoWindow.open(map, userMarker);
        });

        // Add location markers (red)
        <?php foreach ($locations as $location): ?>
        const marker<?= $location['id'] ?> = new google.maps.Marker({
            position: {lat: <?= $location['latitude'] ?>, lng: <?= $location['longitude'] ?>},
            map: map,
            title: '<?= htmlspecialchars($location['name']) ?>',
            icon: {
                url: 'https://maps.google.com/mapfiles/ms/icons/red-dot.png'
            }
        });

        const infoWindow<?= $location['id'] ?> = new google.maps.InfoWindow({
            content: `
                <div class="p-2">
                    <h4 class="font-bold text-red-600"><?= htmlspecialchars($location['name']) ?></h4>
                    <p class="text-sm"><?= htmlspecialchars($location['address_line1']) ?></p>
                    <p class="text-sm"><?= htmlspecialchars($location['city']) ?>, <?= htmlspecialchars($location['province']) ?></p>
                    <p class="text-sm font-medium">Distance: <?= number_format($location['distance'], 1) ?> km</p>
                    <?php if (isset($location['driving_duration'])): ?>
                        <p class="text-sm">Drive time: <?= htmlspecialchars($location['driving_duration']) ?></p>
                    <?php endif; ?>
                    <p class="text-xs text-green-600 mt-1">
                        Has <?= $location['available_material_count'] ?? 0 ?> of your requested materials
                    </p>
                </div>
            `
        });

        marker<?= $location['id'] ?>.addListener('click', function () {
            // Close all other info windows
            customerInfoWindow.close();
            <?php foreach ($locations as $loc): ?>
            infoWindow<?= $loc['id'] ?>.close();
            <?php endforeach; ?>

            infoWindow<?= $location['id'] ?>.open(map, marker<?= $location['id'] ?>);
        });

        locationMarkers.push(marker<?= $location['id'] ?>);
        <?php endforeach; ?>

        // Fit map to show all markers
        if (locationMarkers.length > 0) {
            const bounds = new google.maps.LatLngBounds();
            bounds.extend(userMarker.getPosition());
            locationMarkers.forEach(marker => bounds.extend(marker.getPosition()));
            map.fitBounds(bounds);

            // Don't zoom in too much for single markers
            google.maps.event.addListenerOnce(map, 'bounds_changed', function () {
                if (map.getZoom() > 15) {
                    map.setZoom(15);
                }
            });
        }
    }

    function showOnMap(lat, lng) {
        map.setCenter({lat: lat, lng: lng});
        map.setZoom(15);

        // Scroll to map
        document.getElementById('map').scrollIntoView({behavior: 'smooth'});
    }

    function getDirections(destinationAddress) {
        // Create Google Maps URL for directions from company location to customer address
        const origin = encodeURIComponent(destinationAddress);
        const destination = encodeURIComponent('<?= htmlspecialchars($userLocation) ?>');

        // Google Maps directions URL
        const directionsUrl = `https://www.google.com/maps/dir/${origin}/${destination}`;

        // Open in new tab
        window.open(directionsUrl, '_blank');
    }

    function showDetails(locationId) {
        // Show loading
        document.getElementById('detailsContent').innerHTML = '<div class="text-center py-4"><i class="fas fa-spinner fa-spin"></i> Loading...</div>';
        document.getElementById('detailsModal').classList.remove('hidden');

        // Get location details
        const location = <?= json_encode($locations) ?>.find(loc => loc.id == locationId);

        if (location) {
            // Calculate distance details
            fetch('<?= BASE_URL ?>?page=api&action=distance', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `origin=<?= urlencode($userLocation) ?>&destination=${encodeURIComponent(location.address_line1 + ', ' + location.city + ', ' + location.province)}`
            })
                .then(response => response.json())
                .then(data => {
                    let content = `
                <div class="space-y-4">
                    <div>
                        <strong>Selected Location:</strong><br>
                        <span class="text-gray-600">${location.name}<br>
                        ${location.address_line1}<br>
                        ${location.city}, ${location.province} ${location.postal_code}</span>
                    </div>
                    <div>
                        <strong>Entered Address:</strong><br>
                        <span class="text-gray-600"><?= htmlspecialchars($userLocation) ?></span>
                    </div>
            `;

                    if (data.success) {
                        content += `
                    <div>
                        <strong>Estimated Driving Distance:</strong><br>
                        <span class="text-gray-600">${data.distance}</span>
                    </div>
                    <div>
                        <strong>Estimated One-Way Travel Time:</strong><br>
                        <span class="text-gray-600">${data.duration}</span>
                    </div>
                    <div>
                        <strong>Estimated Total Delivery Time:</strong><br>
                        <span class="text-gray-600">${formatDurationToWords(data.calculated_duration)}</span>
                    </div>
                    <div class="text-xs text-gray-500 mt-2">
                        * Estimated time includes loading/unloading and potential delays
                    </div>
                `;
                    } else {
                        content += `
                    <div class="text-red-600">
                        <i class="fas fa-exclamation-triangle mr-1"></i>
                        Unable to calculate driving details
                    </div>
                `;
                    }

                    // Add available materials (removed "Always Available" tag)
                    if (location.available_materials && location.available_materials.length > 0) {
                        content += `
                    <div>
                        <strong>Available Materials You Requested:</strong><br>
                        <div class="mt-2 space-y-1">
                `;
                        location.available_materials.forEach(material => {
                            content += `
                        <div class="flex justify-between items-center py-2 px-3 bg-gray-50 rounded">
                            <div>
                                <span class="font-medium">${material.name}</span>
                                <div class="text-xs text-gray-500">${material.code}</div>
                            </div>
                            <div class="text-sm font-medium text-green-600 hidden">
                                 $${parseFloat(material.price).toFixed(2)}
                            </div>
                        </div>
                    `;
                        });
                        content += `</div></div>`;
                    }

                    // Add Get Directions button in modal
                    content += `
                <div class="pt-4 border-t">
                    <button onclick="getDirections('${location.address_line1}, ${location.city}, ${location.province}')" 
                            class="w-full bg-purple-600 hover:bg-purple-700 text-white font-medium py-2 px-4 rounded-md">
                        <i class="fas fa-directions mr-2"></i>
                        Get Directions to This Location
                    </button>
                </div>
            `;

                    content += '</div>';
                    document.getElementById('detailsContent').innerHTML = content;
                })
                .catch(error => {
                    document.getElementById('detailsContent').innerHTML = '<div class="text-red-600">Error loading details</div>';
                });
        }
    }

    function closeDetails() {
        document.getElementById('detailsModal').classList.add('hidden');
    }

    // Close modal when clicking outside
    document.getElementById('detailsModal').addEventListener('click', function (e) {
        if (e.target === this) {
            closeDetails();
        }
    });

    // Materials input handling (same as index page)
    const materialsInput = document.getElementById('materials_input');
    const materialsDropdown = document.getElementById('materials_dropdown');

    function removeMaterial(index) {
        selectedMaterials.splice(index, 1);
        updateMaterialsDisplay();
        updateHiddenInput();
        materialsInput.value = selectedMaterials.join(', ');
    }

    function updateMaterialsDisplay() {
        const tagsContainer = document.getElementById('materials_tags');
        tagsContainer.innerHTML = '';

        selectedMaterials.forEach((material, index) => {
            const tag = document.createElement('span');
            tag.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-primary text-white';
            
            // Create text node for material name to avoid XSS issues
            const materialText = document.createTextNode(material);
            tag.appendChild(materialText);
            
            // Create remove button
            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.className = 'ml-2 text-white hover:text-gray-200';
            removeButton.innerHTML = '<i class="fas fa-times"></i>';
            removeButton.addEventListener('click', function() {
                removeMaterial(index);
            });
            
            tag.appendChild(removeButton);
            tagsContainer.appendChild(tag);
        });
    }

    function updateHiddenInput() {
        document.getElementById('selected_materials_input').value = selectedMaterials.join(',');
    }
</script>