<?php
// Read the releases markdown file and convert to HTML
$releasesFile = dirname(dirname(dirname(__DIR__))) . '/RELEASES.md';
$releasesContent = '';

if (file_exists($releasesFile)) {
    $releasesContent = file_get_contents($releasesFile);
}

// Simple markdown to HTML conversion
function markdownToHtml($markdown) {
    // Convert headers
    $html = preg_replace('/^### (.+)$/m', '<h3 class="text-lg font-semibold text-gray-800 mb-3 mt-6">$1</h3>', $markdown);
    $html = preg_replace('/^## (.+)$/m', '<h2 class="text-xl font-bold text-gray-800 mb-4 mt-8 pb-2 border-b border-gray-200">$1</h2>', $html);
    $html = preg_replace('/^# (.+)$/m', '<h1 class="text-3xl font-bold text-gray-800 mb-6">$1</h1>', $html);
    
    // Convert bold text
    $html = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $html);
    
    // Convert italic text
    $html = preg_replace('/\*(.+?)\*/', '<em>$1</em>', $html);
    
    // Convert code blocks
    $html = preg_replace('/`(.+?)`/', '<code class="bg-gray-100 px-2 py-1 rounded text-sm">$1</code>', $html);
    
    // Convert unordered lists
    $html = preg_replace('/^- (.+)$/m', '<li class="mb-1">$1</li>', $html);
    
    // Convert numbered lists
    $html = preg_replace('/^\d+\. (.+)$/m', '<li class="mb-1">$1</li>', $html);
    
    // Wrap consecutive list items in ul tags
    $html = preg_replace('/(<li class="mb-1">.*<\/li>\s*)+/s', '<ul class="list-disc list-inside ml-4 mb-4 space-y-1">$0</ul>', $html);
    
    // Convert paragraphs (lines that don't start with HTML tags)
    $lines = explode("\n", $html);
    $inList = false;
    $result = [];
    
    foreach ($lines as $line) {
        $line = trim($line);
        if (empty($line)) {
            $result[] = '';
            continue;
        }
        
        // Check if line starts with HTML tag or is a list item
        if (preg_match('/^<[h1-6]|^<ul|^<\/ul|^<li|^<strong|^<em|^<code/', $line)) {
            $result[] = $line;
        } else {
            // Regular paragraph
            $result[] = '<p class="mb-4 text-gray-700 leading-relaxed">' . $line . '</p>';
        }
    }
    
    return implode("\n", $result);
}

$htmlContent = markdownToHtml($releasesContent);
?>

<div class="max-w-4xl mx-auto">
    <div class="bg-white rounded-lg shadow-md p-8">
        <?php if (!empty($htmlContent)): ?>
            <div class="prose prose-lg max-w-none">
                <?= $htmlContent ?>
            </div>
        <?php else: ?>
            <div class="text-center py-12">
                <i class="fas fa-file-alt text-6xl text-gray-300 mb-4"></i>
                <h2 class="text-2xl font-bold text-gray-800 mb-4">Release Notes Not Available</h2>
                <p class="text-gray-600 mb-6">
                    The release notes file could not be found or loaded.
                </p>
                <a href="<?= BASE_URL ?>" class="bg-primary hover:bg-blue-600 text-white px-6 py-3 rounded-md font-medium">
                    <i class="fas fa-home mr-2"></i>
                    Back to Home
                </a>
            </div>
        <?php endif; ?>
        
        <div class="mt-8 pt-6 border-t border-gray-200 text-center">
            <a href="<?= BASE_URL ?>" class="bg-primary hover:bg-blue-600 text-white px-6 py-3 rounded-md font-medium mr-4">
                <i class="fas fa-home mr-2"></i>
                Back to Home
            </a>
            <a href="<?= BASE_URL ?>?page=how-to-use" class="bg-gray-600 hover:bg-gray-700 text-white px-6 py-3 rounded-md font-medium">
                <i class="fas fa-question-circle mr-2"></i>
                How to Use
            </a>
        </div>
    </div>
</div>

<style>
/* Custom styles for better markdown rendering */
.prose h1 { color: #1f2937; }
.prose h2 { color: #374151; }
.prose h3 { color: #4b5563; }
.prose ul { margin-left: 1rem; }
.prose li { margin-bottom: 0.25rem; }
.prose p { line-height: 1.6; }
.prose strong { color: #1f2937; font-weight: 600; }
.prose code { background-color: #f3f4f6; padding: 0.125rem 0.25rem; border-radius: 0.25rem; font-size: 0.875rem; }

/* Fix list styling */
.prose ul {
    list-style-type: disc;
    padding-left: 1.5rem;
    margin-bottom: 1rem;
}

.prose ol {
    list-style-type: decimal;
    padding-left: 1.5rem;
    margin-bottom: 1rem;
}

.prose li {
    margin-bottom: 0.5rem;
    line-height: 1.5;
}

/* Emoji and icon spacing */
.prose h2:before,
.prose h3:before {
    margin-right: 0.5rem;
}
</style>