<div class="max-w-6xl mx-auto">
    <?php if (isset($_GET['error'])): ?>
        <div class="bg-red-100 border-l-4 border-red-400 text-red-700 px-4 py-3 mb-6" role="alert">
            <div class="flex">
                <div class="py-1">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                </div>
                <div>
                    <p class="font-medium">Error</p>
                    <p class="text-sm"><?= htmlspecialchars($_GET['error']) ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Search Form - Full Width -->
    <div class="bg-white rounded-lg shadow-md p-6 mb-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center">
            <i class="fas fa-search mr-2 text-primary"></i>
            Find Materials & Locations
        </h2>
        
        <form action="<?= BASE_URL ?>?page=home&action=search" method="POST" class="space-y-6">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Location Input -->
                <div>
                    <label for="location" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-map-marker-alt mr-1"></i>
                        Your Address *
                    </label>
                    <div class="relative">
                        <input type="text" 
                               id="location" 
                               name="location" 
                               class="w-full px-4 py-3 border border-gray-300 rounded-md focus:ring-primary focus:border-primary text-lg"
                               placeholder="Enter your address or postal code"
                               required>
                        <button type="button" 
                                id="location-picker" 
                                class="absolute right-3 top-3 text-primary hover:text-blue-600"
                                title="Use current location">
                            <i class="fas fa-crosshairs text-xl"></i>
                        </button>
                    </div>
                </div>
                
                <!-- Materials Input -->
                <div>
                    <label for="materials_input" class="block text-sm font-medium text-gray-700 mb-2">
                        <i class="fas fa-boxes mr-1"></i>
                        Materials Needed *
                    </label>
                    <div class="relative">
                        <input type="text" 
                               id="materials_input" 
                               class="w-full px-4 py-3 border border-gray-300 rounded-md focus:ring-primary focus:border-primary text-lg"
                               placeholder="Type material names separated by commas"
                               required>
                        <div id="materials_dropdown" class="absolute z-10 w-full bg-white border border-gray-300 rounded-md shadow-lg hidden max-h-48 overflow-y-auto">
                            <!-- Dropdown will be populated by JavaScript -->
                        </div>
                    </div>
                    
                    <!-- Selected Materials Display -->
                    <div id="selected_materials" class="mt-3 hidden">
                        <div class="flex flex-wrap gap-2" id="materials_tags"></div>
                    </div>
                    
                    <!-- Hidden input for selected materials -->
                    <input type="hidden" id="selected_materials_input" name="materials" value="">
                    
                    <p class="text-sm text-gray-500 mt-2">
                        <i class="fas fa-info-circle mr-1"></i>
                        Enter multiple materials separated by commas. We'll find locations that have ALL the materials you need.
                    </p>
                </div>
            </div>
            
            <!-- Submit Button -->
            <div class="text-center">
                <button type="submit" 
                        class="bg-primary hover:bg-blue-600 text-white font-medium py-4 px-8 rounded-md text-lg transition duration-200 shadow-lg">
                    <i class="fas fa-search mr-2"></i>
                    Find Locations
                </button>
            </div>
        </form>
    </div>

    <!-- Map View - Full Width -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <h3 class="text-xl font-bold text-gray-800 mb-4">
            <i class="fas fa-map mr-2 text-primary"></i>
            Map View
        </h3>
        <div id="map" class="w-full h-96 bg-gray-200 rounded-md flex items-center justify-center">
            <div class="text-center text-gray-500">
                <i class="fas fa-map text-4xl mb-2"></i>
                <p>Interactive map will load here</p>
                <p class="text-sm">Search for locations to see them on the map</p>
            </div>
        </div>
    </div>

    <!-- How It Works Section -->
    <div class="bg-white rounded-lg shadow-md p-6 mt-8">
        <h3 class="text-xl font-bold text-gray-800 mb-4 text-center">
            <i class="fas fa-info-circle mr-2 text-primary"></i>
            How It Works
        </h3>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div class="text-center">
                <div class="bg-primary text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-map-marker-alt text-xl"></i>
                </div>
                <h4 class="font-semibold mb-2">1. Enter Your Address</h4>
                <p class="text-sm text-gray-600">Start typing your address and select from suggestions, or use current location</p>
            </div>
            <div class="text-center">
                <div class="bg-primary text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-boxes text-xl"></i>
                </div>
                <h4 class="font-semibold mb-2">2. List Materials Needed</h4>
                <p class="text-sm text-gray-600">Enter all materials you need separated by commas</p>
            </div>
            <div class="text-center">
                <div class="bg-primary text-white rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                    <i class="fas fa-list text-xl"></i>
                </div>
                <h4 class="font-semibold mb-2">3. Find Best Locations</h4>
                <p class="text-sm text-gray-600">See locations that have ALL your materials, sorted by one-way driving time</p>
            </div>
        </div>
    </div>
</div>

<script>
let selectedMaterials = [];
let availableMaterials = <?= json_encode($materials) ?>;
let map;
let userMarker;
let autocomplete;

function initMap() {
    // Initialize map centered on Canada
    map = new google.maps.Map(document.getElementById('map'), {
        zoom: 4,
        center: { lat: 56.1304, lng: -106.3468 }
    });
    
    // Initialize Google Places Autocomplete
    initAutocomplete();
}

function initAutocomplete() {
    const locationInput = document.getElementById('location');
    
    // Create autocomplete object with options
    autocomplete = new google.maps.places.Autocomplete(locationInput, {
        types: ['address'], // Restrict to addresses only
        componentRestrictions: { country: 'ca' }, // Restrict to Canada (change as needed)
        fields: ['formatted_address', 'geometry', 'name', 'place_id']
    });
    
    // Add listener for when a place is selected
    autocomplete.addListener('place_changed', function() {
        const place = autocomplete.getPlace();
        
        if (!place.geometry) {
            // User entered the name of a Place that was not suggested and pressed Enter
            console.log("No details available for input: '" + place.name + "'");
            return;
        }
        
        // Update the map to show the selected location
        const location = place.geometry.location;
        map.setCenter(location);
        map.setZoom(15);
        
        // Remove existing marker
        if (userMarker) {
            userMarker.setMap(null);
        }
        
        // Add new marker
        userMarker = new google.maps.Marker({
            position: location,
            map: map,
            title: 'Your Location: ' + place.formatted_address,
            icon: {
                url: 'https://maps.google.com/mapfiles/ms/icons/blue-dot.png'
            }
        });
        
        // Optional: Show info window
        const infoWindow = new google.maps.InfoWindow({
            content: `
                <div class="p-2">
                    <h4 class="font-bold text-blue-600">Your Selected Location</h4>
                    <p class="text-sm">${place.formatted_address}</p>
                </div>
            `
        });
        
        userMarker.addListener('click', function() {
            infoWindow.open(map, userMarker);
        });
    });
    
    // Style the autocomplete dropdown to match our design
    setTimeout(() => {
        const pacContainer = document.querySelector('.pac-container');
        if (pacContainer) {
            pacContainer.style.zIndex = '9999';
            pacContainer.style.borderRadius = '0.375rem';
            pacContainer.style.border = '1px solid #d1d5db';
            pacContainer.style.boxShadow = '0 10px 15px -3px rgba(0, 0, 0, 0.1)';
        }
    }, 100);
}

// Location picker functionality
document.getElementById('location-picker').addEventListener('click', function() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            const lat = position.coords.latitude;
            const lng = position.coords.longitude;
            
            // Reverse geocode to get address
            if (typeof google !== 'undefined' && google.maps) {
                const geocoder = new google.maps.Geocoder();
                geocoder.geocode({ location: { lat: lat, lng: lng } }, function(results, status) {
                    if (status === 'OK' && results[0]) {
                        document.getElementById('location').value = results[0].formatted_address;
                        
                        // Update map
                        map.setCenter({ lat: lat, lng: lng });
                        map.setZoom(15);
                        
                        if (userMarker) {
                            userMarker.setMap(null);
                        }
                        
                        userMarker = new google.maps.Marker({
                            position: { lat: lat, lng: lng },
                            map: map,
                            title: 'Your Location',
                            icon: {
                                url: 'https://maps.google.com/mapfiles/ms/icons/blue-dot.png'
                            }
                        });
                    }
                });
            } else {
                // Fallback - just show coordinates
                document.getElementById('location').value = `${lat}, ${lng}`;
            }
        }, function() {
            alert('Error: The Geolocation service failed.');
        });
    } else {
        alert('Error: Your browser doesn\'t support geolocation.');
    }
});

// Materials input handling with improved autocomplete
const materialsInput = document.getElementById('materials_input');
const materialsDropdown = document.getElementById('materials_dropdown');

materialsInput.addEventListener('input', function(e) {
    const input = e.target.value;
    const lastCommaIndex = input.lastIndexOf(',');
    const currentMaterial = input.substring(lastCommaIndex + 1).trim();
    
    if (currentMaterial.length > 0) {
        showMaterialSuggestions(currentMaterial);
    } else {
        hideMaterialSuggestions();
    }
    
    // Update selected materials from full input
    updateSelectedMaterialsFromInput(input);
});

materialsInput.addEventListener('keydown', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        const input = e.target.value.trim();
        if (input) {
            processMaterialsInput(input);
        }
    }
});

materialsInput.addEventListener('blur', function(e) {
    // Delay hiding to allow clicking on suggestions
    setTimeout(() => {
        hideMaterialSuggestions();
    }, 200);
});

function showMaterialSuggestions(query) {
    const suggestions = availableMaterials.filter(material => 
        material.name.toLowerCase().includes(query.toLowerCase())
    ).slice(0, 10);
    
    if (suggestions.length > 0) {
        materialsDropdown.innerHTML = suggestions.map((material, index) => 
            `<div class="px-4 py-2 hover:bg-gray-100 cursor-pointer border-b border-gray-100 material-suggestion" 
                  data-material-name="${material.name.replace(/"/g, '&quot;').replace(/'/g, '&#39;')}"
                  data-suggestion-index="${index}">
                <div class="font-medium">${material.name.replace(/"/g, '&quot;').replace(/'/g, '&#39;')}</div>
                <div class="text-sm text-gray-500">${material.code} - ${material.material_group}</div>
             </div>`
        ).join('');
        
        // Add click event listeners to the suggestions
        document.querySelectorAll('.material-suggestion').forEach(suggestion => {
            suggestion.addEventListener('click', function() {
                const materialName = this.getAttribute('data-material-name');
                selectMaterial(materialName);
            });
        });
        
        materialsDropdown.classList.remove('hidden');
    } else {
        hideMaterialSuggestions();
    }
}

function hideMaterialSuggestions() {
    materialsDropdown.classList.add('hidden');
}

function selectMaterial(materialName) {
    const currentInput = materialsInput.value;
    const lastCommaIndex = currentInput.lastIndexOf(',');
    
    let newInput;
    if (lastCommaIndex >= 0) {
        newInput = currentInput.substring(0, lastCommaIndex + 1) + ' ' + materialName;
    } else {
        newInput = materialName;
    }
    
    materialsInput.value = newInput;
    hideMaterialSuggestions();
    updateSelectedMaterialsFromInput(newInput);
    materialsInput.focus();
}

function updateSelectedMaterialsFromInput(input) {
    const materials = input.split(',').map(m => m.trim()).filter(m => m.length > 0);
    selectedMaterials = materials;
    updateMaterialsDisplay();
    updateHiddenInput();
}

function processMaterialsInput(input) {
    const materials = input.split(',').map(m => m.trim()).filter(m => m.length > 0);
    selectedMaterials = materials;
    updateMaterialsDisplay();
    updateHiddenInput();
}

function updateMaterialsDisplay() {
    const container = document.getElementById('selected_materials');
    const tagsContainer = document.getElementById('materials_tags');
    
    if (selectedMaterials.length > 0) {
        container.classList.remove('hidden');
        tagsContainer.innerHTML = '';
        
        selectedMaterials.forEach((material, index) => {
            const tag = document.createElement('span');
            tag.className = 'inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-primary text-white';
            
            // Create text node for material name to avoid XSS issues
            const materialText = document.createTextNode(material);
            tag.appendChild(materialText);
            
            // Create remove button
            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.className = 'ml-2 text-white hover:text-gray-200';
            removeButton.innerHTML = '<i class="fas fa-times"></i>';
            removeButton.addEventListener('click', function() {
                removeMaterial(index);
            });
            
            tag.appendChild(removeButton);
            tagsContainer.appendChild(tag);
        });
    } else {
        container.classList.add('hidden');
    }
}

function removeMaterial(index) {
    selectedMaterials.splice(index, 1);
    updateMaterialsDisplay();
    updateHiddenInput();
    
    // Update the input field
    materialsInput.value = selectedMaterials.join(', ');
}

function updateHiddenInput() {
    document.getElementById('selected_materials_input').value = selectedMaterials.join(',');
}

// Form validation
document.querySelector('form').addEventListener('submit', function(e) {
    const location = document.getElementById('location').value.trim();
    const materials = selectedMaterials.length > 0 ? selectedMaterials : 
                     materialsInput.value.split(',').map(m => m.trim()).filter(m => m.length > 0);
    
    if (!location) {
        e.preventDefault();
        alert('Please enter your address.');
        return false;
    }
    
    if (materials.length === 0) {
        e.preventDefault();
        alert('Please enter at least one material.');
        return false;
    }
    
    // Update hidden input with final materials list
    selectedMaterials = materials;
    updateHiddenInput();
});

// Close dropdown when clicking outside
document.addEventListener('click', function(e) {
    if (!materialsInput.contains(e.target) && !materialsDropdown.contains(e.target)) {
        hideMaterialSuggestions();
    }
});
</script>

<style>
/* Google Places Autocomplete Styling */
.pac-container {
    border-radius: 0.375rem !important;
    border: 1px solid #d1d5db !important;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05) !important;
    font-family: inherit !important;
    z-index: 9999 !important;
}

.pac-item {
    padding: 12px 16px !important;
    border-bottom: 1px solid #f3f4f6 !important;
    cursor: pointer !important;
    font-size: 14px !important;
}

.pac-item:hover {
    background-color: #f9fafb !important;
}

.pac-item-selected {
    background-color: #3b82f6 !important;
    color: white !important;
}

.pac-item-query {
    font-weight: 600 !important;
    color: #1f2937 !important;
}

.pac-item-selected .pac-item-query {
    color: white !important;
}

.pac-matched {
    font-weight: 700 !important;
    color: #3b82f6 !important;
}

.pac-item-selected .pac-matched {
    color: white !important;
}

.pac-icon {
    margin-right: 8px !important;
}

/* Hide the Google logo in autocomplete */
.pac-logo:after {
    display: none !important;
}

/* Style the input when focused with autocomplete */
#location:focus {
    border-color: #3b82f6 !important;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1) !important;
}
</style>