<div class="bg-white rounded-lg shadow-md p-8">
    <h1 class="text-3xl font-bold text-gray-800 mb-6">
        <i class="fas fa-question-circle mr-3 text-primary"></i>
        How to Use MapD System
    </h1>
    
    <div class="prose max-w-none">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
            <div>
                <h2 class="text-xl font-semibold text-gray-800 mb-4">
                    <i class="fas fa-search mr-2 text-primary"></i>
                    Finding Materials & Locations
                </h2>
                <ol class="list-decimal list-inside space-y-2 text-gray-600">
                    <li>Enter your location (address or postal code)</li>
                    <li>Optionally select specific materials you need</li>
                    <li>Click "Find Locations" to search</li>
                    <li>View results sorted by one-way driving time from your location</li>
                </ol>
            </div>
            
            <div>
                <h2 class="text-xl font-semibold text-gray-800 mb-4">
                    <i class="fas fa-map mr-2 text-primary"></i>
                    Using the Map
                </h2>
                <ul class="list-disc list-inside space-y-2 text-gray-600">
                    <li>Blue marker shows your location</li>
                    <li>Red markers show available locations</li>
                    <li>Click markers for location details</li>
                    <li>Use zoom controls to get closer views</li>
                </ul>
            </div>
        </div>
        
        <div class="bg-gray-50 rounded-lg p-6 mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">
                <i class="fas fa-info-circle mr-2 text-primary"></i>
                Understanding Results
            </h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="text-center">
                    <div class="bg-blue-100 text-blue-600 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-info-circle text-xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Details Button</h3>
                    <p class="text-sm text-gray-600">Shows driving distance, duration, and calculated travel time with our custom formula</p>
                </div>
                
                <div class="text-center">
                    <div class="bg-green-100 text-green-600 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-map text-xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Map Button</h3>
                    <p class="text-sm text-gray-600">Centers the map on the selected location for better visualization</p>
                </div>
                
                <div class="text-center">
                    <div class="bg-purple-100 text-purple-600 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-search-plus text-xl"></i>
                    </div>
                    <h3 class="font-semibold mb-2">Zoom Button</h3>
                    <p class="text-sm text-gray-600">Zooms in closely on the location for detailed street view</p>
                </div>
            </div>
        </div>
        
        <div class="bg-blue-50 rounded-lg p-6 mb-8">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">
                <i class="fas fa-calculator mr-2 text-primary"></i>
                Duration Calculation
            </h2>
            <p class="text-gray-600 mb-3">
                Our system provides three types of duration information:
            </p>
            <ul class="list-disc list-inside space-y-2 text-gray-600">
                <li><strong>Driving Distance:</strong> Actual road distance from Google Maps</li>
                <li><strong>Map Duration:</strong> Standard driving time from Google Maps</li>
                <li><strong>Calculated Duration:</strong> Custom calculation using the formula: <code class="bg-gray-200 px-2 py-1 rounded">((map duration × 2) + 25%) + 20 minutes</code></li>
            </ul>
            <p class="text-sm text-gray-500 mt-3">
                The calculated duration accounts for additional factors like loading time, traffic delays, and safety margins.
            </p>
        </div>
        
        <div class="bg-yellow-50 rounded-lg p-6">
            <h2 class="text-xl font-semibold text-gray-800 mb-4">
                <i class="fas fa-lightbulb mr-2 text-primary"></i>
                Tips for Better Results
            </h2>
            <ul class="list-disc list-inside space-y-2 text-gray-600">
                <li>Use specific addresses for more accurate distance calculations</li>
                <li>Try different material combinations to find the best locations</li>
                <li>Use the current location feature for quick searches</li>
                <li>Check multiple locations to compare distances and availability</li>
                <li>Results are cached for 24 hours to improve performance</li>
            </ul>
        </div>
    </div>
    
    <div class="mt-8 text-center">
        <a href="<?= BASE_URL ?>" class="bg-primary hover:bg-blue-600 text-white px-6 py-3 rounded-md font-medium">
            <i class="fas fa-arrow-left mr-2"></i>
            Back to Search
        </a>
    </div>
</div>