<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Page Not Found - <?= APP_NAME ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center">
    <div class="text-center">
        <div class="mb-8">
            <i class="fas fa-map-marked-alt text-6xl text-primary mb-4"></i>
            <h1 class="text-4xl font-bold text-gray-800 mb-2"><?= APP_NAME ?></h1>
        </div>
        
        <div class="bg-white rounded-lg shadow-md p-8 max-w-md">
            <i class="fas fa-exclamation-triangle text-6xl text-yellow-500 mb-4"></i>
            <h2 class="text-2xl font-bold text-gray-800 mb-4">Page Not Found</h2>
            <p class="text-gray-600 mb-6">
                The page you're looking for doesn't exist or has been moved.
            </p>
            <a href="<?= BASE_URL ?>" 
               class="bg-primary hover:bg-blue-600 text-white px-6 py-3 rounded-md font-medium inline-block">
                <i class="fas fa-home mr-2"></i>
                Go Home
            </a>
        </div>
    </div>
</body>
</html>