<?php
// Basic URL helper functions for MapD

if (!function_exists('url')) {
    function url(string $path = ''): string {
        $base = defined('BASE_URL') ? rtrim(BASE_URL, '/') : '';
        $path = ltrim($path, '/');
        return $path === '' ? ($base . '/') : ($base . '/' . $path);
    }
}

if (!function_exists('asset')) {
    function asset(string $path = ''): string {
        $path = ltrim($path, '/');
        return url('assets/' . $path);
    }
}

if (!function_exists('redirect_to')) {
    function redirect_to(string $path = ''): void {
        header('Location: ' . url($path));
        exit;
    }
}

if (!function_exists('current_url')) {
    function current_url(): string {
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $uri  = $_SERVER['REQUEST_URI'] ?? '/';
        return $scheme . '://' . $host . $uri;
    }
}
