<?php
require_once 'config/config.php';
require_once 'config/database.php';

try {
    $db = Database::getInstance();
    
    echo "<h1>Enabling LDAP Authentication</h1>";
    
    // Enable LDAP authentication
    $db->query(
        "INSERT INTO settings (setting_key, setting_value, setting_type, description) 
         VALUES ('ldap_enabled', '1', 'boolean', 'Enable LDAP authentication')
         ON DUPLICATE KEY UPDATE setting_value = '1'"
    );
    
    // Set application to production mode (LDAP typically used in production)
    $db->query(
        "INSERT INTO settings (setting_key, setting_value, setting_type, description) 
         VALUES ('app_mode', 'production', 'string', 'Application mode: development or production')
         ON DUPLICATE KEY UPDATE setting_value = 'production'"
    );
    
    echo "<div style='background: lightgreen; padding: 15px; margin: 15px 0; border-radius: 5px; border: 2px solid green;'>";
    echo "<h2 style='color: green; margin: 0 0 10px 0;'>✓ LDAP Authentication Enabled Successfully!</h2>";
    echo "<p><strong>LDAP Server:</strong> " . LDAP_HOST . "</p>";
    echo "<p><strong>Base DN:</strong> " . LDAP_BASE_DN . "</p>";
    echo "<p><strong>Security Group:</strong> " . LDAP_SECURITY_GROUP . "</p>";
    echo "<p><strong>Application Mode:</strong> Production</p>";
    echo "</div>";
    
    // Test LDAP connection
    echo "<h2>Testing LDAP Connection...</h2>";
    
    if (function_exists('ldap_connect')) {
        echo "<p style='color: green;'>✓ PHP LDAP extension is available</p>";
        
        $ldapConn = @ldap_connect(LDAP_HOST);
        if ($ldapConn) {
            echo "<p style='color: green;'>✓ Successfully connected to LDAP server at " . LDAP_HOST . "</p>";
            
            ldap_set_option($ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);
            ldap_set_option($ldapConn, LDAP_OPT_REFERRALS, 0);
            
            echo "<p style='color: green;'>✓ LDAP connection configured successfully</p>";
            
            ldap_close($ldapConn);
            
            echo "<div style='background: lightblue; padding: 15px; margin: 15px 0; border-radius: 5px; border: 2px solid blue;'>";
            echo "<h3 style='color: blue; margin: 0 0 10px 0;'>LDAP Authentication is now ACTIVE</h3>";
            echo "<p>Users can now log in using their domain credentials.</p>";
            echo "<p>The system will authenticate against the LDAP server and check for membership in the security group.</p>";
            echo "</div>";
            
        } else {
            echo "<p style='color: red;'>✗ Failed to connect to LDAP server at " . LDAP_HOST . "</p>";
            echo "<p style='color: orange;'>⚠ Please verify:</p>";
            echo "<ul>";
            echo "<li>LDAP server is running and accessible</li>";
            echo "<li>Network connectivity to " . LDAP_HOST . "</li>";
            echo "<li>Firewall settings allow LDAP traffic (port 389/636)</li>";
            echo "</ul>";
        }
    } else {
        echo "<p style='color: red;'>✗ PHP LDAP extension is not installed</p>";
        echo "<p style='color: orange;'>⚠ Please install the php-ldap extension to use LDAP authentication</p>";
    }
    
    // Show current settings
    echo "<h2>Current LDAP Settings:</h2>";
    $settings = $db->fetchAll("SELECT * FROM settings WHERE setting_key IN ('ldap_enabled', 'app_mode') ORDER BY setting_key");
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%; margin: 15px 0;'>";
    echo "<tr style='background: #f0f0f0;'><th style='padding: 10px;'>Setting</th><th style='padding: 10px;'>Value</th><th style='padding: 10px;'>Type</th><th style='padding: 10px;'>Description</th></tr>";
    
    foreach ($settings as $setting) {
        $value = $setting['setting_value'];
        $color = '';
        
        if ($setting['setting_key'] == 'ldap_enabled' && $value == '1') {
            $color = 'background: lightgreen;';
            $value = 'Enabled';
        } elseif ($setting['setting_key'] == 'app_mode' && $value == 'production') {
            $color = 'background: lightblue;';
        }
        
        echo "<tr style='$color'>";
        echo "<td style='padding: 10px; font-weight: bold;'>" . htmlspecialchars($setting['setting_key']) . "</td>";
        echo "<td style='padding: 10px;'>" . htmlspecialchars($value) . "</td>";
        echo "<td style='padding: 10px;'>" . htmlspecialchars($setting['setting_type']) . "</td>";
        echo "<td style='padding: 10px;'>" . htmlspecialchars($setting['description']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h2>Next Steps:</h2>";
    echo "<ol>";
    echo "<li><strong>Test Login:</strong> Try logging in with domain credentials</li>";
    echo "<li><strong>Verify Security Group:</strong> Ensure users are members of the required security group</li>";
    echo "<li><strong>Monitor Logs:</strong> Check login attempts and authentication status</li>";
    echo "</ol>";
    
} catch (Exception $e) {
    echo "<div style='background: lightcoral; padding: 15px; margin: 15px 0; border-radius: 5px; border: 2px solid red;'>";
    echo "<h2 style='color: red; margin: 0 0 10px 0;'>✗ Error Enabling LDAP</h2>";
    echo "<p>" . htmlspecialchars($e->getMessage()) . "</p>";
    echo "</div>";
}
?>

<hr>
<p><strong>Quick Links:</strong></p>
<p><a href="<?= BASE_URL ?>" style="background: blue; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;">Go to Homepage</a></p>
<p><a href="<?= BASE_URL ?>?page=login" style="background: green; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;">Test Login</a></p>
<p><a href="<?= BASE_URL ?>?page=settings" style="background: purple; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;">Settings Page</a></p>
<p><a href="check_ldap_status.php" style="background: orange; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;">Check LDAP Status</a></p>