<?php
// Production Configuration Template
// Copy this to config.php and update with your server settings

// Application Configuration
define('APP_NAME', 'MapD System');
define('APP_VERSION', '1.0.0');
define('BASE_URL', 'https://yourdomain.com/mapd/'); // UPDATE THIS

// Database Configuration - UPDATE THESE
define('DB_HOST', 'localhost');
define('DB_NAME', 'mapd_system');
define('DB_USER', 'your_db_user');
define('DB_PASS', 'your_db_password');

// Google Maps API - UPDATE THIS
define('GOOGLE_MAPS_API_KEY', 'your_google_maps_api_key_here');

// LDAP Configuration - UPDATE IF USING LDAP
define('LDAP_HOST', '192.168.2.5');
define('LDAP_BASE_DN', 'DC=FCCL,DC=local');
define('LDAP_SECURITY_GROUP', 'CN=DowntimeReportingAdmin,OU=Security,OU=Groups,OU=Corp,DC=FCCL,DC=local');

// Security
define('SESSION_TIMEOUT', 3600); // 1 hour
define('MAX_LOGIN_ATTEMPTS', 5);

// Pagination
define('ITEMS_PER_PAGE', 20);

// File Upload
define('MAX_FILE_SIZE', 5242880); // 5MB
define('ALLOWED_FILE_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx']);

// Production Settings
error_reporting(E_ERROR | E_WARNING | E_PARSE);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Debug mode - SET TO FALSE IN PRODUCTION
define('APP_DEBUG', false);

// Timezone
date_default_timezone_set('America/Toronto');
?>