<?php
// Application Configuration
const APP_NAME = 'MapD System';
const APP_VERSION = '1.0.0';
// Dynamic BASE_URL: builds from current request (host, port, path) and supports proxies
if (!defined('BASE_URL')) {
    $scheme = 'http';
    if (
        (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off')
        || (isset($_SERVER['SERVER_PORT']) && (int)$_SERVER['SERVER_PORT'] === 443)
        || (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && strtolower($_SERVER['HTTP_X_FORWARDED_PROTO']) === 'https')
    ) {
        $scheme = 'https';
    }

    // Prefer proxy headers, then HTTP_HOST (includes port), then SERVER_NAME
    $host = $_SERVER['HTTP_X_FORWARDED_HOST'] ?? ($_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? 'localhost'));

    // If HTTP_HOST is not set, append non-standard port manually
    if (!isset($_SERVER['HTTP_HOST']) && isset($_SERVER['SERVER_PORT']) && !in_array((int)$_SERVER['SERVER_PORT'], [80, 443], true)) {
        $host .= ':' . (int)$_SERVER['SERVER_PORT'];
    }

    // Determine base path from script location
    $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
    $basePath = rtrim(str_replace('\\\\','/', dirname($scriptName)), '/');

    define('BASE_URL', $scheme . '://' . $host . ($basePath ? $basePath : '') . '/');
}

// Database Configuration
const DB_HOST = 'localhost';
const DB_NAME = 'mapd_system';
const DB_USER = 'pr';
const DB_PASS = 'eu9MB6!fh2@PR';

// Google Maps API
const GOOGLE_MAPS_API_KEY = 'AIzaSyAUgCZSGCrlXou7_Ke0GUQe1oDqhDjuq8E';

// LDAP Configuration
const LDAP_HOST = '192.168.2.5';
const LDAP_BASE_DN = 'DC=FCCL,DC=local';
const LDAP_SECURITY_GROUP = 'CN=DowntimeReportingAdmin,OU=Security,OU=Groups,OU=Corp,DC=FCCL,DC=local';

// Security
const SESSION_TIMEOUT = 3600; // 1 hour
const MAX_LOGIN_ATTEMPTS = 5;

// Pagination
const ITEMS_PER_PAGE = 20;

// File Upload
const MAX_FILE_SIZE = 5242880; // 5MB
const ALLOWED_FILE_TYPES = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'doc', 'docx'];

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Debug mode
const APP_DEBUG = true;

// Timezone
date_default_timezone_set('America/Toronto');
?>