# MapD System

A comprehensive Material and Location Distance Management System built with PHP, MySQL, and Google Maps API.

## Features

### Public Features
- **Location Search**: Find nearby locations based on user's address
- **Material Filtering**: Filter locations by available materials
- **Distance Calculations**: Real-time distance and duration calculations using Google Maps API
- **Interactive Maps**: Visual representation of locations with detailed information
- **Custom Duration Formula**: Calculated duration using `((map duration × 2) + 25%) + 20 minutes`

### Admin Features
- **Materials Management**: Add, edit, and manage materials with codes, names, groups, and prices
- **Locations Management**: Add, edit, and manage locations with full address details and material inventory
- **Settings Configuration**: System-wide settings including API keys, LDAP authentication, and operational modes
- **User Authentication**: Support for both local and LDAP authentication
- **Activity Logging**: Comprehensive logging of user activities and system events

## Technology Stack

- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: HTML5, CSS3, JavaScript, Tailwind CSS
- **Maps**: Google Maps API
- **Authentication**: Local and LDAP support
- **Architecture**: MVC Pattern

## Installation

### Prerequisites
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Web server (Apache/Nginx)
- Google Maps API key

### Setup Steps

1. **Clone/Download the project**
   ```bash
   # Place the project files in your web server directory
   # e.g., /xampp/htdocs/mapd-new-f/
   ```

2. **Database Setup**
   - Create a MySQL database named `mapd_system`
   - Import the database schema (see Database Schema section below)
   - Update database credentials in `config/config.php`

3. **Configuration**
   - Update `config/config.php` with your settings:
     - Database credentials
     - Google Maps API key
     - LDAP settings (if using LDAP authentication)
     - Base URL

4. **Web Server Configuration**
   - Ensure mod_rewrite is enabled (for Apache)
   - Set document root to the project directory
   - Configure appropriate permissions

5. **Google Maps API**
   - Obtain a Google Maps API key
   - Enable the following APIs:
     - Maps JavaScript API
     - Geocoding API
     - Distance Matrix API
   - Update the API key in settings or `config/config.php`

## Database Schema

The system uses the following main tables:

- **users**: User authentication and management
- **materials**: Material catalog with codes, names, groups, and prices
- **locations**: Location details with coordinates and address information
- **location_materials**: Many-to-many relationship between locations and materials
- **settings**: System configuration settings
- **distance_cache**: Cached distance calculations for performance
- **login_attempts**: Security logging for authentication attempts
- **user_activity**: Activity logging for audit trails
- **system_logs**: System-wide logging

### Database Creation Script

```sql
-- Run the complete database schema provided in the requirements
-- This includes all tables, indexes, views, and default data
```

## Default Login

- **Username**: admin
- **Password**: admin

*Note: Change default credentials immediately after installation*

## Configuration Options

### Application Modes
- **Development**: Hides main page for non-admin users
- **Production**: Full public access

### Authentication Methods
- **Local**: Username/password authentication
- **LDAP**: Active Directory integration

### LDAP Configuration
- **Server**: 192.168.2.5
- **Base DN**: DC=FCCL,DC=local
- **Security Group**: CN=DowntimeReportingAdmin,OU=Security,OU=Groups,OU=Corp,DC=FCCL,DC=local

## API Endpoints

### Public APIs
- `GET /api/materials` - Get materials list
- `POST /api/geocode` - Geocode addresses
- `POST /api/distance` - Calculate distances

### Admin APIs (Authentication Required)
- Material CRUD operations
- Location CRUD operations
- Settings management

## File Structure

```
mapd-new-f/
├── assets/
│   ├── css/
│   │   └── app.css
│   └── js/
│       └── app.js
├── config/
│   ├── config.php
│   └── database.php
├── controllers/
│   ├── ApiController.php
│   ├── AuthController.php
│   ├── HomeController.php
│   ├── LocationController.php
│   ├── MaterialController.php
│   └── SettingsController.php
├── core/
│   ├── Controller.php
│   ├── Model.php
│   └── Router.php
├── models/
│   ├── Location.php
│   ├── Material.php
│   ├── Setting.php
│   └── User.php
├── views/
│   ├── auth/
│   ├── errors/
│   ├── home/
│   ├── layout/
│   ├── locations/
│   ├── materials/
│   └── settings/
├── index.php
└── README.md
```

## Usage

### For Public Users
1. Visit the homepage
2. Enter your location
3. Optionally select materials to filter by
4. View results with distances and details
5. Use map features to visualize locations

### For Administrators
1. Login with admin credentials
2. Manage materials and locations
3. Configure system settings
4. Monitor user activity

## Features in Detail

### Distance Calculation
The system provides three types of duration information:
- **Driving Distance**: Actual road distance from Google Maps
- **Map Duration**: Standard driving time from Google Maps
- **Calculated Duration**: Custom calculation using the formula: `((map duration × 2) + 25%) + 20 minutes`

### Caching
- Distance calculations are cached for 24 hours (configurable)
- Improves performance and reduces API calls
- Automatic cache cleanup

### Security Features
- Session management with timeout
- Login attempt tracking
- Activity logging
- LDAP integration support
- Input validation and sanitization

## Troubleshooting

### Common Issues

1. **Maps not loading**
   - Check Google Maps API key
   - Verify API is enabled in Google Console
   - Check browser console for errors

2. **Database connection errors**
   - Verify database credentials
   - Ensure MySQL service is running
   - Check database permissions

3. **LDAP authentication issues**
   - Verify LDAP server connectivity
   - Check LDAP configuration settings
   - Ensure PHP LDAP extension is installed

4. **Permission errors**
   - Check file/folder permissions
   - Ensure web server has read/write access

## Support

For technical support or questions:
- Check the system logs in the database
- Review error logs in your web server
- Verify configuration settings

## License

This project is proprietary software developed for internal use.

## Version History

- **v1.0.0**: Initial release with core functionality
  - Material and location management
  - Distance calculations
  - Google Maps integration
  - User authentication
  - Admin panel