@echo off
REM ============================================================================
REM Create Clean Database with Duplicate Fix
REM ============================================================================
REM This script:
REM   1. Backs up your current database
REM   2. Exports all data with duplicate consolidation
REM   3. Creates a new clean database
REM   4. Imports the cleaned data
REM ============================================================================

setlocal enabledelayedexpansion

REM Configuration
set DB_USER=root
set DB_PASS=
set DB_NAME=handsdb
set NEW_DB_NAME=handsdb_clean
set BACKUP_DIR=Z:\hnsims\v3\database\backups
set TIMESTAMP=%date:~-4%%date:~-10,2%%date:~-7,2%_%time:~0,2%%time:~3,2%%time:~6,2%
set TIMESTAMP=%TIMESTAMP: =0%

echo ============================================================================
echo Create Clean Database with Duplicate Fix
echo ============================================================================
echo.
echo Current database: %DB_NAME%
echo New database: %NEW_DB_NAME%
echo Timestamp: %TIMESTAMP%
echo.

REM Create backup directory if it doesn't exist
if not exist "%BACKUP_DIR%" mkdir "%BACKUP_DIR%"

REM Step 1: Backup current database
echo Step 1: Backing up current database...
mysqldump -u %DB_USER% %DB_NAME% > "%BACKUP_DIR%\%DB_NAME%_backup_%TIMESTAMP%.sql"
if errorlevel 1 (
    echo ERROR: Failed to backup database
    pause
    exit /b 1
)
echo   [OK] Backup saved to: %BACKUP_DIR%\%DB_NAME%_backup_%TIMESTAMP%.sql
echo.

REM Step 2: Export data with duplicate consolidation
echo Step 2: Exporting data with duplicate consolidation...
php Z:\hnsims\v3\export_database_with_fix.php > "%BACKUP_DIR%\complete_export_%TIMESTAMP%.sql" 2>&1
if errorlevel 1 (
    echo ERROR: Failed to export data
    pause
    exit /b 1
)
echo   [OK] Export saved to: %BACKUP_DIR%\complete_export_%TIMESTAMP%.sql
echo.

REM Step 3: Create new database
echo Step 3: Creating new database '%NEW_DB_NAME%'...
mysql -u %DB_USER% -e "DROP DATABASE IF EXISTS %NEW_DB_NAME%; CREATE DATABASE %NEW_DB_NAME% CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
if errorlevel 1 (
    echo ERROR: Failed to create new database
    pause
    exit /b 1
)
echo   [OK] Database '%NEW_DB_NAME%' created
echo.

REM Step 4: Import cleaned data
echo Step 4: Importing cleaned data into '%NEW_DB_NAME%'...
mysql -u %DB_USER% %NEW_DB_NAME% < "%BACKUP_DIR%\complete_export_%TIMESTAMP%.sql"
if errorlevel 1 (
    echo ERROR: Failed to import data
    pause
    exit /b 1
)
echo   [OK] Data imported successfully
echo.

REM Step 5: Verify
echo Step 5: Verifying new database...
mysql -u %DB_USER% %NEW_DB_NAME% -e "SELECT COUNT(*) as inventory_records FROM inventory; SELECT product_id, location_id, COUNT(*) as count FROM inventory GROUP BY product_id, location_id HAVING COUNT(*) > 1;"
echo.

echo ============================================================================
echo SUCCESS! Clean database created
echo ============================================================================
echo.
echo Your databases:
echo   - Original (with duplicates): %DB_NAME%
echo   - Clean (no duplicates):      %NEW_DB_NAME%
echo   - Backup location:            %BACKUP_DIR%
echo.
echo To switch to the clean database:
echo   1. Update v3/config/config.php to use '%NEW_DB_NAME%'
echo   2. Or rename databases:
echo      mysql -u %DB_USER% -e "RENAME DATABASE %DB_NAME% TO %DB_NAME%_old;"
echo      mysql -u %DB_USER% -e "RENAME DATABASE %NEW_DB_NAME% TO %DB_NAME%;"
echo.
echo Press any key to exit...
pause > nul
