<?php
/**
 * Configuration File
 * H&S Inventory Management System
 * 
 * Loads configuration from .env or .env.local dynamically.
 * Falls back to legacy config.local.php if needed.
 */

// Detect current host
$host = $_SERVER['HTTP_HOST'] ?? 'cli';

// Determine if environment is local
$isLocal =
    $host === 'localhost:81' ||
    $host === 'localhost' ||
    $host === '127.0.0.1:81' ||
    $host === '127.0.0.1';

// Choose env file
$envFileName = $isLocal ? '.env.local' : '.env';

// Full path to env file
$envFile = dirname(__DIR__) . '/' . $envFileName;

// Legacy config file
$legacyConfigFile = __DIR__ . '/config.local.php';

// Expose env info globally
if (!defined('APP_ENV')) {
    define('APP_ENV', $isLocal ? 'local' : 'production');
}

if (!defined('ENV_FILE_PATH')) {
    define('ENV_FILE_PATH', $envFile);
}

if (file_exists($envFile)) {
    // Load modern .env handling
    require_once __DIR__ . '/env.php';

} elseif (file_exists($legacyConfigFile)) {
    // Load legacy file
    require_once $legacyConfigFile;

    // Provide missing defaults (legacy support)
    if (!defined('ENVIRONMENT')) define('ENVIRONMENT', 'production');
    if (!defined('APP_NAME')) define('APP_NAME', 'Health and Safety');
    if (!defined('APP_ROOT')) define('APP_ROOT', dirname(__DIR__));
    if (!defined('DB_CHARSET')) define('DB_CHARSET', 'utf8mb4');

    // Session defaults
    if (!defined('SESSION_NAME')) define('SESSION_NAME', 'h_s_inventory_session');
    if (!defined('SESSION_LIFETIME')) define('SESSION_LIFETIME', 604800);
    if (!defined('SESSION_PATH')) define('SESSION_PATH', '/');
    if (!defined('SESSION_DOMAIN')) define('SESSION_DOMAIN', '');
    if (!defined('SESSION_SECURE')) define('SESSION_SECURE', (ENVIRONMENT === 'production'));
    if (!defined('SESSION_HTTPONLY')) define('SESSION_HTTPONLY', true);

    // Timezone
    if (!defined('APP_TIMEZONE')) date_default_timezone_set('America/New_York');

    // Error handling
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', APP_ROOT . '/logs/error.log');

    // Uploads
    if (!defined('MAX_FILE_SIZE')) define('MAX_FILE_SIZE', 5242880);
    if (!defined('ALLOWED_FILE_TYPES')) define('ALLOWED_FILE_TYPES', ['jpg', 'jpeg', 'png', 'gif', 'pdf']);
    if (!defined('UPLOAD_PATH')) define('UPLOAD_PATH', APP_ROOT . '/public/uploads/');

    // Features
    if (!defined('ENABLE_PASSWORD_RESET')) define('ENABLE_PASSWORD_RESET', true);
    if (!defined('ENABLE_AUDIT_LOG')) define('ENABLE_AUDIT_LOG', true);

    // Installation
    if (!defined('INSTALLATION_COMPLETED')) define('INSTALLATION_COMPLETED', true);

    // Dynamic URL
    if (!defined('APP_URL')) require_once __DIR__ . '/dynamic_url.php';

} else {
    die('Configuration Error: No .env or config.local.php found. Create .env or .env.local.');
}
