<style>
    .dashboard-container {
        max-width: 1400px;
        margin: 0 auto;
    }

    .hs-header {
        background: linear-gradient(135deg, #f25ca2, #9b5cff);
        border-radius: 1.5rem;
        box-shadow: 0 8px 24px rgba(0,0,0,0.15);
    }

    .hs-card {
        border-radius: 1rem;
        box-shadow: 0 4px 12px rgba(15, 23, 42, 0.08);
        transition: transform 0.2s, box-shadow 0.2s;
    }

    .hs-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 24px rgba(15, 23, 42, 0.12);
    }

    .kpi-value {
        font-size: 2rem;
        font-weight: 700;
        line-height: 1.2;
    }

    .flow-step-circle {
        width: 48px;
        height: 48px;
        background: white;
        box-shadow: 0 4px 12px rgba(79, 70, 229, 0.2);
    }

    .timeline-dot {
        width: 10px;
        height: 10px;
        border-radius: 50%;
        flex-shrink: 0;
    }

    @media (max-width: 768px) {
        .flow-arrow {
            display: none;
        }
    }
</style>

<div class="dashboard-container space-y-6">

    <!-- HEADER with Welcome User, Date and Time -->
    <header class="hs-header p-6 text-white">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div>
                <h1 class="text-2xl md:text-3xl font-bold mb-2">
                    Welcome, <?php 
                    // Extract first name from full_name or use username
                    $displayName = $_SESSION['username'] ?? 'User';
                    if (isset($_SESSION['full_name']) && !empty($_SESSION['full_name'])) {
                        $nameParts = explode(' ', trim($_SESSION['full_name']));
                        $displayName = $nameParts[0];
                    }
                    echo htmlspecialchars($displayName);
                    ?>!
                </h1>
                <p class="text-white/90 text-sm md:text-base">
                    <?php echo date('l, F j, Y'); ?> • Health &amp; Safety Inventory Overview
                </p>
            </div>
            <div class="flex flex-col items-start md:items-end gap-2 mt-4 md:mt-0">
                <div class="inline-flex items-center gap-2 rounded-full bg-white/15 px-3 py-1.5 text-sm">
                    <span class="w-2 h-2 bg-green-400 rounded-full"></span>
                    System Status: <strong>Online</strong>
                </div>
                <div class="inline-flex items-center gap-2 rounded-full bg-white/15 px-3 py-1.5 text-sm">
                    <i class="fas fa-clock"></i>
                    <span id="liveClock">--:--:-- --</span>
                </div>
            </div>
        </div>
    </header>

    <!-- KPI CARDS -->
    <section class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
        <!-- Total Products -->
        <div class="hs-card bg-white p-5">
            <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Total Products</div>
            <div class="kpi-value text-gray-900"><?php echo $total_products ?? 0; ?></div>
            <div class="text-xs text-gray-500 mt-1">Active items in catalog</div>
        </div>

        <!-- Low Stock Items -->
        <div class="hs-card bg-white p-5">
            <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Low Stock Items</div>
            <div class="kpi-value text-red-600"><?php echo count($low_stock_items ?? []); ?></div>
            <span class="inline-block mt-2 px-2 py-0.5 text-xs rounded-full bg-red-50 text-red-700">Needs restock</span>
        </div>

        <!-- Active Locations -->
        <div class="hs-card bg-white p-5">
            <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Active Locations</div>
            <div class="kpi-value text-gray-900"><?php echo count($stock_by_location ?? []); ?></div>
            <div class="text-xs text-gray-500 mt-1">Sites with on-hand stock</div>
        </div>

        <!-- Total Quantity -->
        <div class="hs-card bg-white p-5">
            <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-2">Total Quantity</div>
            <div class="kpi-value text-gray-900"><?php 
                $totalQty = 0;
                if (isset($stock_by_location)) {
                    foreach ($stock_by_location as $loc) {
                        $totalQty += $loc['total_quantity'] ?? 0;
                    }
                }
                echo number_format($totalQty);
            ?></div>
            <div class="text-xs text-gray-500 mt-1">Units on hand</div>
        </div>

        <!-- Incoming Today -->
        <div class="hs-card bg-white p-5">
            <div class="flex justify-between items-start mb-2">
                <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Incoming Today</div>
                <span class="px-2 py-0.5 text-xs rounded-full bg-blue-50 text-blue-700">Stock In</span>
            </div>
            <div class="kpi-value text-blue-600"><?php 
                $incomingToday = 0;
                if (isset($recent_transactions)) {
                    foreach ($recent_transactions as $trans) {
                        if (isset($trans['type']) && strtolower($trans['type']) === 'in') {
                            $incomingToday += $trans['quantity'] ?? 0;
                        }
                    }
                }
                echo $incomingToday;
            ?></div>
            <div class="text-xs text-gray-500 mt-1">Units received or transferred in</div>
        </div>

        <!-- Outgoing Today -->
        <div class="hs-card bg-white p-5">
            <div class="flex justify-between items-start mb-2">
                <div class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Outgoing Today</div>
                <span class="px-2 py-0.5 text-xs rounded-full bg-amber-50 text-amber-700">Stock Out</span>
            </div>
            <div class="kpi-value text-amber-600"><?php 
                $outgoingToday = 0;
                if (isset($recent_transactions)) {
                    foreach ($recent_transactions as $trans) {
                        if (isset($trans['type']) && strtolower($trans['type']) === 'out') {
                            $outgoingToday += $trans['quantity'] ?? 0;
                        }
                    }
                }
                echo $outgoingToday;
            ?></div>
            <div class="text-xs text-gray-500 mt-1">Units issued to employees / jobs</div>
        </div>
    </section>

    <!-- INVENTORY FLOW -->
    <section class="space-y-4">
        <div class="hs-card bg-white p-6">
            <h6 class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-4">Inventory Flow</h6>
            <div class="flex flex-wrap justify-between items-center gap-4">
                <div class="flex-1 text-center min-w-[120px]">
                    <div class="flow-step-circle mx-auto mb-2 flex items-center justify-center rounded-full text-indigo-600 font-bold text-lg">1</div>
                    <div class="text-sm font-medium text-gray-900">Master Data</div>
                    <div class="text-xs text-gray-500 mt-1">Categories · Types · Locations · Employees</div>
                </div>
                <div class="text-2xl text-gray-300 flow-arrow">➜</div>

                <div class="flex-1 text-center min-w-[120px]">
                    <div class="flow-step-circle mx-auto mb-2 flex items-center justify-center rounded-full text-indigo-600 font-bold text-lg">2</div>
                    <div class="text-sm font-medium text-gray-900">Products Catalog</div>
                    <div class="text-xs text-gray-500 mt-1">Bulk add PPE items</div>
                </div>
                <div class="text-2xl text-gray-300 flow-arrow">➜</div>

                <div class="flex-1 text-center min-w-[120px]">
                    <div class="flow-step-circle mx-auto mb-2 flex items-center justify-center rounded-full text-indigo-600 font-bold text-lg">3</div>
                    <div class="text-sm font-medium text-gray-900">Stock In</div>
                    <div class="text-xs text-gray-500 mt-1">Receipts · Transfers In</div>
                </div>
                <div class="text-2xl text-gray-300 flow-arrow">➜</div>

                <div class="flex-1 text-center min-w-[120px]">
                    <div class="flow-step-circle mx-auto mb-2 flex items-center justify-center rounded-full text-indigo-600 font-bold text-lg">4</div>
                    <div class="text-sm font-medium text-gray-900">Stock Out</div>
                    <div class="text-xs text-gray-500 mt-1">Issues to employees / jobs</div>
                </div>
                <div class="text-2xl text-gray-300 flow-arrow">➜</div>

                <div class="flex-1 text-center min-w-[120px]">
                    <div class="flow-step-circle mx-auto mb-2 flex items-center justify-center rounded-full text-indigo-600 font-bold text-lg">5</div>
                    <div class="text-sm font-medium text-gray-900">Reporting</div>
                    <div class="text-xs text-gray-500 mt-1">PDF · CSV exports</div>
                </div>
            </div>
        </div>
    </section>

    <!-- CHARTS & RECENT ACTIVITY -->
    <section class="grid grid-cols-1 lg:grid-cols-12 gap-4">
        <!-- Stock by Location Chart -->
        <div class="lg:col-span-7 hs-card bg-white p-6">
            <div class="flex justify-between items-start mb-4">
                <div>
                    <h6 class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Stock by Location</h6>
                    <div class="text-xs text-gray-400 mt-1">Units currently stored at each warehouse</div>
                </div>
                <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-600">Live Data</span>
            </div>
            <div style="height: 280px;">
                <canvas id="chartStockLocation"></canvas>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="lg:col-span-5 hs-card bg-white p-6">
            <div class="flex justify-between items-start mb-4">
                <div>
                    <h6 class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Recent Activity</h6>
                    <div class="text-xs text-gray-400 mt-1">Incoming / outgoing / master data updates</div>
                </div>
                <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-600">Live Feed</span>
            </div>
            <div class="space-y-3 max-h-[280px] overflow-y-auto">
                <?php if (isset($recent_logs) && count($recent_logs) > 0): ?>
                    <?php foreach (array_slice($recent_logs, 0, 8) as $log): ?>
                        <?php
                        $actionColor = '#6366f1';
                        if (strpos(strtolower($log['action']), 'add') !== false || strpos(strtolower($log['action']), 'in') !== false) {
                            $actionColor = '#0ea5e9';
                        } elseif (strpos(strtolower($log['action']), 'remove') !== false || strpos(strtolower($log['action']), 'out') !== false) {
                            $actionColor = '#f97316';
                        } elseif (strpos(strtolower($log['action']), 'update') !== false) {
                            $actionColor = '#16a34a';
                        }
                        ?>
                        <div class="flex items-start gap-3 p-2 rounded-lg hover:bg-gray-50 transition-colors">
                            <div class="timeline-dot mt-1" style="background-color: <?php echo $actionColor; ?>"></div>
                            <div class="flex-1 min-w-0">
                                <div class="text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($log['action']); ?></div>
                                <div class="text-xs text-gray-500"><?php echo htmlspecialchars($log['details'] ?? ''); ?></div>
                                <div class="flex items-center gap-2 mt-1">
                                    <div class="text-xs text-gray-400"><?php echo date('g:i A', strtotime($log['created_at'])); ?></div>
                                    <span class="text-gray-300">•</span>
                                    <div class="text-xs text-gray-500"><?php echo htmlspecialchars($log['username'] ?? 'System'); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-sm text-gray-500 text-center py-8">No recent activity</div>
                <?php endif; ?>
            </div>
        </div>
    </section>

</div>

<script src='https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js'></script>
<script>
    // Live Clock Function
    function updateClock() {
        const clockElement = document.getElementById('liveClock');
        if (!clockElement) return;
        
        const now = new Date();
        const hours = String(now.getHours()).padStart(2, '0');
        const minutes = String(now.getMinutes()).padStart(2, '0');
        const seconds = String(now.getSeconds()).padStart(2, '0');
        const ampm = now.getHours() >= 12 ? 'PM' : 'AM';
        
        clockElement.textContent = `${hours}:${minutes}:${seconds} ${ampm}`;
    }
    
    // Update clock immediately and then every second
    updateClock();
    setInterval(updateClock, 1000);

    // Dashboard data from PHP
    const dashboardData = {
        stockByLocation: {
            labels: <?php echo json_encode(array_column($stock_by_location ?? [], 'location')); ?>,
            values: <?php echo json_encode(array_column($stock_by_location ?? [], 'total_quantity')); ?>
        }
    };

    function buildCharts() {
        const stockLocCtx = document.getElementById('chartStockLocation');

        if (stockLocCtx && dashboardData.stockByLocation.labels.length > 0) {
            new Chart(stockLocCtx, {
                type: 'bar',
                data: {
                    labels: dashboardData.stockByLocation.labels,
                    datasets: [{
                        label: 'Units',
                        data: dashboardData.stockByLocation.values,
                        backgroundColor: 'rgba(99, 102, 241, 0.8)',
                        borderRadius: 8
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: { legend: { display: false } },
                    scales: { y: { beginAtZero: true } }
                }
            });
        }
    }

    document.addEventListener('DOMContentLoaded', () => {
        buildCharts();
    });
</script>