<div class="space-y-6">
    <!-- Page Header -->
    <div class="bg-gradient-to-r from-purple-500 to-pink-600 rounded-xl shadow-2xl p-6 text-white">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="bg-white/20 backdrop-blur-lg p-3 rounded-lg">
                    <i class="fas fa-folder text-white text-2xl"></i>
                </div>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold">Master Data Configuration</h1>
                    <p class="text-white/80 text-sm mt-1">Manage categories, locations, departments, and employees</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Configuration Cards Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Categories Card -->
        <a href="<?php echo APP_URL; ?>/master-data/categories" class="group">
            <div class="bg-gradient-to-br from-blue-50 to-indigo-50 rounded-xl p-6 border-2 border-blue-200 hover:border-blue-400 transition-all duration-300 hover:shadow-xl transform hover:-translate-y-1">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-gradient-to-r from-blue-500 to-indigo-600 p-3 rounded-lg shadow-lg group-hover:scale-110 transition-transform">
                        <i class="fas fa-folder text-white text-2xl"></i>
                    </div>
                    <span class="text-3xl font-bold text-blue-600"><?php echo $category_count; ?></span>
                </div>
                <h3 class="text-lg font-bold text-gray-800 mb-1">Categories</h3>
                <p class="text-sm text-gray-600">Manage product categories</p>
                <div class="mt-4 flex items-center text-blue-600 font-medium text-sm">
                    <span>Manage</span>
                    <i class="fas fa-arrow-right ml-2 group-hover:translate-x-2 transition-transform"></i>
                </div>
            </div>
        </a>

        <!-- Locations Card -->
        <a href="<?php echo APP_URL; ?>/master-data/locations" class="group">
            <div class="bg-gradient-to-br from-orange-50 to-red-50 rounded-xl p-6 border-2 border-orange-200 hover:border-orange-400 transition-all duration-300 hover:shadow-xl transform hover:-translate-y-1">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-gradient-to-r from-orange-500 to-red-600 p-3 rounded-lg shadow-lg group-hover:scale-110 transition-transform">
                        <i class="fas fa-warehouse text-white text-2xl"></i>
                    </div>
                    <span class="text-3xl font-bold text-orange-600"><?php echo $location_count; ?></span>
                </div>
                <h3 class="text-lg font-bold text-gray-800 mb-1">Locations</h3>
                <p class="text-sm text-gray-600">Manage warehouse locations</p>
                <div class="mt-4 flex items-center text-orange-600 font-medium text-sm">
                    <span>Manage</span>
                    <i class="fas fa-arrow-right ml-2 group-hover:translate-x-2 transition-transform"></i>
                </div>
            </div>
        </a>

        <!-- Departments Card -->
        <a href="<?php echo APP_URL; ?>/master-data/departments" class="group">
            <div class="bg-gradient-to-br from-purple-50 to-pink-50 rounded-xl p-6 border-2 border-purple-200 hover:border-purple-400 transition-all duration-300 hover:shadow-xl transform hover:-translate-y-1">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-gradient-to-r from-purple-500 to-pink-600 p-3 rounded-lg shadow-lg group-hover:scale-110 transition-transform">
                        <i class="fas fa-building text-white text-2xl"></i>
                    </div>
                    <span class="text-3xl font-bold text-purple-600"><?php echo $department_count; ?></span>
                </div>
                <h3 class="text-lg font-bold text-gray-800 mb-1">Departments</h3>
                <p class="text-sm text-gray-600">Manage departments</p>
                <div class="mt-4 flex items-center text-purple-600 font-medium text-sm">
                    <span>Manage</span>
                    <i class="fas fa-arrow-right ml-2 group-hover:translate-x-2 transition-transform"></i>
                </div>
            </div>
        </a>

        <!-- Employees Card -->
        <a href="<?php echo APP_URL; ?>/master-data/employees" class="group">
            <div class="bg-gradient-to-br from-cyan-50 to-blue-50 rounded-xl p-6 border-2 border-cyan-200 hover:border-cyan-400 transition-all duration-300 hover:shadow-xl transform hover:-translate-y-1">
                <div class="flex items-center justify-between mb-4">
                    <div class="bg-gradient-to-r from-cyan-500 to-blue-600 p-3 rounded-lg shadow-lg group-hover:scale-110 transition-transform">
                        <i class="fas fa-users text-white text-2xl"></i>
                    </div>
                    <span class="text-3xl font-bold text-cyan-600"><?php echo $employee_count ?? 0; ?></span>
                </div>
                <h3 class="text-lg font-bold text-gray-800 mb-1">Employees</h3>
                <p class="text-sm text-gray-600">Manage employees for stock assignment</p>
                <div class="mt-4 flex items-center text-cyan-600 font-medium text-sm">
                    <span>Manage</span>
                    <i class="fas fa-arrow-right ml-2 group-hover:translate-x-2 transition-transform"></i>
                </div>
            </div>
        </a>
    </div>
</div>
