<?php
$is_edit = isset($editing_employee) && $editing_employee;
$form_action = $is_edit ? 'edit' : 'add';
$form_title = $is_edit ? 'Edit Employee' : 'Add New Employee';
$button_text = $is_edit ? 'Update Employee' : 'Add Employee';
$button_icon = $is_edit ? 'fa-save' : 'fa-plus';
?>

<style>
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(100%);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }
    
    @keyframes slideOutRight {
        from {
            opacity: 1;
            transform: translateX(0);
        }
        to {
            opacity: 0;
            transform: translateX(100%);
        }
    }
    
    .slide-in-up {
        animation: slideInUp 0.5s ease-out;
    }
    
    .slide-in-right {
        animation: slideInRight 0.3s ease-out;
    }
    
    .slide-out-right {
        animation: slideOutRight 0.3s ease-in;
    }
    
    .employee-row {
        transition: all 0.3s ease;
    }
    
    .employee-row:hover {
        transform: translateX(8px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }
    
    #toast-container {
        position: fixed;
        top: 20px;
        right: 20px;
        z-index: 9999;
        display: flex;
        flex-direction: column;
        gap: 10px;
    }
    
    .toast {
        min-width: 300px;
        max-width: 500px;
        padding: 16px 20px;
        border-radius: 12px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        display: flex;
        align-items: center;
        gap: 12px;
        background: white;
        border-left: 4px solid;
        position: relative;
    }
    
    .toast-success {
        border-left-color: #10b981;
        background: linear-gradient(to right, #d1fae5 0%, white 10%);
    }
    
    .toast-success i {
        color: #10b981;
    }
    
    .toast-error {
        border-left-color: #ef4444;
        background: linear-gradient(to right, #fee2e2 0%, white 10%);
    }
    
    .toast-error i {
        color: #ef4444;
    }
    
    .toast span {
        color: #374151;
        font-size: 14px;
        line-height: 1.5;
    }
    
    .toast button {
        color: #9ca3af;
    }
    
    .toast button:hover {
        color: #374151;
    }
</style>

<!-- Toast Container -->
<div id="toast-container"></div>

<div class="max-w-6xl mx-auto space-y-6">
    <!-- Page Header -->
    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 rounded-xl shadow-2xl p-6 text-white slide-in-up">
        <div class="flex justify-between items-center">
            <div class="flex items-center">
                <div class="bg-white/20 backdrop-blur-lg p-3 rounded-lg mr-4">
                    <i class="fas fa-users text-2xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold">Employee Management</h1>
                    <p class="text-white/80 text-sm mt-1">Manage employee records and information</p>
                </div>
            </div>
            <div class="flex items-center space-x-4">
                <button id="bulkAddBtn" class="bg-white/20 backdrop-blur-lg hover:bg-white/30 text-white font-bold py-3 px-6 rounded-lg transition-all duration-300 transform hover:scale-105 border border-white/30 flex items-center">
                    <i class="fas fa-upload mr-2"></i> Bulk Upload
                </button>
            </div>
        </div>
    </div>

    <div id="alert-area"></div>

    <!-- Bulk Upload Modal -->
    <div id="bulkAddModal" class="fixed z-10 inset-0 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <form id="bulk-upload-form" action="<?php echo APP_URL; ?>/master-data/employees" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="action" value="bulk_upload">
                    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 px-6 py-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-white bg-opacity-20">
                                <i class="fas fa-file-excel text-white text-xl"></i>
                            </div>
                            <h3 class="ml-4 text-lg font-bold text-white" id="modal-title">
                                Bulk Employee Upload
                            </h3>
                        </div>
                    </div>
                    <div class="bg-white px-6 py-6">
                        <p class="text-sm text-gray-600 mb-4">
                            Upload an Excel file to bulk add or update employees. Download the template to get started.
                        </p>
                        <div class="bg-gray-100 p-3 rounded-lg mb-4">
                            <h4 class="font-semibold text-gray-700 mb-2 text-sm">Template Columns:</h4>
                            <ul class="text-xs text-gray-600 space-y-1">
                                <li><strong>Employee Number:</strong> Unique identifier (required)</li>
                                <li><strong>Name:</strong> Full name of employee (required)</li>
                                <li><strong>Department:</strong> Department name from master data (optional)</li>
                                <li><strong>Is Active:</strong> Yes or No (required, default: Yes)</li>
                            </ul>
                        </div>
                        <a href="<?php echo APP_URL; ?>/templates/employees" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 mb-4">
                            <i class="fas fa-download mr-2"></i> Download Excel Template
                        </a>
                        <div class="mt-4">
                            <label for="bulk_file" class="block text-sm font-semibold text-gray-700 mb-2">Upload Excel File</label>
                            <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md">
                                <div class="space-y-1 text-center">
                                    <i class="fas fa-upload mx-auto h-12 w-12 text-gray-400"></i>
                                    <div class="flex text-sm text-gray-600">
                                        <label for="bulk_file_input" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                            <span>Upload a file</span>
                                            <input id="bulk_file_input" name="bulk_file" type="file" class="sr-only" accept=".xlsx">
                                        </label>
                                        <p class="pl-1">or drag and drop</p>
                                    </div>
                                    <p class="text-xs text-gray-500">Excel (.xlsx) up to 10MB</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-6 py-4 flex justify-end space-x-3">
                        <button type="button" id="closeModalBtn" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </button>
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            <i class="fas fa-upload mr-2"></i> Upload
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Bulk Upload Modal -->

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Add/Edit Form -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <h2 class="text-lg font-bold text-gray-800 mb-4" id="form-title"><i class="fas <?php echo $button_icon; ?> text-teal-500 mr-2"></i><?php echo $form_title; ?></h2>
            <form id="employee-form" method="POST" class="space-y-4" data-master-data-type="employee">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="action" id="form-action" value="<?php echo $form_action; ?>">
                <?php if ($is_edit) : ?>
                <input type="hidden" name="id" id="item-id" value="<?php echo $editing_employee['id']; ?>">
                <?php else : ?>
                <input type="hidden" name="id" id="item-id" value="">
                <?php endif; ?>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Employee Number *</label>
                    <input type="text" name="employee_number" id="employee-employee_number" required class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_employee['employee_number']) : ''; ?>" placeholder="e.g., EMP001">
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Name *</label>
                    <input type="text" name="name" id="employee-name" required class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_employee['name']) : ''; ?>" placeholder="Full Name">
                </div>
                
                <button type="submit" id="form-submit-button" class="w-full bg-gradient-to-r from-teal-500 to-cyan-600 hover:from-teal-600 hover:to-cyan-700 text-white font-semibold py-3 px-6 rounded-lg transition-all shadow-lg">
                    <i class="fas <?php echo $button_icon; ?> mr-2"></i> <span id="button-text"><?php echo $button_text; ?></span>
                </button>
                
                <?php if ($is_edit) : ?>
                <button type="button" onclick="resetEmployeeForm()" class="w-full bg-gray-500 hover:bg-gray-600 text-white font-semibold py-2 px-6 rounded-lg transition-all">
                    <i class="fas fa-times mr-2"></i> Cancel Edit
                </button>
                <?php endif; ?>
            </form>
        </div>

        <!-- List -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-lg font-bold text-gray-800"><i class="fas fa-list text-teal-500 mr-2"></i>Employees (<span id="employee-count"><?php echo count($employees); ?></span>)</h2>
                <div class="relative">
                    <input type="text" id="employee-search" placeholder="Search employees..." class="pl-10 pr-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all text-sm">
                    <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>

            <!-- Active Employees Section -->
            <div class="mb-6">
                <button type="button" class="w-full text-left toggle-section" data-section="active" onclick="toggleSection('active')">
                    <h3 class="text-md font-semibold text-gray-700 pb-2 border-b-2 border-green-500 flex items-center justify-between hover:text-green-600 transition-colors">
                        <span class="flex items-center">
                            <i class="fas fa-check-circle text-green-500 mr-2"></i>Active Employees
                            <span class="ml-2 px-2 py-0.5 text-xs bg-green-100 text-green-700 rounded-full" id="active-count">
                                <?php echo count(array_filter($employees, fn($e) => $e['is_active'])); ?>
                            </span>
                        </span>
                        <i class="fas fa-chevron-down text-green-500 transition-transform duration-300" id="active-toggle-icon"></i>
                    </h3>
                </button>
                <div class="space-y-3 max-h-[300px] overflow-y-auto mt-3" id="active-employee-list" data-section="active">
                    <?php 
                    $active_employees = array_filter($employees, fn($e) => $e['is_active']);
                    if (empty($active_employees)) : 
                    ?>
                    <p class="text-gray-500 text-center py-4 text-sm">No active employees</p>
                    <?php else : ?>
                        <?php foreach ($active_employees as $emp) : ?>
                    <div class="bg-green-50 rounded-lg p-4 border border-green-200 hover:border-green-400 transition-all employee-item active-employee" id="employee-item-<?php echo $emp['id']; ?>" data-name="<?php echo strtolower(htmlspecialchars($emp['name'])); ?>" data-number="<?php echo str_pad($emp['employee_number'], 4, '0', STR_PAD_LEFT); ?>">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <h3 class="font-bold text-gray-800" id="employee-name-<?php echo $emp['id']; ?>"><?php echo htmlspecialchars($emp['name']); ?></h3>
                                <p class="text-sm text-green-600 font-medium" id="employee-number-<?php echo $emp['id']; ?>">#<?php echo str_pad($emp['employee_number'], 4, '0', STR_PAD_LEFT); ?></p>
                                <?php if (!empty($emp['department'])) : ?>
                                <p class="text-xs text-gray-500 mt-1"><i class="fas fa-building mr-1"></i><?php echo htmlspecialchars($emp['department']); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="flex space-x-2 ml-4">
                                <form method="POST" class="inline toggle-status-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="action" value="toggle_status">
                                    <input type="hidden" name="id" value="<?php echo $emp['id']; ?>">
                                    <button type="submit" class="bg-gray-500 hover:bg-gray-600 text-white p-2 rounded transition-all" title="Deactivate">
                                        <i class="fas fa-toggle-off text-xs"></i>
                                    </button>
                                </form>
                                <button type="button" onclick="editEmployee(<?php echo htmlspecialchars(json_encode($emp)); ?>)" class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>
                                <form method="POST" class="inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?php echo $emp['id']; ?>">
                                    <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                                        <i class="fas fa-trash text-xs"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Inactive Employees Section -->
            <div>
                <button type="button" class="w-full text-left toggle-section" data-section="inactive" onclick="toggleSection('inactive')">
                    <h3 class="text-md font-semibold text-gray-700 pb-2 border-b-2 border-red-500 flex items-center justify-between hover:text-red-600 transition-colors">
                        <span class="flex items-center">
                            <i class="fas fa-times-circle text-red-500 mr-2"></i>Inactive Employees
                            <span class="ml-2 px-2 py-0.5 text-xs bg-red-100 text-red-700 rounded-full" id="inactive-count">
                                <?php echo count(array_filter($employees, fn($e) => !$e['is_active'])); ?>
                            </span>
                        </span>
                        <i class="fas fa-chevron-down text-red-500 transition-transform duration-300" id="inactive-toggle-icon"></i>
                    </h3>
                </button>
                <div class="space-y-3 max-h-[300px] overflow-y-auto mt-3" id="inactive-employee-list" data-section="inactive">
                    <?php 
                    $inactive_employees = array_filter($employees, fn($e) => !$e['is_active']);
                    if (empty($inactive_employees)) : 
                    ?>
                    <p class="text-gray-500 text-center py-4 text-sm">No inactive employees</p>
                    <?php else : ?>
                        <?php foreach ($inactive_employees as $emp) : ?>
                    <div class="bg-red-50 rounded-lg p-4 border border-red-200 hover:border-red-400 transition-all employee-item inactive-employee opacity-75" id="employee-item-<?php echo $emp['id']; ?>" data-name="<?php echo strtolower(htmlspecialchars($emp['name'])); ?>" data-number="<?php echo str_pad($emp['employee_number'], 4, '0', STR_PAD_LEFT); ?>">
                        <div class="flex justify-between items-start">
                            <div class="flex-1">
                                <div class="flex items-center">
                                    <h3 class="font-bold text-gray-800" id="employee-name-<?php echo $emp['id']; ?>"><?php echo htmlspecialchars($emp['name']); ?></h3>
                                    <span class="ml-2 px-2 py-0.5 text-xs bg-red-100 text-red-600 rounded-full">Inactive</span>
                                </div>
                                <p class="text-sm text-red-600 font-medium" id="employee-number-<?php echo $emp['id']; ?>">#<?php echo str_pad($emp['employee_number'], 4, '0', STR_PAD_LEFT); ?></p>
                                <?php if (!empty($emp['department'])) : ?>
                                <p class="text-xs text-gray-500 mt-1"><i class="fas fa-building mr-1"></i><?php echo htmlspecialchars($emp['department']); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="flex space-x-2 ml-4">
                                <form method="POST" class="inline toggle-status-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="action" value="toggle_status">
                                    <input type="hidden" name="id" value="<?php echo $emp['id']; ?>">
                                    <button type="submit" class="bg-green-500 hover:bg-green-600 text-white p-2 rounded transition-all" title="Activate">
                                        <i class="fas fa-toggle-on text-xs"></i>
                                    </button>
                                </form>
                                <button type="button" onclick="editEmployee(<?php echo htmlspecialchars(json_encode($emp)); ?>)" class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>
                                <form method="POST" class="inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id" value="<?php echo $emp['id']; ?>">
                                    <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                                        <i class="fas fa-trash text-xs"></i>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Toggle section collapse/expand
function toggleSection(section) {
    const listElement = document.getElementById(section + '-employee-list');
    const iconElement = document.getElementById(section + '-toggle-icon');
    
    // Toggle display
    if (listElement.style.display === 'none') {
        listElement.style.display = '';
        iconElement.style.transform = 'rotate(0deg)';
    } else {
        listElement.style.display = 'none';
        iconElement.style.transform = 'rotate(-90deg)';
    }
}

function toggleBulkUpload() {
    const section = document.getElementById('bulk-upload-section');
    section.classList.toggle('hidden');
}

function editEmployee(emp) {
    document.getElementById('form-action').value = 'edit';
    document.getElementById('item-id').value = emp.id;
    document.getElementById('employee-employee_number').value = emp.employee_number;
    document.getElementById('employee-name').value = emp.name;
    
    document.getElementById('form-title').innerHTML = '<i class="fas fa-save text-teal-500 mr-2"></i>Edit Employee';
    document.getElementById('button-text').textContent = 'Update Employee';
    document.getElementById('form-submit-button').querySelector('i').className = 'fas fa-save mr-2';
    
    // Add cancel button if not exists
    if (!document.getElementById('cancel-edit-btn')) {
        const cancelBtn = document.createElement('button');
        cancelBtn.type = 'button';
        cancelBtn.id = 'cancel-edit-btn';
        cancelBtn.className = 'w-full bg-gray-500 hover:bg-gray-600 text-white font-semibold py-2 px-6 rounded-lg transition-all mt-2';
        cancelBtn.innerHTML = '<i class="fas fa-times mr-2"></i> Cancel Edit';
        cancelBtn.onclick = resetEmployeeForm;
        document.getElementById('form-submit-button').parentNode.appendChild(cancelBtn);
    }
    
    // Scroll to form
    document.getElementById('employee-form').scrollIntoView({ behavior: 'smooth' });
}

function resetEmployeeForm() {
    document.getElementById('form-action').value = 'add';
    document.getElementById('item-id').value = '';
    document.getElementById('employee-employee_number').value = '';
    document.getElementById('employee-name').value = '';
    
    // Remove cancel button
    const cancelBtn = document.getElementById('cancel-edit-btn');
    if (cancelBtn) {
        cancelBtn.remove();
    }
    
    document.getElementById('form-title').innerHTML = '<i class="fas fa-plus text-teal-500 mr-2"></i>Add New Employee';
    document.getElementById('button-text').textContent = 'Add Employee';
    document.getElementById('form-submit-button').querySelector('i').className = 'fas fa-plus mr-2';
}

// Search functionality
document.getElementById('employee-search').addEventListener('input', function(e) {
    const searchTerm = e.target.value.toLowerCase();
    const items = document.querySelectorAll('.employee-item');
    
    items.forEach(item => {
        const name = item.dataset.name;
        const number = item.dataset.number;
        if (name.includes(searchTerm) || number.includes(searchTerm)) {
            item.style.display = '';
        } else {
            item.style.display = 'none';
        }
    });
});

// Handle form submissions via AJAX
document.getElementById('employee-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo APP_URL; ?>/master-data/employees', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('error', data.message);
        }
    })
    .catch(error => {
        showAlert('error', 'An error occurred. Please try again.');
    });
});

// Handle bulk upload form
document.getElementById('bulk-upload-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo APP_URL; ?>/master-data/employees', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1500);
        } else {
            showAlert('error', data.message);
        }
    })
    .catch(error => {
        showAlert('error', 'An error occurred during upload. Please try again.');
    });
});

// Handle delete forms
document.querySelectorAll('.delete-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to delete this employee?')) {
            return;
        }
        
        const formData = new FormData(this);
        
        fetch('<?php echo APP_URL; ?>/master-data/employees', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                document.getElementById('employee-item-' + data.deleted_id).remove();
                updateCount();
            } else {
                showAlert('error', data.message);
            }
        })
        .catch(error => {
            showAlert('error', 'An error occurred. Please try again.');
        });
    });
});

// Handle toggle status forms
document.querySelectorAll('.toggle-status-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const employeeId = formData.get('id');
        
        fetch('<?php echo APP_URL; ?>/master-data/employees', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            console.log('Toggle status response:', data); // Debug log
            
            if (data.success) {
                showToast('success', data.message || 'Status updated successfully');
                
                // Get the updated employee data
                const updatedEmployee = data.updated_item;
                
                if (!updatedEmployee) {
                    console.error('No updated_item in response:', data);
                    showToast('error', 'Failed to get updated employee data');
                    return;
                }
                
                // Remove the employee item from current section
                const employeeItem = document.getElementById('employee-item-' + employeeId);
                if (employeeItem) {
                    employeeItem.remove();
                }
                
                // Add to the appropriate section
                if (updatedEmployee.is_active == 1) {
                    // Move to active section
                    addToActiveSection(updatedEmployee);
                } else {
                    // Move to inactive section
                    addToInactiveSection(updatedEmployee);
                }
                
                // Update counts
                updateSectionCounts();
            } else {
                showToast('error', data.message || 'Failed to update status');
            }
        })
        .catch(error => {
            showToast('error', 'An error occurred. Please try again.');
        });
    });
});

// Function to add employee to active section
function addToActiveSection(emp) {
    const activeList = document.getElementById('active-employee-list');
    const noActiveMsg = activeList.querySelector('p.text-gray-500');
    if (noActiveMsg) {
        noActiveMsg.remove();
    }
    
    const department = emp.department && emp.department !== 'null' && emp.department.trim() !== '' ? emp.department : '';
    
    const paddedNumber = String(emp.employee_number).padStart(4, '0');
    const empHtml = `
        <div class="bg-green-50 rounded-lg p-4 border border-green-200 hover:border-green-400 transition-all employee-item active-employee" id="employee-item-${emp.id}" data-name="${emp.name.toLowerCase()}" data-number="${paddedNumber}">
            <div class="flex justify-between items-start">
                <div class="flex-1">
                    <h3 class="font-bold text-gray-800" id="employee-name-${emp.id}">${escapeHtml(emp.name)}</h3>
                    <p class="text-sm text-green-600 font-medium" id="employee-number-${emp.id}">#${paddedNumber}</p>
                    ${department ? `<p class="text-xs text-gray-500 mt-1"><i class="fas fa-building mr-1"></i>${escapeHtml(department)}</p>` : ''}
                </div>
                <div class="flex space-x-2 ml-4">
                    <form method="POST" class="inline toggle-status-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="action" value="toggle_status">
                        <input type="hidden" name="id" value="${emp.id}">
                        <button type="submit" class="bg-gray-500 hover:bg-gray-600 text-white p-2 rounded transition-all" title="Deactivate">
                            <i class="fas fa-toggle-off text-xs"></i>
                        </button>
                    </form>
                    <button type="button" onclick='editEmployee(${JSON.stringify(emp)})' class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                        <i class="fas fa-edit text-xs"></i>
                    </button>
                    <form method="POST" class="inline delete-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="${emp.id}">
                        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                            <i class="fas fa-trash text-xs"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    `;
    
    activeList.insertAdjacentHTML('beforeend', empHtml);
    
    // Re-attach event listeners for the new element
    attachEventListeners();
}

// Function to add employee to inactive section
function addToInactiveSection(emp) {
    const inactiveList = document.getElementById('inactive-employee-list');
    const noInactiveMsg = inactiveList.querySelector('p.text-gray-500');
    if (noInactiveMsg) {
        noInactiveMsg.remove();
    }
    
    const department = emp.department && emp.department !== 'null' && emp.department.trim() !== '' ? emp.department : '';
    
    const paddedNumber = String(emp.employee_number).padStart(4, '0');
    const empHtml = `
        <div class="bg-red-50 rounded-lg p-4 border border-red-200 hover:border-red-400 transition-all employee-item inactive-employee opacity-75" id="employee-item-${emp.id}" data-name="${emp.name.toLowerCase()}" data-number="${paddedNumber}">
            <div class="flex justify-between items-start">
                <div class="flex-1">
                    <div class="flex items-center">
                        <h3 class="font-bold text-gray-800" id="employee-name-${emp.id}">${escapeHtml(emp.name)}</h3>
                        <span class="ml-2 px-2 py-0.5 text-xs bg-red-100 text-red-600 rounded-full">Inactive</span>
                    </div>
                    <p class="text-sm text-red-600 font-medium" id="employee-number-${emp.id}">#${paddedNumber}</p>
                    ${department ? `<p class="text-xs text-gray-500 mt-1"><i class="fas fa-building mr-1"></i>${escapeHtml(department)}</p>` : ''}
                </div>
                <div class="flex space-x-2 ml-4">
                    <form method="POST" class="inline toggle-status-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="action" value="toggle_status">
                        <input type="hidden" name="id" value="${emp.id}">
                        <button type="submit" class="bg-green-500 hover:bg-green-600 text-white p-2 rounded transition-all" title="Activate">
                            <i class="fas fa-toggle-on text-xs"></i>
                        </button>
                    </form>
                    <button type="button" onclick='editEmployee(${JSON.stringify(emp)})' class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                        <i class="fas fa-edit text-xs"></i>
                    </button>
                    <form method="POST" class="inline delete-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="action" value="delete">
                        <input type="hidden" name="id" value="${emp.id}">
                        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                            <i class="fas fa-trash text-xs"></i>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    `;
    
    inactiveList.insertAdjacentHTML('beforeend', empHtml);
    
    // Re-attach event listeners for the new element
    attachEventListeners();
}

// Function to update section counts
function updateSectionCounts() {
    const activeCount = document.querySelectorAll('.active-employee').length;
    const inactiveCount = document.querySelectorAll('.inactive-employee').length;
    
    document.getElementById('active-count').textContent = activeCount;
    document.getElementById('inactive-count').textContent = inactiveCount;
    document.getElementById('employee-count').textContent = activeCount + inactiveCount;
    
    // Show "no employees" message if sections are empty
    const activeList = document.getElementById('active-employee-list');
    const inactiveList = document.getElementById('inactive-employee-list');
    
    if (activeCount === 0 && !activeList.querySelector('p.text-gray-500')) {
        activeList.innerHTML = '<p class="text-gray-500 text-center py-4 text-sm">No active employees</p>';
    }
    
    if (inactiveCount === 0 && !inactiveList.querySelector('p.text-gray-500')) {
        inactiveList.innerHTML = '<p class="text-gray-500 text-center py-4 text-sm">No inactive employees</p>';
    }
}

// Function to escape HTML
function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Function to re-attach event listeners to dynamically added elements
function attachEventListeners() {
    // Re-attach delete form listeners
    document.querySelectorAll('.delete-form').forEach(form => {
        // Remove old listener by cloning
        const newForm = form.cloneNode(true);
        form.parentNode.replaceChild(newForm, form);
        
        newForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (!confirm('Are you sure you want to delete this employee?')) {
                return;
            }
            
            const formData = new FormData(this);
            
            fetch('<?php echo APP_URL; ?>/master-data/employees', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showToast('success', data.message);
                    document.getElementById('employee-item-' + data.deleted_id).remove();
                    updateSectionCounts();
                } else {
                    showToast('error', data.message);
                }
            })
            .catch(error => {
                showToast('error', 'An error occurred. Please try again.');
            });
        });
    });
    
    // Re-attach toggle status form listeners
    document.querySelectorAll('.toggle-status-form').forEach(form => {
        // Remove old listener by cloning
        const newForm = form.cloneNode(true);
        form.parentNode.replaceChild(newForm, form);
        
        newForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            const formData = new FormData(this);
            const employeeId = formData.get('id');
            
            fetch('<?php echo APP_URL; ?>/master-data/employees', {
                method: 'POST',
                body: formData,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showToast('success', data.message);
                    
                    const updatedEmployee = data.updated_item;
                    const employeeItem = document.getElementById('employee-item-' + employeeId);
                    if (employeeItem) {
                        employeeItem.remove();
                    }
                    
                    if (updatedEmployee.is_active == 1) {
                        addToActiveSection(updatedEmployee);
                    } else {
                        addToInactiveSection(updatedEmployee);
                    }
                    
                    updateSectionCounts();
                } else {
                    showToast('error', data.message);
                }
            })
            .catch(error => {
                showToast('error', 'An error occurred. Please try again.');
            });
        });
    });
}

function updateCount() {
    const count = document.querySelectorAll('.employee-item').length;
    document.getElementById('employee-count').textContent = count;
}

function showAlert(type, message) {
    const alertArea = document.getElementById('alert-area');
    const bgColor = type === 'success' ? 'bg-green-100 border-green-500 text-green-700' : 'bg-red-100 border-red-500 text-red-700';
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    alertArea.innerHTML = `
        <div class="${bgColor} border-l-4 p-4 rounded-lg shadow-lg slide-in-up">
            <div class="flex items-center">
                <i class="fas ${icon} mr-2"></i>
                <span>${message}</span>
            </div>
        </div>
    `;
    
    setTimeout(() => {
        alertArea.innerHTML = '';
    }, 5000);
}

// Modal handling
const bulkAddBtn = document.getElementById('bulkAddBtn');
const closeModalBtn = document.getElementById('closeModalBtn');
const bulkAddModal = document.getElementById('bulkAddModal');

bulkAddBtn.addEventListener('click', () => {
    bulkAddModal.classList.remove('hidden');
});

closeModalBtn.addEventListener('click', () => {
    bulkAddModal.classList.add('hidden');
});

window.addEventListener('click', (event) => {
    if (event.target == bulkAddModal) {
        bulkAddModal.classList.add('hidden');
    }
});

// Toast notification function
function showToast(type, message) {
    console.log('showToast called with:', type, message); // Debug
    
    if (!message || message.trim() === '') {
        console.error('Empty message provided to showToast');
        message = 'Action completed';
    }
    
    const container = document.getElementById('toast-container');
    if (!container) {
        console.error('Toast container not found');
        return;
    }
    
    const toastId = 'toast-' + Date.now();
    
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    const toastClass = type === 'success' ? 'toast-success' : 'toast-error';
    
    const toast = document.createElement('div');
    toast.id = toastId;
    toast.className = `toast ${toastClass} slide-in-right`;
    
    // Create elements separately to avoid innerHTML issues
    const iconEl = document.createElement('i');
    iconEl.className = `fas ${icon} text-2xl`;
    
    const messageSpan = document.createElement('span');
    messageSpan.className = 'flex-1 font-medium';
    messageSpan.textContent = message; // Use textContent instead of innerHTML
    
    const closeBtn = document.createElement('button');
    closeBtn.className = 'ml-2 hover:opacity-75 transition-opacity';
    closeBtn.onclick = () => closeToast(toastId);
    closeBtn.innerHTML = '<i class="fas fa-times"></i>';
    
    toast.appendChild(iconEl);
    toast.appendChild(messageSpan);
    toast.appendChild(closeBtn);
    
    container.appendChild(toast);
    
    console.log('Toast created:', toastId, message); // Debug
    
    // Auto-remove after 4 seconds
    setTimeout(() => {
        closeToast(toastId);
    }, 4000);
}

function closeToast(toastId) {
    const toast = document.getElementById(toastId);
    if (toast) {
        toast.classList.remove('slide-in-right');
        toast.classList.add('slide-out-right');
        setTimeout(() => {
            toast.remove();
        }, 300);
    }
}
</script>
