<?php
$is_edit = isset($editing_department) && $editing_department;
$form_action = $is_edit ? 'edit' : 'add';
$form_title = $is_edit ? 'Edit Department' : 'Add New Department';
$button_text = $is_edit ? 'Update Department' : 'Add Department';
$button_icon = $is_edit ? 'fa-save' : 'fa-plus';
?>

<div class="max-w-6xl mx-auto space-y-6">
    <div class="bg-gradient-to-r from-purple-500 to-pink-600 rounded-xl shadow-2xl p-6 text-white">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="bg-white/20 backdrop-blur-lg p-3 rounded-lg">
                    <i class="fas fa-building text-white text-2xl"></i>
                </div>
                <div class="ml-4">
                    <h1 class="text-2xl font-bold">Manage Departments</h1>
                    <p class="text-white/80 text-sm mt-1">Add, edit, or delete departments</p>
                </div>
            </div>
        </div>
    </div>

    <div id="alert-area"></div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Add/Edit Form -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <h2 class="text-lg font-bold text-gray-800 mb-4" id="form-title"><i class="fas <?php echo $button_icon; ?> text-purple-500 mr-2"></i><?php echo $form_title; ?></h2>
            <form id="department-form" method="POST" class="space-y-4" data-master-data-type="department">
                <?php require_once __DIR__ . '/../../Helpers/csrf.php';
                echo csrf_field(); ?>
                <input type="hidden" name="action" id="form-action" value="<?php echo $form_action; ?>">
                <?php if ($is_edit) : ?>
                <input type="hidden" name="id" id="item-id" value="<?php echo $editing_department['id']; ?>">
                <?php else : ?>
                <input type="hidden" name="id" id="item-id" value="">
                <?php endif; ?>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Name *</label>
                    <input type="text" name="name" id="department-name" required class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_department['name']) : ''; ?>">
                </div>
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Description</label>
                    <textarea name="description" id="department-description" rows="3" class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-purple-500 focus:ring-4 focus:ring-purple-100 transition-all"><?php echo $is_edit ? htmlspecialchars($editing_department['description']) : ''; ?></textarea>
                </div>
                <button type="submit" id="form-submit-button" class="w-full bg-gradient-to-r from-purple-500 to-pink-600 hover:from-purple-600 hover:to-pink-700 text-white font-semibold py-3 px-6 rounded-lg transition-all shadow-lg">
                    <i class="fas <?php echo $button_icon; ?> mr-2"></i> <span id="button-text"><?php echo $button_text; ?></span>
                </button>

            </form>
        </div>

        <!-- List -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <h2 class="text-lg font-bold text-gray-800 mb-4"><i class="fas fa-list text-purple-500 mr-2"></i>Existing Departments (<span id="department-count"><?php echo count($departments); ?></span>)</h2>
            <div class="space-y-3 max-h-[600px] overflow-y-auto" id="department-list">
                <?php if (empty($departments)) : ?>
                <p class="text-gray-500 text-center py-8" id="no-departments-message">No departments yet. Add one to get started!</p>
                <?php else : ?>
                    <?php foreach ($departments as $dept) : ?>
                <div class="bg-gray-50 rounded-lg p-4 border border-gray-200 hover:border-purple-300 transition-all" id="department-item-<?php echo $dept['id']; ?>">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <h3 class="font-bold text-gray-800" id="department-name-<?php echo $dept['id']; ?>"><?php echo htmlspecialchars($dept['name']); ?></h3>
                            <?php if ($dept['description']) :
                                ?><p class="text-xs text-gray-500 mt-1" id="department-description-<?php echo $dept['id']; ?>"><?php echo htmlspecialchars($dept['description']); ?></p><?php
                            endif; ?>
                        </div>
                        <div class="flex space-x-2 ml-4">
                            <button type="button" onclick="editMasterItem('department', '<?php echo base64_encode(json_encode($dept)); ?>')" class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                                <i class="fas fa-edit text-xs"></i>
                            </button>
                            <form method="POST" class="inline delete-form">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $dept['id']; ?>">
                                <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo APP_URL; ?>/public/js/master-data-edit.js"></script>
