<?php

namespace App\Models;

use App\Core\Model;

class ProductModel extends Model
{
    protected $table = 'products';

    public function getAll()
    {
        $sql = "SELECT p.id, p.part_number, p.name, p.description, p.barcode, p.qr_code, p.low_stock_threshold,
                       c.name as category_name
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id
                WHERE p.deleted_at IS NULL ORDER BY p.part_number";
        $stmt = $this->db->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getAllWithCategory()
    {
        $sql = "SELECT p.id, p.part_number, p.name, p.description, p.barcode, p.qr_code, p.low_stock_threshold,
                       c.name as category_name
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id 
                WHERE p.deleted_at IS NULL
                ORDER BY p.part_number";
        $stmt = $this->db->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll();
    }

    public function getByPartNumber($partNumber)
    {
        $sql = "SELECT p.*, c.name as category_name
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id 
                WHERE p.part_number = :part_number AND p.deleted_at IS NULL";
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['part_number' => $partNumber]);
        return $stmt->fetch();
    }

    public function getByName($name)
    {
        $sql = "SELECT p.*, c.name as category_name
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id 
                WHERE p.name = :name AND p.deleted_at IS NULL";
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['name' => $name]);
        return $stmt->fetch();
    }

    public function create($data)
    {
        $sql = "INSERT INTO products (part_number, name, category_id, description, low_stock_threshold, qr_code) 
                VALUES (:part_number, :name, :category_id, :description, :low_stock_threshold, :qr_code)";

        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }

    public function update($id, $data)
    {
        $sql = "UPDATE products SET 
                part_number = :part_number,
                name = :name,
                category_id = :category_id,
                description = :description,
                low_stock_threshold = :low_stock_threshold,
                qr_code = :qr_code
                WHERE id = :id";

        $data['id'] = $id;
        $stmt = $this->db->prepare($sql);
        return $stmt->execute($data);
    }

    public function getProductDetails($productId)
    {
        $sql = "SELECT p.*, 
                c.name as category_name,
                (SELECT SUM(quantity) FROM inventory WHERE product_id = p.id) as total_stock
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id
                WHERE p.id = :id";
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['id' => $productId]);
        return $stmt->fetch();
    }

    public function getProductInventory($productId)
    {
        $sql = "SELECT i.location_id, i.quantity, i.min_quantity, i.last_updated, l.name as location_name
                FROM inventory i
                JOIN locations l ON i.location_id = l.id
                WHERE i.product_id = :product_id
                ORDER BY l.name";
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['product_id' => $productId]);
        return $stmt->fetchAll();
    }

    public function delete($id)
    {
        // Soft delete - set deleted_at timestamp
        $sql = "UPDATE products SET deleted_at = NOW() WHERE id = :id";
        $stmt = $this->db->prepare($sql);
        return $stmt->execute(['id' => $id]);
    }

    public function searchByPartNumber($term)
    {
        $sql = "SELECT p.id, p.part_number, p.description, p.barcode, p.qr_code, p.low_stock_threshold,
                       c.name as category_name
                FROM products p
                LEFT JOIN categories c ON p.category_id = c.id
                WHERE p.deleted_at IS NULL
                AND (p.part_number LIKE :term OR p.description LIKE :term)
                ORDER BY p.part_number";
        $stmt = $this->db->prepare($sql);
        $stmt->execute(['term' => '%' . $term . '%']);
        return $stmt->fetchAll();
    }
}
