# Remediation Plan: v2→v3 Size/Seller/Type Removal

## Completed Fixes ✅

### Models
1. ✅ **TransactionModel.php** - Removed `size_id` and `seller_id` from INSERT statement
2. ✅ **InventoryModel.php** - Removed `size_id` parameter from `updateStock()` and `subtractStock()` methods
3. ✅ **InventoryModel.php** - Added `getAvailableStock()` method without size parameter

### Controllers (Partial)
4. ✅ **StockController.php** - Fixed `add()` method POST handling to remove size/seller references
5. ✅ **StockController.php** - Fixed `add()` method view data to remove sizes/sellers arrays

## Remaining Critical Fixes ❌

### StockController.php - Requires Extensive Updates

#### `out()` Method
- Remove `$sizeId` variable and references
- Update `subtractStock()` call to remove size parameter
- Update transaction record to remove `size_id`
- Replace `product_type` with `product['name']`
- Remove `getSizeName()` calls
- Update log details to remove size references
- Update notification calls to remove size parameter
- Update toast message to remove size placeholder
- Remove size from view data arrays
- Remove size pre-loading logic

#### `transfer()` Method  
- Remove `$sizeId` variable and references
- Update `subtractStock()` call to remove size parameter
- Update `updateStock()` calls to remove size parameter
- Update transaction records to remove `size_id`
- Replace `product_type` with `product['name']`
- Remove `getSizeName()` calls
- Update log details to remove size references
- Update notification calls to remove size parameter
- Update toast message to remove size placeholder
- Remove sizes/sellers from view data
- Remove size pre-loading logic

#### Helper Methods to Remove/Update
- ❌ Remove `getSellers()` method entirely
- ❌ Remove `getSizes()` method entirely
- ❌ Remove `getSizeName()` method entirely
- ❌ Remove `getProductSizes()` method entirely
- ❌ Remove `getAvailableSizesInStock()` method entirely

#### `bulkAdd()` Method
- Remove size and seller lookup logic
- Remove `$sizeMap` and `$sellerMap` arrays
- Update `updateStock()` call to remove size parameter
- Update transaction record to remove `size_id` and `seller_id`
- Update column mapping documentation

#### `checkStock()` Method
- Remove `$sizeId` parameter handling
- Update `getAvailableStock()` call to remove size parameter

#### `validateStockData()` Method
- Remove all size validation logic (lines 880-935)
- Remove seller validation logic (line 917)
- Remove `available_sizes` checks
- Simplify to only validate: product_id, location_id, quantity, department/employee (for 'out'), price_per_unit (for 'add')

### ProductController.php
- Remove `available_sizes` from product creation (line 50)
- Remove `available_sizes` from product editing (line 160)
- Remove `available_sizes` from bulk import (line 341)
- Remove any methods related to sizes (getAvailableSizes, getAvailableSizesInStock)

### ReportController.php
- Remove LEFT JOIN to `product_sizes` table (line 78)
- Update any report queries that reference sizes

### Views

#### stock/add.php
- Remove size dropdown/select field
- Remove seller dropdown/select field
- Update product display to use `name` instead of `product_type`
- Remove size-related JavaScript

#### stock/out.php
- Remove size dropdown/select field
- Update product display to use `name` instead of `product_type`
- Remove size-related JavaScript

#### stock/transfer.php
- Remove size dropdown/select field
- Update product display to use `name` instead of `product_type` (lines 85, 250, 345, 382, 708)
- Remove size_id references in JavaScript (lines 202-205, 418, 513, 673, 697)

#### stock/partials/stock_content.php
- Remove `size_id` from URL parameters (lines 210, 215, 220)

#### products/index.php
- Update CSV template header to remove `type_id` and `available_sizes` (line 74)
- Remove documentation about `type_id` (line 78)
- Remove documentation about `available_sizes` (line 82)

#### products/detail.php
- Remove commented code referencing `product_type` (line 85)

#### products/add.php & products/edit.php
- Remove size selection UI
- Remove type selection UI
- Update form to only include: part_number, name, category, description, barcode, low_stock_threshold

### JavaScript

#### public/js/stock.js
- Remove `size_id` element reference (line 10)
- Remove `size_id` value retrieval (line 36)
- Remove `size_id` from fetch URL (line 52)
- Remove any size-related event handlers

### Templates

#### public/products_template.csv
- Update header to: `part_number,category_name,description,low_stock_threshold`
- Remove `type_id` and `available_sizes` columns

#### public/stock_template.csv (if exists)
- Remove size and seller columns
- Update to: `product_name,location,quantity,remarks,price_per_unit`

### Legacy Files

#### scan.php
- Remove `size_id` parameter handling (line 163)
- Or mark file as deprecated if no longer used

## Testing Checklist

After all fixes are applied:

### Stock Operations
- [ ] Add stock without size/seller - should work
- [ ] Remove stock without size - should work
- [ ] Transfer stock without size - should work
- [ ] Check stock levels - should work
- [ ] Bulk import stock - should work with new template

### Product Operations
- [ ] Create product without type/sizes - should work
- [ ] Edit product - should not show type/sizes
- [ ] View product details - should not show type/sizes
- [ ] Bulk import products - should work with new template

### Reports
- [ ] Inventory reports - should work without size columns
- [ ] Transaction history - should work without size/seller columns
- [ ] Low stock alerts - should work

### UI/UX
- [ ] No broken dropdowns for sizes/sellers
- [ ] Product names display correctly (not "product_type")
- [ ] All forms submit successfully
- [ ] No JavaScript errors in console
- [ ] CSV templates download correctly

## Deployment Steps

1. **Backup Production Database**
   ```sql
   mysqldump -u user -p database_name > backup_before_migration.sql
   ```

2. **Run Migration on Staging**
   ```sql
   source v3/database/migration_remove_size_seller_type.sql
   ```

3. **Deploy Code Changes to Staging**
   - Deploy all updated PHP files
   - Deploy updated view files
   - Deploy updated JavaScript files
   - Deploy updated CSV templates

4. **Test on Staging**
   - Run through entire testing checklist
   - Verify no errors in logs
   - Test with real user workflows

5. **Deploy to Production**
   - Schedule maintenance window
   - Run database migration
   - Deploy code changes
   - Clear any caches
   - Monitor error logs

6. **Post-Deployment**
   - Verify all stock operations work
   - Check for any error spikes
   - Communicate changes to users
   - Update user documentation

## Rollback Plan

If issues occur:

1. **Code Rollback**: Revert to previous version
2. **Database Rollback**: 
   - Restore from backup
   - Re-add dropped tables/columns
   - Note: May lose transactions during migration window

## Notes

- The `name` field in products table replaces the old `product_type` display
- Inventory is now tracked only by (product_id, location_id) - no size dimension
- Transactions no longer track seller information
- This simplifies the data model significantly
- Consider adding migration notes to user documentation

---
**Status**: In Progress
**Last Updated**: 2024
**Next Steps**: Complete StockController fixes, then move to views
