<?php
$is_edit = isset($editing_employee) && $editing_employee;
$form_action = $is_edit ? 'edit' : 'add';
$form_title = $is_edit ? 'Edit Employee' : 'Add New Employee';
$button_text = $is_edit ? 'Update Employee' : 'Add Employee';
$button_icon = $is_edit ? 'fa-save' : 'fa-plus';
?>

<style>
    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .slide-in-up {
        animation: slideInUp 0.5s ease-out;
    }
    
    .employee-row {
        transition: all 0.3s ease;
    }
    
    .employee-row:hover {
        transform: translateX(8px);
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    }
</style>

<div class="max-w-6xl mx-auto space-y-6">
    <!-- Page Header -->
    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 rounded-xl shadow-2xl p-6 text-white slide-in-up">
        <div class="flex justify-between items-center">
            <div class="flex items-center">
                <div class="bg-white/20 backdrop-blur-lg p-3 rounded-lg mr-4">
                    <i class="fas fa-users text-2xl"></i>
                </div>
                <div>
                    <h1 class="text-2xl font-bold">Employee Management</h1>
                    <p class="text-white/80 text-sm mt-1">Manage employee records and information</p>
                </div>
            </div>
            <div class="flex items-center space-x-4">
                <button id="bulkAddBtn" class="bg-white/20 backdrop-blur-lg hover:bg-white/30 text-white font-bold py-3 px-6 rounded-lg transition-all duration-300 transform hover:scale-105 border border-white/30 flex items-center">
                    <i class="fas fa-upload mr-2"></i> Bulk Upload
                </button>
            </div>
        </div>
    </div>

    <div id="alert-area"></div>

    <!-- Bulk Upload Modal -->
    <div id="bulkAddModal" class="fixed z-10 inset-0 overflow-y-auto hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
            <div class="fixed inset-0 bg-gray-500 bg-opacity-75 transition-opacity" aria-hidden="true"></div>
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
            <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                <form id="bulk-upload-form" action="<?php echo APP_URL; ?>/master-data/employees" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="action" value="bulk_upload">
                    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 px-6 py-4">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-white bg-opacity-20">
                                <i class="fas fa-file-excel text-white text-xl"></i>
                            </div>
                            <h3 class="ml-4 text-lg font-bold text-white" id="modal-title">
                                Bulk Employee Upload
                            </h3>
                        </div>
                    </div>
                    <div class="bg-white px-6 py-6">
                        <p class="text-sm text-gray-600 mb-4">
                            Upload an Excel file to bulk add or update employees. Download the template to get started.
                        </p>
                        <div class="bg-gray-100 p-3 rounded-lg mb-4">
                            <h4 class="font-semibold text-gray-700 mb-2 text-sm">Template Columns:</h4>
                            <ul class="text-xs text-gray-600 space-y-1">
                                <li><strong>Employee Number:</strong> Unique identifier (required)</li>
                                <li><strong>Name:</strong> Full name of employee (required)</li>
                                <li><strong>Department:</strong> Department name from master data (optional)</li>
                                <li><strong>Is Active:</strong> Yes or No (required, default: Yes)</li>
                            </ul>
                        </div>
                        <a href="<?php echo APP_URL; ?>/templates/employees" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 mb-4">
                            <i class="fas fa-download mr-2"></i> Download Excel Template
                        </a>
                        <div class="mt-4">
                            <label for="bulk_file" class="block text-sm font-semibold text-gray-700 mb-2">Upload Excel File</label>
                            <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-md">
                                <div class="space-y-1 text-center">
                                    <i class="fas fa-upload mx-auto h-12 w-12 text-gray-400"></i>
                                    <div class="flex text-sm text-gray-600">
                                        <label for="bulk_file_input" class="relative cursor-pointer bg-white rounded-md font-medium text-indigo-600 hover:text-indigo-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-indigo-500">
                                            <span>Upload a file</span>
                                            <input id="bulk_file_input" name="bulk_file" type="file" class="sr-only" accept=".xlsx">
                                        </label>
                                        <p class="pl-1">or drag and drop</p>
                                    </div>
                                    <p class="text-xs text-gray-500">Excel (.xlsx) up to 10MB</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-6 py-4 flex justify-end space-x-3">
                        <button type="button" id="closeModalBtn" class="bg-white py-2 px-4 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            Cancel
                        </button>
                        <button type="submit" class="inline-flex justify-center py-2 px-4 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                            <i class="fas fa-upload mr-2"></i> Upload
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Bulk Upload Modal -->

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Add/Edit Form -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <h2 class="text-lg font-bold text-gray-800 mb-4" id="form-title"><i class="fas <?php echo $button_icon; ?> text-teal-500 mr-2"></i><?php echo $form_title; ?></h2>
            <form id="employee-form" method="POST" class="space-y-4" data-master-data-type="employee">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="action" id="form-action" value="<?php echo $form_action; ?>">
                <?php if ($is_edit) : ?>
                <input type="hidden" name="id" id="item-id" value="<?php echo $editing_employee['id']; ?>">
                <?php else : ?>
                <input type="hidden" name="id" id="item-id" value="">
                <?php endif; ?>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Employee Number *</label>
                    <input type="text" name="employee_number" id="employee-employee_number" required class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_employee['employee_number']) : ''; ?>" placeholder="e.g., EMP001">
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Name *</label>
                    <input type="text" name="name" id="employee-name" required class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_employee['name']) : ''; ?>" placeholder="Full Name">
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">Department</label>
                    <input type="text" name="department" id="employee-department" class="w-full px-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all" value="<?php echo $is_edit ? htmlspecialchars($editing_employee['department'] ?? '') : ''; ?>" placeholder="e.g., IT, HR, Finance">
                </div>
                
                <?php if ($is_edit) : ?>
                <div class="flex items-center">
                    <input type="checkbox" name="is_active" id="employee-is_active" class="w-4 h-4 text-teal-600 border-gray-300 rounded focus:ring-teal-500" <?php echo $editing_employee['is_active'] ? 'checked' : ''; ?>>
                    <label for="employee-is_active" class="ml-2 text-sm font-semibold text-gray-700">Active</label>
                </div>
                <?php endif; ?>
                
                <button type="submit" id="form-submit-button" class="w-full bg-gradient-to-r from-teal-500 to-cyan-600 hover:from-teal-600 hover:to-cyan-700 text-white font-semibold py-3 px-6 rounded-lg transition-all shadow-lg">
                    <i class="fas <?php echo $button_icon; ?> mr-2"></i> <span id="button-text"><?php echo $button_text; ?></span>
                </button>
                
                <?php if ($is_edit) : ?>
                <button type="button" onclick="resetEmployeeForm()" class="w-full bg-gray-500 hover:bg-gray-600 text-white font-semibold py-2 px-6 rounded-lg transition-all">
                    <i class="fas fa-times mr-2"></i> Cancel Edit
                </button>
                <?php endif; ?>
            </form>
        </div>

        <!-- List -->
        <div class="bg-white shadow-xl rounded-xl p-6">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-lg font-bold text-gray-800"><i class="fas fa-list text-teal-500 mr-2"></i>Employees (<span id="employee-count"><?php echo count($employees); ?></span>)</h2>
                <div class="relative">
                    <input type="text" id="employee-search" placeholder="Search employees..." class="pl-10 pr-4 py-2 rounded-lg border-2 border-gray-200 focus:border-teal-500 focus:ring-4 focus:ring-teal-100 transition-all text-sm">
                    <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                </div>
            </div>
            <div class="space-y-3 max-h-[600px] overflow-y-auto" id="employee-list">
                <?php if (empty($employees)) : ?>
                <p class="text-gray-500 text-center py-8" id="no-employees-message">No employees yet. Add one to get started!</p>
                <?php else : ?>
                    <?php foreach ($employees as $emp) : ?>
                <div class="bg-gray-50 rounded-lg p-4 border border-gray-200 hover:border-teal-300 transition-all employee-item <?php echo !$emp['is_active'] ? 'opacity-60' : ''; ?>" id="employee-item-<?php echo $emp['id']; ?>" data-name="<?php echo strtolower(htmlspecialchars($emp['name'])); ?>" data-number="<?php echo strtolower(htmlspecialchars($emp['employee_number'])); ?>">
                    <div class="flex justify-between items-start">
                        <div class="flex-1">
                            <div class="flex items-center">
                                <h3 class="font-bold text-gray-800" id="employee-name-<?php echo $emp['id']; ?>"><?php echo htmlspecialchars($emp['name']); ?></h3>
                                <?php if (!$emp['is_active']) : ?>
                                <span class="ml-2 px-2 py-0.5 text-xs bg-red-100 text-red-600 rounded-full">Inactive</span>
                                <?php endif; ?>
                            </div>
                            <p class="text-sm text-teal-600 font-medium" id="employee-number-<?php echo $emp['id']; ?>">#<?php echo htmlspecialchars($emp['employee_number']); ?></p>
                            <?php if (!empty($emp['department'])) : ?>
                            <p class="text-xs text-gray-500 mt-1"><i class="fas fa-building mr-1"></i><?php echo htmlspecialchars($emp['department']); ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="flex space-x-2 ml-4">
                            <button type="button" onclick="editEmployee(<?php echo htmlspecialchars(json_encode($emp)); ?>)" class="bg-yellow-500 hover:bg-yellow-600 text-white p-2 rounded transition-all" title="Edit">
                                <i class="fas fa-edit text-xs"></i>
                            </button>
                            <form method="POST" class="inline delete-form">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $emp['id']; ?>">
                                <button type="submit" class="bg-red-500 hover:bg-red-600 text-white p-2 rounded transition-all" title="Delete">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function toggleBulkUpload() {
    const section = document.getElementById('bulk-upload-section');
    section.classList.toggle('hidden');
}

function editEmployee(emp) {
    document.getElementById('form-action').value = 'edit';
    document.getElementById('item-id').value = emp.id;
    document.getElementById('employee-employee_number').value = emp.employee_number;
    document.getElementById('employee-name').value = emp.name;
    document.getElementById('employee-department').value = emp.department || '';
    
    // Handle is_active checkbox
    let isActiveCheckbox = document.getElementById('employee-is_active');
    if (!isActiveCheckbox) {
        // Create checkbox if it doesn't exist
        const checkboxDiv = document.createElement('div');
        checkboxDiv.className = 'flex items-center';
        checkboxDiv.id = 'is-active-container';
        checkboxDiv.innerHTML = `
            <input type="checkbox" name="is_active" id="employee-is_active" class="w-4 h-4 text-teal-600 border-gray-300 rounded focus:ring-teal-500" ${emp.is_active ? 'checked' : ''}>
            <label for="employee-is_active" class="ml-2 text-sm font-semibold text-gray-700">Active</label>
        `;
        document.getElementById('form-submit-button').parentNode.insertBefore(checkboxDiv, document.getElementById('form-submit-button'));
    } else {
        isActiveCheckbox.checked = emp.is_active == 1;
    }
    
    document.getElementById('form-title').innerHTML = '<i class="fas fa-save text-teal-500 mr-2"></i>Edit Employee';
    document.getElementById('button-text').textContent = 'Update Employee';
    document.getElementById('form-submit-button').querySelector('i').className = 'fas fa-save mr-2';
    
    // Add cancel button if not exists
    if (!document.getElementById('cancel-edit-btn')) {
        const cancelBtn = document.createElement('button');
        cancelBtn.type = 'button';
        cancelBtn.id = 'cancel-edit-btn';
        cancelBtn.className = 'w-full bg-gray-500 hover:bg-gray-600 text-white font-semibold py-2 px-6 rounded-lg transition-all mt-2';
        cancelBtn.innerHTML = '<i class="fas fa-times mr-2"></i> Cancel Edit';
        cancelBtn.onclick = resetEmployeeForm;
        document.getElementById('form-submit-button').parentNode.appendChild(cancelBtn);
    }
    
    // Scroll to form
    document.getElementById('employee-form').scrollIntoView({ behavior: 'smooth' });
}

function resetEmployeeForm() {
    document.getElementById('form-action').value = 'add';
    document.getElementById('item-id').value = '';
    document.getElementById('employee-employee_number').value = '';
    document.getElementById('employee-name').value = '';
    document.getElementById('employee-department').value = '';
    
    // Remove is_active checkbox container if exists
    const isActiveContainer = document.getElementById('is-active-container');
    if (isActiveContainer) {
        isActiveContainer.remove();
    }
    
    // Remove cancel button
    const cancelBtn = document.getElementById('cancel-edit-btn');
    if (cancelBtn) {
        cancelBtn.remove();
    }
    
    document.getElementById('form-title').innerHTML = '<i class="fas fa-plus text-teal-500 mr-2"></i>Add New Employee';
    document.getElementById('button-text').textContent = 'Add Employee';
    document.getElementById('form-submit-button').querySelector('i').className = 'fas fa-plus mr-2';
}

// Search functionality
document.getElementById('employee-search').addEventListener('input', function(e) {
    const searchTerm = e.target.value.toLowerCase();
    const items = document.querySelectorAll('.employee-item');
    
    items.forEach(item => {
        const name = item.dataset.name;
        const number = item.dataset.number;
        if (name.includes(searchTerm) || number.includes(searchTerm)) {
            item.style.display = '';
        } else {
            item.style.display = 'none';
        }
    });
});

// Handle form submissions via AJAX
document.getElementById('employee-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo APP_URL; ?>/master-data/employees', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1000);
        } else {
            showAlert('error', data.message);
        }
    })
    .catch(error => {
        showAlert('error', 'An error occurred. Please try again.');
    });
});

// Handle bulk upload form
document.getElementById('bulk-upload-form').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo APP_URL; ?>/master-data/employees', {
        method: 'POST',
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showAlert('success', data.message);
            setTimeout(() => location.reload(), 1500);
        } else {
            showAlert('error', data.message);
        }
    })
    .catch(error => {
        showAlert('error', 'An error occurred during upload. Please try again.');
    });
});

// Handle delete forms
document.querySelectorAll('.delete-form').forEach(form => {
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to delete this employee?')) {
            return;
        }
        
        const formData = new FormData(this);
        
        fetch('<?php echo APP_URL; ?>/master-data/employees', {
            method: 'POST',
            body: formData,
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showAlert('success', data.message);
                document.getElementById('employee-item-' + data.deleted_id).remove();
                updateCount();
            } else {
                showAlert('error', data.message);
            }
        })
        .catch(error => {
            showAlert('error', 'An error occurred. Please try again.');
        });
    });
});

function updateCount() {
    const count = document.querySelectorAll('.employee-item').length;
    document.getElementById('employee-count').textContent = count;
}

function showAlert(type, message) {
    const alertArea = document.getElementById('alert-area');
    const bgColor = type === 'success' ? 'bg-green-100 border-green-500 text-green-700' : 'bg-red-100 border-red-500 text-red-700';
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    
    alertArea.innerHTML = `
        <div class="${bgColor} border-l-4 p-4 rounded-lg shadow-lg slide-in-up">
            <div class="flex items-center">
                <i class="fas ${icon} mr-2"></i>
                <span>${message}</span>
            </div>
        </div>
    `;
    
    setTimeout(() => {
        alertArea.innerHTML = '';
    }, 5000);
}

// Modal handling
const bulkAddBtn = document.getElementById('bulkAddBtn');
const closeModalBtn = document.getElementById('closeModalBtn');
const bulkAddModal = document.getElementById('bulkAddModal');

bulkAddBtn.addEventListener('click', () => {
    bulkAddModal.classList.remove('hidden');
});

closeModalBtn.addEventListener('click', () => {
    bulkAddModal.classList.add('hidden');
});

window.addEventListener('click', (event) => {
    if (event.target == bulkAddModal) {
        bulkAddModal.classList.add('hidden');
    }
});
</script>
