<style>
    @keyframes fadeInScale {
        from {
            opacity: 0;
            transform: scale(0.95);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }
    
    .fade-in-scale {
        animation: fadeInScale 0.5s ease-out;
    }
    
    .detail-row {
        transition: all 0.3s ease;
    }
    
    .detail-row:hover {
        background: linear-gradient(to right, #f0f9ff, #e0f2fe);
        transform: translateX(5px);
    }

    .qr-code-card {
        display: flex;
        flex-direction: column;
        align-items: center;
    }

    .qr-code-card svg {
        display: block;
        margin: 0 auto;
    }
</style>

<div class="space-y-6">
    <!-- Back Button -->
    <div class="fade-in-scale">
        <a href="<?php echo APP_URL; ?>/products" 
           class="inline-flex items-center text-indigo-600 hover:text-indigo-800 font-medium transition-colors">
            <i class="fas fa-arrow-left mr-2"></i> Back to Products
        </a>
    </div>

    <!-- Product Header -->
    <div class="bg-gradient-to-r from-indigo-500 to-purple-600 rounded-xl shadow-2xl p-8 text-white fade-in-scale" style="animation-delay: 0.1s">
        <h1 class="text-3xl font-bold">
            <?php echo htmlspecialchars($product['part_number']); ?>
        </h1>
    </div>

    <div class="fade-in-scale" style="animation-delay: 0.18s">
        <div class="text-sm font-bold text-gray-600 uppercase tracking-wide mb-2">Product Information</div>
        <div class="flex flex-wrap items-center gap-3 text-gray-700 text-sm">
            <?php if ($product['description']) : ?>
            <span class="px-3 py-2 rounded-lg bg-gray-50 text-xs text-gray-700">
                <?php echo htmlspecialchars($product['description']); ?>
            </span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Summary and Codes -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="fade-in-scale space-y-3" style="animation-delay: 0.24s">
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 border-2 border-gray-200 shadow-xl rounded-xl p-4">
                <div class="text-sm font-semibold text-gray-500 mb-1">Category</div>
                <div class="text-lg font-semibold text-gray-900">
                    <?php if (!empty($product['category_name'])) : ?>
                    <?php echo htmlspecialchars($product['category_name']); ?>
                    <?php else : ?>
                    <span class="text-gray-500">Not categorized</span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 border-2 border-gray-200 shadow-xl rounded-xl p-4">
                <div class="text-sm font-semibold text-gray-500 mb-1">Product Type</div>
                <div class="text-lg font-semibold text-gray-900">
                    <?php echo htmlspecialchars($product['product_type'] ?? $product['type_name'] ?? ''); ?>
                </div>
            </div>
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 border-2 border-gray-200 shadow-xl rounded-xl p-4">
                <div class="text-sm font-semibold text-gray-500 mb-1">Total Stock</div>
                <div class="text-lg font-semibold text-gray-900">
                    <?php echo $product['total_stock'] ?? 0; ?> units
                </div>
            </div>
        </div>

        <div class="bg-white shadow-xl rounded-xl p-6 fade-in-scale" style="animation-delay: 0.28s">
            <?php
            // Load autoloader and include barcode generator
            if (file_exists(APP_ROOT . '/vendor/autoload.php')) {
                include_once APP_ROOT . '/vendor/autoload.php';
            }
            require_once APP_ROOT . '/app/Helpers/BarcodeGenerator.php';
            use App\Helpers\BarcodeGenerator;

            $barcodeValue = $product['part_number'];

            // Generate security token for QR code
            $securityToken = hash_hmac('sha256', $product['id'], SECURE_AUTH_KEY);

            // Create secure URL with token
            $secureUrl = APP_URL . '/scan.php?id=' . $product['id'] . '&token=' . $securityToken;

            // QR Code data - use secure URL
            $qrData = $secureUrl;
            ?>
            <?php if ($barcodeValue) : ?>
            <div class="bg-gradient-to-r from-gray-50 to-gray-100 border-2 border-gray-200 p-4 rounded-xl text-center h-full flex flex-col justify-center">
                <div class="flex justify-center">
                    <?php echo BarcodeGenerator::generateBarcode($barcodeValue, 2, 60); ?>
                </div>
            </div>
            <?php else : ?>
            <p class="text-sm text-gray-500">No barcode available.</p>
            <?php endif; ?>
        </div>

        <div class="bg-white shadow-xl rounded-xl p-6 fade-in-scale" style="animation-delay: 0.32s">
            <div class="border-2 border-purple-200 p-4 rounded-xl text-center cursor-pointer hover:shadow-lg transition-all duration-300 hover:scale-105 qr-code-card h-full" onclick="openQRLightbox()" title="Click to enlarge">
                <div id="qrCodeSmall">
                    <?php
                    // Generate QR code once and store it
                    $qrCodeSVG = BarcodeGenerator::generateQRCode($qrData, 180);
                    echo $qrCodeSVG;
                    ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Inventory by Location Table -->
    <div class="bg-white shadow-2xl rounded-xl overflow-hidden fade-in-scale" style="animation-delay: 0.4s">
        <div class="bg-gradient-to-r from-blue-500 to-cyan-600 p-6">
            <h2 class="text-xl font-bold text-white flex items-center">
                <i class="fas fa-warehouse mr-3"></i>
                Stock by Location & Size
            </h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full">
                <thead>
                    <tr class="bg-gradient-to-r from-gray-100 to-gray-200">
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-map-marker-alt mr-2 text-red-500"></i>
                                Location
                            </div>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-ruler mr-2 text-purple-500"></i>
                                Size
                            </div>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-cubes mr-2 text-blue-500"></i>
                                Quantity
                            </div>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-flag mr-2 text-orange-500"></i>
                                Min Qty
                            </div>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-traffic-light mr-2 text-green-500"></i>
                                Status
                            </div>
                        </th>
                        <th class="px-6 py-4 text-left">
                            <div class="flex items-center text-xs font-bold text-gray-700 uppercase tracking-wider">
                                <i class="fas fa-clock mr-2 text-gray-500"></i>
                                Last Updated
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php foreach ($inventory as $index => $item) : ?>
                    <tr class="hover:bg-gradient-to-r hover:from-blue-50 hover:to-cyan-50 transition-all duration-300" style="animation: fadeInScale 0.5s ease-out <?php echo $index * 0.1; ?>s both">
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="flex items-center">
                                <div class="bg-gradient-to-r from-red-400 to-rose-500 p-1.5 rounded mr-2">
                                    <i class="fas fa-warehouse text-white text-xs"></i>
                                </div>
                                <span class="font-medium text-gray-900"><?php echo htmlspecialchars($item['location_name']); ?></span>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="px-3 py-1 inline-flex text-xs font-semibold rounded-full bg-gradient-to-r from-purple-100 to-pink-100 text-purple-800">
                                <?php echo htmlspecialchars($item['size'] ?? 'One Size'); ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <span class="text-lg font-bold <?php echo $item['quantity'] > $item['min_quantity'] * 2 ? 'text-green-600' : ($item['quantity'] > $item['min_quantity'] ? 'text-yellow-600' : 'text-red-600'); ?>">
                                <?php echo $item['quantity']; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-gray-600">
                            <?php echo $item['min_quantity']; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <?php if ($item['quantity'] <= $item['min_quantity']) : ?>
                            <span class="px-3 py-1 inline-flex text-xs font-bold rounded-full bg-gradient-to-r from-red-400 to-rose-600 text-white animate-pulse">
                                <i class="fas fa-exclamation-triangle mr-1"></i> Low Stock
                            </span>
                            <?php elseif ($item['quantity'] <= $item['min_quantity'] * 2) : ?>
                            <span class="px-3 py-1 inline-flex text-xs font-bold rounded-full bg-gradient-to-r from-yellow-400 to-orange-500 text-white">
                                <i class="fas fa-exclamation mr-1"></i> Warning
                            </span>
                            <?php else : ?>
                            <span class="px-3 py-1 inline-flex text-xs font-bold rounded-full bg-gradient-to-r from-green-400 to-emerald-500 text-white">
                                <i class="fas fa-check-circle mr-1"></i> In Stock
                            </span>
                            <?php endif; ?>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            <i class="far fa-calendar mr-1"></i>
                            <?php echo date('M d, Y', strtotime($item['last_updated'])); ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    
                    <?php if (empty($inventory)) : ?>
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center">
                            <div class="flex flex-col items-center">
                                <div class="bg-gradient-to-r from-gray-200 to-gray-300 p-6 rounded-full mb-4">
                                    <i class="fas fa-box-open text-4xl text-gray-500"></i>
                                </div>
                                <p class="text-lg font-medium text-gray-600">No inventory records found</p>
                                <a href="<?php echo APP_URL; ?>/stock/add?product_id=<?php echo $product['id']; ?>" 
                                   class="mt-4 bg-gradient-to-r from-green-500 to-emerald-600 text-white font-bold py-2 px-6 rounded-lg hover:shadow-lg transition-all duration-200">
                                    <i class="fas fa-plus mr-2"></i> Add Stock
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<!-- QR Code Lightbox -->
<div id="qrLightbox" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.9); z-index: 9999; justify-content: center; align-items: center;" onclick="closeQRLightbox()">
    <div style="position: relative; max-width: 90%; max-height: 90%; background: white; padding: 30px; border-radius: 20px; box-shadow: 0 20px 60px rgba(0,0,0,0.5);" onclick="event.stopPropagation()">
        <button onclick="closeQRLightbox()" style="position: absolute; top: 10px; right: 10px; background: #dc3545; color: white; border: none; width: 40px; height: 40px; border-radius: 50%; font-size: 24px; cursor: pointer; display: flex; align-items: center; justify-content: center; font-weight: bold; transition: all 0.3s;" onmouseover="this.style.transform='scale(1.1)'" onmouseout="this.style.transform='scale(1)'">
            ×
        </button>
        <div style="text-align: center;">
            <h2 style="margin-bottom: 20px; color: #333;">
                <i class="fas fa-qrcode" style="color: #667eea;"></i> Scan QR Code
            </h2>
            <div id="qrCodeLarge" style="display: inline-block; padding: 20px; background: white; border-radius: 15px; box-shadow: 0 5px 15px rgba(0,0,0,0.1);">
                <!-- QR Code will be inserted here by JavaScript -->
            </div>
            <p style="margin-top: 20px; color: #666; font-size: 14px;">
                <i class="fas fa-mobile-alt"></i> Scan with your mobile device to view product details
            </p>
            <p style="margin-top: 10px; color: #999; font-size: 12px;">
                Product: <strong><?php echo htmlspecialchars($product['part_number']); ?></strong>
            </p>
        </div>
    </div>
</div>

<script>
function openQRLightbox() {
    // Clone the small QR code and scale it up
    const smallQR = document.getElementById('qrCodeSmall');
    const largeQR = document.getElementById('qrCodeLarge');
    
    // Copy the SVG content
    largeQR.innerHTML = smallQR.innerHTML;
    
    // Scale up the SVG
    const svg = largeQR.querySelector('svg');
    if (svg) {
        svg.setAttribute('width', '400');
        svg.setAttribute('height', '400');
    }
    
    document.getElementById('qrLightbox').style.display = 'flex';
    document.body.style.overflow = 'hidden';
}

function closeQRLightbox() {
    document.getElementById('qrLightbox').style.display = 'none';
    document.body.style.overflow = 'auto';
}

// Close lightbox on ESC key
document.addEventListener('keydown', function(event) {
    if (event.key === 'Escape') {
        closeQRLightbox();
    }
});
</script>
